/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.VClassGroupTemplateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrowseController
extends FreemarkerHttpServlet {
    static final long serialVersionUID = 2006030721126L;
    private static final Log log = LogFactory.getLog(BrowseController.class);
    private static final String TEMPLATE_DEFAULT = "classGroups.ftl";

    @Override
    protected String getTitle(String siteName, VitroRequest vreq) {
        return "Index of Contents";
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String templateName = TEMPLATE_DEFAULT;
        List<VClassGroup> groups = null;
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)vreq);
        groups = vcgc.getGroups();
        ArrayList<VClassGroupTemplateModel> vcgroups = new ArrayList<VClassGroupTemplateModel>(groups.size());
        for (VClassGroup group : groups) {
            vcgroups.add(new VClassGroupTemplateModel(group));
        }
        body.put("classGroups", vcgroups);
        return new TemplateResponseValues(templateName, body);
    }
}

