/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.TemplateProcessingHelper;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContactMailController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(ContactMailController.class);
    private static final long serialVersionUID = 1L;
    private static final String SPAM_MESSAGE = "Your message was flagged as spam.";
    private static final String WEB_USERNAME_PARAM = "webusername";
    private static final String WEB_USEREMAIL_PARAM = "webuseremail";
    private static final String COMMENTS_PARAM = "s34gfd88p9x1";
    private static final String TEMPLATE_CONFIRMATION = "contactForm-confirmation.ftl";
    private static final String TEMPLATE_EMAIL = "contactForm-email.ftl";
    private static final String TEMPLATE_BACKUP = "contactForm-backup.ftl";
    private static final String TEMPLATE_ERROR = "contactForm-error.ftl";
    private static final String TEMPLATE_FORM = "contactForm-form.ftl";
    private static final String EMAIL_JOURNAL_FILE_DIR = "emailJournal";
    private static final String EMAIL_JOURNAL_FILE_NAME = "contactFormEmails.html";

    @Override
    protected String getTitle(String siteName, VitroRequest vreq) {
        return siteName + " Feedback Form";
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        String captchaDisplay;
        if (!FreemarkerEmailFactory.isConfigured((HttpServletRequest)vreq)) {
            return this.errorNoSmtpServer();
        }
        String[] recipients = this.figureRecipients(vreq);
        if (recipients.length == 0) {
            return this.errorNoRecipients();
        }
        String webusername = this.nonNullAndTrim((HttpServletRequest)vreq, WEB_USERNAME_PARAM);
        String webuseremail = this.nonNullAndTrim((HttpServletRequest)vreq, WEB_USEREMAIL_PARAM);
        String comments = this.nonNullAndTrim((HttpServletRequest)vreq, COMMENTS_PARAM);
        String formType = this.nonNullAndTrim((HttpServletRequest)vreq, "DeliveryType");
        String captchaInput = this.nonNullAndTrim((HttpServletRequest)vreq, "defaultReal");
        String errorMsg = this.validateInput(webusername, webuseremail, comments, captchaInput, captchaDisplay = this.nonNullAndTrim((HttpServletRequest)vreq, "defaultRealHash"));
        if (errorMsg != null) {
            return this.errorParametersNotValid(errorMsg, webusername, webuseremail, comments);
        }
        String spamReason = this.checkForSpam(comments, formType);
        if (spamReason != null) {
            return this.errorSpam();
        }
        return this.processValidRequest(vreq, webusername, webuseremail, recipients, comments);
    }

    private String[] figureRecipients(VitroRequest vreq) {
        String contactMailAddresses = vreq.getAppBean().getContactMail().trim();
        if (contactMailAddresses == null || contactMailAddresses.isEmpty()) {
            return new String[0];
        }
        return contactMailAddresses.split(",");
    }

    private ResponseValues processValidRequest(VitroRequest vreq, String webusername, String webuseremail, String[] recipients, String comments) throws Error {
        String statusMsg = null;
        ApplicationBean appBean = vreq.getAppBean();
        String deliveryfrom = "Message from the " + appBean.getApplicationName() + " Contact Form";
        String originalReferer = this.getOriginalRefererFromSession(vreq);
        String msgText = this.composeEmail(webusername, webuseremail, comments, deliveryfrom, originalReferer, vreq.getRemoteAddr(), (HttpServletRequest)vreq);
        try {
            FileWriter fw = new FileWriter(this.locateTheJournalFile(), true);
            PrintWriter outFile = new PrintWriter(fw);
            this.writeBackupCopy(outFile, msgText, (HttpServletRequest)vreq);
            try {
                Session s = FreemarkerEmailFactory.getEmailSession((HttpServletRequest)vreq);
                this.sendMessage(s, webuseremail, webusername, recipients, deliveryfrom, msgText);
            }
            catch (AddressException e) {
                statusMsg = "Please supply a valid email address.";
                outFile.println(statusMsg);
                outFile.println(e.getMessage());
            }
            catch (SendFailedException e) {
                statusMsg = "The system was unable to deliver your mail.  Please try again later.  [SEND FAILED]";
                outFile.println(statusMsg);
                outFile.println(e.getMessage());
            }
            catch (MessagingException e) {
                statusMsg = "The system was unable to deliver your mail.  Please try again later.  [MESSAGING]";
                outFile.println(statusMsg);
                outFile.println(e.getMessage());
                e.printStackTrace();
            }
            outFile.close();
        }
        catch (IOException e) {
            log.error((Object)"Can't open file to write email backup");
        }
        if (statusMsg == null) {
            return new TemplateResponseValues(TEMPLATE_CONFIRMATION);
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("errorMessage", statusMsg);
        return new TemplateResponseValues(TEMPLATE_ERROR, body);
    }

    private File locateTheJournalFile() {
        boolean created;
        File homeDir = ApplicationUtils.instance().getHomeDirectory().getPath().toFile();
        File journalDir = new File(homeDir, EMAIL_JOURNAL_FILE_DIR);
        if (!journalDir.exists() && !(created = journalDir.mkdir())) {
            throw new IllegalStateException("Unable to create email journal directory at '" + journalDir + "'");
        }
        File journalFile = new File(journalDir, EMAIL_JOURNAL_FILE_NAME);
        return journalFile;
    }

    private String getOriginalRefererFromSession(VitroRequest vreq) {
        String originalReferer = (String)vreq.getSession().getAttribute("contactFormReferer");
        if (originalReferer != null) {
            vreq.getSession().removeAttribute("contactFormReferer");
        } else {
            originalReferer = "none";
        }
        return originalReferer;
    }

    public String stripProtocol(String in) {
        if (in == null) {
            return "";
        }
        return in.replaceAll("http://", "host: ");
    }

    private String composeEmail(String webusername, String webuseremail, String comments, String deliveryfrom, String originalReferer, String ipAddr, HttpServletRequest request) {
        HashMap<String, Object> email = new HashMap<String, Object>();
        String template = TEMPLATE_EMAIL;
        email.put("subject", deliveryfrom);
        email.put("name", webusername);
        email.put("emailAddress", webuseremail);
        email.put("comments", comments);
        email.put("ip", ipAddr);
        if (originalReferer != null && !originalReferer.equals("none")) {
            email.put("referrer", UrlBuilder.urlDecode(originalReferer));
        }
        try {
            return this.processTemplateToString(template, email, request);
        }
        catch (TemplateProcessingHelper.TemplateProcessingException e) {
            log.error((Object)("Error processing email text through template: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private void writeBackupCopy(PrintWriter outFile, String msgText, HttpServletRequest request) {
        HashMap<String, Object> backup = new HashMap<String, Object>();
        String template = TEMPLATE_BACKUP;
        Calendar cal = Calendar.getInstance();
        backup.put("datetime", cal.getTime().toString());
        backup.put("msgText", msgText);
        try {
            String backupText = this.processTemplateToString(template, backup, request);
            outFile.print(backupText);
            outFile.flush();
        }
        catch (TemplateProcessingHelper.TemplateProcessingException e) {
            log.error((Object)("Error processing backup text throug template: " + e.getMessage()), (Throwable)e);
        }
    }

    private void sendMessage(Session s, String webuseremail, String webusername, String[] recipients, String deliveryfrom, String msgText) throws AddressException, SendFailedException, MessagingException {
        MimeMessage msg = new MimeMessage(s);
        try {
            msg.setReplyTo(new Address[]{new InternetAddress(webuseremail, webusername)});
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Can't set message reply with personal name " + webusername + " due to UnsupportedEncodingException"));
        }
        InternetAddress[] address = new InternetAddress[recipients.length];
        for (int i = 0; i < recipients.length; ++i) {
            address[i] = new InternetAddress(recipients[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        if (address != null && address.length > 0) {
            msg.setFrom((Address)address[0]);
        } else {
            msg.setFrom((Address)new InternetAddress(webuseremail));
        }
        msg.setSubject(deliveryfrom);
        msg.setContent((Object)msgText, "text/html; charset=UTF-8");
        msg.setSentDate(new Date());
        Transport.send((Message)msg);
    }

    private String nonNullAndTrim(HttpServletRequest req, String key) {
        String value = req.getParameter(key);
        return value == null ? "" : value.trim();
    }

    private String validateInput(String webusername, String webuseremail, String comments, String captchaInput, String captchaDisplay) {
        if (webusername.isEmpty()) {
            return "Please enter a value in the Full name field.";
        }
        if (webuseremail.isEmpty()) {
            return "Please enter a valid email address.";
        }
        if (comments.isEmpty()) {
            return "Please enter your comments or questions in the space provided.";
        }
        if (captchaInput.isEmpty()) {
            return "Please enter the contents of the gray box in the security field provided.";
        }
        if (!this.captchaHash(captchaInput).equals(captchaDisplay)) {
            return "The value you entered in the security field did not match the letters displayed in the gray box.";
        }
        return null;
    }

    private String checkForSpam(String comments, String formType) {
        if (!"contact".equals(formType)) {
            return "The form specifies no delivery type.";
        }
        if (comments.indexOf("[/url]") > -1 || comments.indexOf("[/URL]") > -1 || comments.indexOf("[url=") > -1 || comments.indexOf("[URL=") > -1) {
            return "The message contained blog link markup.";
        }
        if (comments.length() < 15) {
            return "The message was too short.";
        }
        return null;
    }

    private String captchaHash(String value) {
        int hash = 5381;
        value = value.toUpperCase();
        for (int i = 0; i < value.length(); ++i) {
            hash = (hash << 5) + hash + value.charAt(i);
        }
        return String.valueOf(hash);
    }

    private ResponseValues errorNoSmtpServer() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("errorMessage", "This application has not yet been configured to send mail. Email properties must be specified in the configuration properties file.");
        return new TemplateResponseValues(TEMPLATE_ERROR, body);
    }

    private ResponseValues errorNoRecipients() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("errorMessage", "To establish the Contact Us mail capability the system administrators must specify at least one email address.");
        return new TemplateResponseValues(TEMPLATE_ERROR, body);
    }

    private ResponseValues errorParametersNotValid(String errorMsg, String webusername, String webuseremail, String comments) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("errorMessage", errorMsg);
        body.put("formAction", "submitFeedback");
        body.put(WEB_USERNAME_PARAM, webusername);
        body.put(WEB_USEREMAIL_PARAM, webuseremail);
        body.put("comments", comments);
        return new TemplateResponseValues(TEMPLATE_FORM, body);
    }

    private ResponseValues errorSpam() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("errorMessage", SPAM_MESSAGE);
        return new TemplateResponseValues(TEMPLATE_ERROR, body);
    }
}

