/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelimitingTemplateLoader
implements TemplateLoader {
    private static final Log log = LogFactory.getLog(DelimitingTemplateLoader.class);
    private final TemplateLoader innerLoader;

    public DelimitingTemplateLoader(TemplateLoader innerLoader) {
        this.innerLoader = innerLoader;
    }

    public Object findTemplateSource(String name) throws IOException {
        Object innerTS = this.innerLoader.findTemplateSource(name);
        log.debug((Object)("template source for '" + name + "' is '" + innerTS + "'"));
        if (innerTS == null) {
            return null;
        }
        return new DelimitingTemplateSource(name, innerTS);
    }

    public long getLastModified(Object templateSource) {
        DelimitingTemplateSource dts = (DelimitingTemplateSource)templateSource;
        return this.innerLoader.getLastModified(dts.ts);
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        DelimitingTemplateSource dts = (DelimitingTemplateSource)templateSource;
        StringBuilder sb = new StringBuilder();
        sb.append("<!-- FM_BEGIN ").append(dts.name).append(" -->");
        sb.append((CharSequence)this.readTemplateSource(encoding, dts.ts));
        sb.append("<!-- FM_END ").append(dts.name).append(" -->\n");
        return new StringReader(sb.toString());
    }

    private StringBuilder readTemplateSource(String encoding, Object ts) throws IOException {
        int howmany;
        StringBuilder sb = new StringBuilder();
        Reader reader = this.innerLoader.getReader(ts, encoding);
        char[] buffer = new char[8192];
        while (-1 != (howmany = reader.read(buffer))) {
            sb.append(buffer, 0, howmany);
        }
        return sb;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        DelimitingTemplateSource dts = (DelimitingTemplateSource)templateSource;
        this.innerLoader.closeTemplateSource(dts.ts);
    }

    private static class DelimitingTemplateSource {
        public final String name;
        public final Object ts;

        public DelimitingTemplateSource(String name, Object ts) {
            if (name == null) {
                throw new NullPointerException("name may not be null.");
            }
            if (ts == null) {
                throw new NullPointerException("ts may not be null.");
            }
            this.name = name;
            this.ts = ts;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.ts.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!o.getClass().equals(this.getClass())) {
                return false;
            }
            DelimitingTemplateSource that = (DelimitingTemplateSource)o;
            return this.name.equals(that.name) && this.ts.equals(that.ts);
        }
    }
}

