/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.TestController;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateModelException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DumpTestController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TestController.class);
    private static final String TEMPLATE_DEFAULT = "test.ftl";

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", "Freemarker Test");
        body.put("dog", "Rover");
        body.put("int", 7);
        body.put("bool", false);
        body.put("now", new java.util.Date());
        Date date = new Date(1302297332043L);
        body.put("date", date);
        Time time = new Time(1302297332043L);
        body.put("time", time);
        Timestamp ts = new Timestamp(1302297332043L);
        body.put("timestamp", ts);
        ArrayList<String> fruit = new ArrayList<String>();
        fruit.add("apples");
        fruit.add("bananas");
        fruit.add("peaches");
        body.put("fruit", fruit);
        ArrayList<Object> mixedList = new ArrayList<Object>();
        String myString = "apples";
        mixedList.add(myString);
        int myInt = 4;
        mixedList.add(myInt);
        boolean myBool = true;
        mixedList.add(myBool);
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("dog");
        myList.add("cat");
        myList.add("elephant");
        mixedList.add(myList);
        body.put("mixedList", mixedList);
        HashSet<Integer> odds = new HashSet<Integer>();
        for (int i = 0; i <= 10; ++i) {
            if (i % 2 != 1) continue;
            odds.add(i);
        }
        body.put("oddNums", new SimpleCollection(odds));
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("Albany", "New York");
        myMap.put("St. Paul", "Minnesota");
        myMap.put("Austin", "Texas");
        myMap.put("Sacramento", "California");
        myMap.put("Richmond", "Virginia");
        body.put("capitals", myMap);
        HashMap<String, Object> mixedMap = new HashMap<String, Object>();
        mixedMap.put("myString", myString);
        mixedMap.put("myBoolean", myBool);
        mixedMap.put("myNumber", myInt);
        java.util.Date myDate = new java.util.Date();
        mixedMap.put("myDate", myDate);
        mixedMap.put("myList", myList);
        mixedMap.put("capitals", myMap);
        body.put("mixedMap", mixedMap);
        Employee jdoe = this.getEmployee();
        body.put("employeeLimited", jdoe);
        try {
            body.put("employeeInvisible", this.wrap((Object)jdoe, 3));
            body.put("employeeFull", this.wrap((Object)jdoe, 1));
        }
        catch (TemplateModelException e) {
            e.printStackTrace();
        }
        return new TemplateResponseValues(TEMPLATE_DEFAULT, body);
    }

    @Override
    protected String getTitle(String siteName, VitroRequest vreq) {
        return "Test";
    }

    private Employee getEmployee() {
        Calendar c = Calendar.getInstance();
        c.set(1982, 4, 5);
        c = DateUtils.truncate((Calendar)c, (int)5);
        Employee jdoe = new Employee("John", "Doe", 34523, c.getTime());
        jdoe.setFavoriteColors("blue", "green");
        jdoe.setSalary(65000.0f);
        c.clear();
        c.set(1975, 9, 25);
        c = DateUtils.truncate((Calendar)c, (int)5);
        Employee jsmith = new Employee("Jane", "Smith", 78234, c.getTime());
        jsmith.setFavoriteColors("red", "orange");
        jdoe.setSupervisor(jsmith);
        return jdoe;
    }

    public static class Employee {
        private static int count = 0;
        private String firstName;
        private String lastName;
        private String nickname;
        private java.util.Date birthdate;
        private boolean married;
        private int id;
        private String middleName;
        private List<String> favoriteColors;
        private Employee supervisor;
        private float salary;

        Employee(String firstName, String lastName, int id, java.util.Date birthdate) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.middleName = null;
            this.birthdate = birthdate;
            this.married = true;
            this.id = id;
            this.nickname = "";
            this.favoriteColors = new ArrayList<String>();
            ++count;
        }

        protected void setSupervisor(Employee supervisor) {
            this.supervisor = supervisor;
        }

        void setSalary(float salary) {
            this.salary = salary;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public void setFavoriteColors(String ... colors) {
            for (String color : colors) {
                this.favoriteColors.add(color);
            }
        }

        float getSalary() {
            return this.salary;
        }

        public static int getEmployeeCount() {
            return count;
        }

        public String getFullName() {
            return this.firstName + " " + this.lastName;
        }

        public String getName(String which) {
            return which == "first" ? this.firstName : this.lastName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public String getNickname() {
            return this.nickname;
        }

        public java.util.Date getBirthdate() {
            return this.birthdate;
        }

        public int getId() {
            return this.id;
        }

        public boolean isMarried() {
            return this.married;
        }

        @Deprecated
        public int getFormerId() {
            return this.id % 10000;
        }

        public Employee getSupervisor() {
            return this.supervisor;
        }

        public List<String> getFavoriteColors() {
            return this.favoriteColors;
        }
    }
}

