/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.TemplateProcessingHelper;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerComponentGenerator
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FreemarkerComponentGenerator.class);
    private static ServletContext context = null;

    FreemarkerComponentGenerator(HttpServletRequest request) {
        VitroRequest vreq = new VitroRequest(request);
        Map<String, Object> map = this.getPageTemplateValues(vreq);
        request.setAttribute("ftl_head", (Object)this.getHead("head", map, (HttpServletRequest)vreq));
        request.setAttribute("ftl_identity", (Object)this.get("identity", map, (HttpServletRequest)vreq));
        request.setAttribute("ftl_menu", (Object)this.get("menu", map, (HttpServletRequest)vreq));
        request.setAttribute("ftl_search", (Object)this.get("search", map, (HttpServletRequest)vreq));
        request.setAttribute("ftl_footer", (Object)this.get("footer", map, (HttpServletRequest)vreq));
        request.setAttribute("ftl_googleAnalytics", (Object)this.get("googleAnalytics", map, (HttpServletRequest)vreq));
    }

    private String get(String templateName, Map<String, Object> root, HttpServletRequest request) {
        templateName = templateName + ".ftl";
        try {
            return this.processTemplate(templateName, root, request).toString();
        }
        catch (TemplateProcessingHelper.TemplateProcessingException e) {
            log.error((Object)("Error processing template " + templateName + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private String getHead(String templateName, Map<String, Object> root, HttpServletRequest request) {
        String title = (String)request.getAttribute("title");
        if (!StringUtils.isEmpty((String)title)) {
            root.put("title", title);
        }
        return this.get(templateName, root, request);
    }

    public ServletContext getServletContext() {
        return context;
    }

    protected static void setServletContext(ServletContext sc) {
        context = sc;
    }
}

