/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractObjectPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.DropObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ImageUploadHelper;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ForwardResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.FileInfo;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.ImageInfo;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileStorage;
import edu.cornell.mannlib.vitro.webapp.modules.imageProcessor.ImageProcessor;
import edu.cornell.mannlib.vitro.webapp.web.images.PlaceholderUtil;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageUploadController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImageUploadController.class);
    private static final String ATTRIBUTE_REFERRING_PAGE = "ImageUploadController.referringPage";
    private static final String ERROR_CODE_UNRECOGNIZED_URI = "imageUpload.errorUnrecognizedURI";
    private static final String ERROR_CODE_NO_URI = "imageUpload.errorNoURI";
    private static final String ERROR_CODE_FILE_TOO_BIG = "imageUpload.errorFileTooBig";
    public static final int MAXIMUM_FILE_SIZE = 0x600000;
    public static final int THUMBNAIL_HEIGHT = 200;
    public static final int THUMBNAIL_WIDTH = 200;
    public static final String PARAMETER_ACTION = "action";
    public static final String PARAMETER_ENTITY_URI = "entityUri";
    public static final String PARAMETER_UPLOADED_FILE = "datafile";
    public static final String ACTION_UPLOAD = "upload";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_DELETE_EDIT = "deleteEdit";
    public static final String BODY_TITLE = "title";
    public static final String BODY_ENTITY_NAME = "entityName";
    public static final String BODY_MAIN_IMAGE_URL = "imageUrl";
    public static final String BODY_MAIN_IMAGE_HEIGHT = "imageHeight";
    public static final String BODY_MAIN_IMAGE_WIDTH = "imageWidth";
    public static final String BODY_THUMBNAIL_URL = "thumbnailUrl";
    public static final String BODY_CANCEL_URL = "cancelUrl";
    public static final String BODY_DELETE_URL = "deleteUrl";
    public static final String BODY_FORM_ACTION = "formAction";
    public static final String BODY_ERROR_MESSAGE = "errorMessage";
    public static final String BODY_MAX_FILE_SIZE = "maxFileSize";
    public static final String BODY_THUMBNAIL_WIDTH = "thumbnailWidth";
    public static final String BODY_THUMBNAIL_HEIGHT = "thumbnailHeight";
    public static final String TEMPLATE_NEW = "imageUpload-newImage.ftl";
    public static final String TEMPLATE_REPLACE = "imageUpload-replaceImage.ftl";
    public static final String TEMPLATE_CROP = "imageUpload-cropImage.ftl";
    public static final String TEMPLATE_ERROR = "error-standard.ftl";
    private static final String URL_HERE = UrlBuilder.getUrl("/uploadImages");
    private static final String TEXT_STRING_UPLOAD_TITLE = "upload_page_title";
    private static final String TEXT_STRING_UPLOAD_TITLE_WITH_NAME = "upload_page_title_with_name";
    private static final String TEXT_STRING_REPLACE_TITLE = "replace_page_title";
    private static final String TEXT_STRING_REPLACE_TITLE_WITH_NAME = "replace_page_title_with_name";
    private static final String TEXT_STRING_CROP_TITLE = "crop_page_title";
    private static final String TEXT_STRING_CROP_TITLE_WITH_NAME = "crop_page_title_with_name";
    private FileStorage fileStorage;

    public void init() throws ServletException {
        super.init();
        this.fileStorage = ApplicationUtils.instance().getFileStorage();
    }

    @Override
    public long maximumMultipartFileSize() {
        return 0x600000L;
    }

    @Override
    public boolean stashFileSizeException() {
        return true;
    }

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        try {
            String action = vreq.getParameter(PARAMETER_ACTION);
            Individual entity = this.validateEntityUri(vreq);
            String imageUri = entity.getMainImageUri();
            Property indMainImage = new Property();
            indMainImage.setURI("http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage");
            AbstractObjectPropertyStatementAction ra = ACTION_DELETE.equals(action) || ACTION_DELETE_EDIT.equals(action) ? new DropObjectPropertyStatement(vreq.getJenaOntModel(), entity.getURI(), indMainImage, imageUri) : (imageUri != null ? new EditObjectPropertyStatement(vreq.getJenaOntModel(), entity.getURI(), indMainImage, imageUri) : new AddObjectPropertyStatement(vreq.getJenaOntModel(), entity.getURI(), indMainImage, RequestedAction.SOME_URI));
            return ra;
        }
        catch (UserMistakeException e) {
            return AuthorizationRequest.UNAUTHORIZED;
        }
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        Individual entity = null;
        try {
            entity = this.validateEntityUri(vreq);
            this.checkForFileTooBigException(vreq);
            String action = vreq.getParameter(PARAMETER_ACTION);
            if (ACTION_UPLOAD.equals(action)) {
                return this.doUploadImage(vreq, entity);
            }
            if (ACTION_SAVE.equals(action)) {
                return this.doCreateThumbnail(vreq, entity);
            }
            if (ACTION_DELETE.equals(action)) {
                this.captureReferringUrl(vreq);
                return this.doDeleteImage(vreq, entity);
            }
            if (ACTION_DELETE_EDIT.equals(action)) {
                return this.doDeleteThenEdit(vreq, entity);
            }
            this.captureReferringUrl(vreq);
            return this.doIntroScreen(vreq, entity);
        }
        catch (UserMistakeException e) {
            return this.showAddImagePageWithError(vreq, entity, e.formatMessage((HttpServletRequest)vreq));
        }
        catch (Exception e) {
            return new ExceptionResponseValues(e);
        }
    }

    private void checkForFileTooBigException(VitroRequest vreq) throws UserMistakeException {
        if (vreq.hasFileSizeException()) {
            int limit = 6;
            throw new UserMistakeException(ERROR_CODE_FILE_TOO_BIG, limit);
        }
    }

    private void captureReferringUrl(VitroRequest vreq) {
        String referrer = vreq.getHeader("Referer");
        if (referrer == null) {
            vreq.getSession().removeAttribute(ATTRIBUTE_REFERRING_PAGE);
        } else {
            vreq.getSession().setAttribute(ATTRIBUTE_REFERRING_PAGE, (Object)referrer);
        }
    }

    private ResponseValues doIntroScreen(VitroRequest vreq, Individual entity) {
        ImageInfo imageInfo = ImageInfo.instanceFromEntityUri(vreq.getUnfilteredWebappDaoFactory(), entity);
        if (imageInfo == null) {
            return this.showAddImagePage(vreq, entity);
        }
        return this.showReplaceImagePage(vreq, entity, imageInfo);
    }

    private ResponseValues doUploadImage(VitroRequest vreq, Individual entity) {
        ImageUploadHelper helper = new ImageUploadHelper(this.fileStorage, vreq.getUnfilteredWebappDaoFactory(), this.getServletContext());
        try {
            FileItem fileItem = helper.validateImageFromRequest(vreq);
            FileInfo fileInfo = helper.storeNewImage(fileItem, vreq);
            ImageProcessor.Dimensions size = helper.getNewImageSize(fileInfo);
            return this.showCropImagePage(vreq, entity, fileInfo.getBytestreamAliasUrl(), size);
        }
        catch (UserMistakeException e) {
            return this.showErrorMessage(vreq, entity, e.formatMessage((HttpServletRequest)vreq));
        }
    }

    private ResponseValues showErrorMessage(VitroRequest vreq, Individual entity, String message) {
        ImageInfo imageInfo = ImageInfo.instanceFromEntityUri(vreq.getUnfilteredWebappDaoFactory(), entity);
        if (imageInfo == null) {
            return this.showAddImagePageWithError(vreq, entity, message);
        }
        return this.showReplaceImagePageWithError(vreq, entity, imageInfo, message);
    }

    private ResponseValues doCreateThumbnail(VitroRequest vreq, Individual entity) {
        ImageUploadHelper helper = new ImageUploadHelper(this.fileStorage, vreq.getUnfilteredWebappDaoFactory(), this.getServletContext());
        try {
            ImageProcessor.CropRectangle crop = this.validateCropCoordinates(vreq);
            FileInfo newImage = helper.getNewImageInfo(vreq);
            FileInfo thumbnail = helper.generateThumbnail(crop, newImage);
            helper.removeExistingImage(entity);
            helper.storeImageFiles(entity, newImage, thumbnail);
            return this.showExitPage(vreq, entity);
        }
        catch (UserMistakeException e) {
            return this.showErrorMessage(vreq, entity, e.formatMessage((HttpServletRequest)vreq));
        }
    }

    private ResponseValues doDeleteImage(VitroRequest vreq, Individual entity) {
        ImageUploadHelper helper = new ImageUploadHelper(this.fileStorage, vreq.getUnfilteredWebappDaoFactory(), this.getServletContext());
        helper.removeExistingImage(entity);
        return this.showExitPage(vreq, entity);
    }

    private ResponseValues doDeleteThenEdit(VitroRequest vreq, Individual entity) {
        ImageUploadHelper helper = new ImageUploadHelper(this.fileStorage, vreq.getUnfilteredWebappDaoFactory(), this.getServletContext());
        helper.removeExistingImage(entity);
        return this.showAddImagePage(vreq, entity);
    }

    private Individual validateEntityUri(VitroRequest vreq) throws UserMistakeException {
        String entityUri = vreq.getParameter(PARAMETER_ENTITY_URI);
        if (entityUri == null) {
            throw new UserMistakeException(ERROR_CODE_NO_URI, new Object[0]);
        }
        Individual entity = vreq.getUnfilteredWebappDaoFactory().getIndividualDao().getIndividualByURI(entityUri);
        if (entity == null) {
            throw new UserMistakeException(ERROR_CODE_UNRECOGNIZED_URI, entityUri);
        }
        return entity;
    }

    private ImageProcessor.CropRectangle validateCropCoordinates(VitroRequest vreq) {
        int x = this.getIntegerParameter((HttpServletRequest)vreq, "x", 0);
        int y = this.getIntegerParameter((HttpServletRequest)vreq, "y", 0);
        int h = this.getIntegerParameter((HttpServletRequest)vreq, "h", 200);
        int w = this.getIntegerParameter((HttpServletRequest)vreq, "w", 200);
        return new ImageProcessor.CropRectangle(x, y, h, w);
    }

    private int getIntegerParameter(HttpServletRequest req, String key, int defaultValue) {
        String string = req.getParameter(key);
        if (string == null || string.isEmpty()) {
            log.debug((Object)("No value for '" + key + "'; using default value = " + defaultValue));
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Value for '" + key + "' was not a valid integer: '" + string + "'; using default value = " + defaultValue));
            return defaultValue;
        }
    }

    private TemplateResponseValues showAddImagePage(VitroRequest vreq, Individual entity) {
        String formAction = entity == null ? "" : this.formAction(entity.getURI(), ACTION_UPLOAD);
        String cancelUrl = entity == null ? "" : this.exitPageUrl(vreq, entity.getURI());
        String placeholderUrl = entity == null ? "" : UrlBuilder.getUrl(PlaceholderUtil.getPlaceholderImagePathForIndividual(vreq, entity.getURI()));
        TemplateResponseValues rv = new TemplateResponseValues(TEMPLATE_NEW);
        rv.put(BODY_THUMBNAIL_URL, placeholderUrl);
        rv.put(BODY_FORM_ACTION, formAction);
        rv.put(BODY_CANCEL_URL, cancelUrl);
        rv.put(BODY_TITLE, this.figureUploadPageTitle((HttpServletRequest)vreq, entity));
        rv.put(BODY_MAX_FILE_SIZE, 6);
        rv.put(BODY_THUMBNAIL_HEIGHT, 200);
        rv.put(BODY_THUMBNAIL_WIDTH, 200);
        return rv;
    }

    private TemplateResponseValues showAddImagePageWithError(VitroRequest vreq, Individual entity, String message) {
        return this.showAddImagePage(vreq, entity).put(BODY_ERROR_MESSAGE, message);
    }

    private TemplateResponseValues showReplaceImagePage(VitroRequest vreq, Individual entity, ImageInfo imageInfo) {
        TemplateResponseValues rv = new TemplateResponseValues(TEMPLATE_REPLACE);
        rv.put(BODY_THUMBNAIL_URL, UrlBuilder.getUrl(imageInfo.getThumbnail().getBytestreamAliasUrl()));
        rv.put(BODY_DELETE_URL, this.formAction(entity.getURI(), ACTION_DELETE_EDIT));
        rv.put(BODY_FORM_ACTION, this.formAction(entity.getURI(), ACTION_UPLOAD));
        rv.put(BODY_CANCEL_URL, this.exitPageUrl(vreq, entity.getURI()));
        rv.put(BODY_TITLE, this.figureReplacePageTitle((HttpServletRequest)vreq, entity));
        rv.put(BODY_MAX_FILE_SIZE, 6);
        rv.put(BODY_THUMBNAIL_HEIGHT, 200);
        rv.put(BODY_THUMBNAIL_WIDTH, 200);
        return rv;
    }

    private TemplateResponseValues showReplaceImagePageWithError(VitroRequest vreq, Individual entity, ImageInfo imageInfo, String message) {
        TemplateResponseValues rv = this.showReplaceImagePage(vreq, entity, imageInfo);
        rv.put(BODY_ERROR_MESSAGE, message);
        return rv;
    }

    private TemplateResponseValues showCropImagePage(VitroRequest vreq, Individual entity, String imageUrl, ImageProcessor.Dimensions dimensions) {
        TemplateResponseValues rv = new TemplateResponseValues(TEMPLATE_CROP);
        rv.put(BODY_MAIN_IMAGE_URL, UrlBuilder.getUrl(imageUrl));
        rv.put(BODY_MAIN_IMAGE_HEIGHT, dimensions.height);
        rv.put(BODY_MAIN_IMAGE_WIDTH, dimensions.width);
        rv.put(BODY_FORM_ACTION, this.formAction(entity.getURI(), ACTION_SAVE));
        rv.put(BODY_CANCEL_URL, this.exitPageUrl(vreq, entity.getURI()));
        rv.put(BODY_TITLE, this.figureCropPageTitle((HttpServletRequest)vreq, entity));
        return rv;
    }

    private ForwardResponseValues showExitPage(VitroRequest vreq, Individual entity) {
        return new ForwardResponseValues(this.exitPageUrl(vreq, entity.getURI()));
    }

    private String exitPageUrl(VitroRequest vreq, String entityUri) {
        String referrer = (String)vreq.getSession().getAttribute(ATTRIBUTE_REFERRING_PAGE);
        if (referrer != null) {
            return referrer;
        }
        String defaultNamespace = this.getDefaultNamespace();
        if (defaultNamespace == null) {
            return "";
        }
        if (!entityUri.startsWith(defaultNamespace)) {
            return "";
        }
        String tail = entityUri.substring(defaultNamespace.length());
        if (!tail.startsWith("/")) {
            tail = "/" + tail;
        }
        return "display" + tail;
    }

    private String formAction(String entityUri, String action) {
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap(PARAMETER_ENTITY_URI, entityUri, PARAMETER_ACTION, action);
        return UrlBuilder.getPath(URL_HERE, params);
    }

    private String figureUploadPageTitle(HttpServletRequest req, Individual entity) {
        return this.figurePageTitle(req, entity, TEXT_STRING_UPLOAD_TITLE, TEXT_STRING_UPLOAD_TITLE_WITH_NAME);
    }

    private String figureReplacePageTitle(HttpServletRequest req, Individual entity) {
        return this.figurePageTitle(req, entity, TEXT_STRING_REPLACE_TITLE, TEXT_STRING_REPLACE_TITLE_WITH_NAME);
    }

    private String figureCropPageTitle(HttpServletRequest req, Individual entity) {
        return this.figurePageTitle(req, entity, TEXT_STRING_CROP_TITLE, TEXT_STRING_CROP_TITLE_WITH_NAME);
    }

    private String figurePageTitle(HttpServletRequest req, Individual entity, String noNameTitleKey, String nameTitleKey) {
        String name;
        if (entity != null && (name = entity.getName()) != null) {
            return I18n.text(req, nameTitleKey, name);
        }
        return I18n.text(req, noNameTitleKey, new Object[0]);
    }

    private String getDefaultNamespace() {
        return ConfigurationProperties.getBean(this.getServletContext()).getProperty("Vitro.defaultNamespace");
    }

    static class UserMistakeException
    extends Exception {
        private final Object[] parameters;

        UserMistakeException(String message, Object ... parameters) {
            super(message);
            this.parameters = parameters;
        }

        public String formatMessage(HttpServletRequest req) {
            return I18n.text(req, this.getMessage(), this.parameters);
        }
    }
}

