/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.json.util.JSONUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListVClassWebappsController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ListVClassWebappsController.class.getName());
    private static final String TEMPLATE_NAME = "siteAdmin-classHierarchy.ftl";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.EDIT_ONTOLOGY.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("displayOption", "all");
        body.put("pageTitle", "All Classes");
        if (vreq.getParameter("propertyURI") != null) {
            body.put("propertyURI", vreq.getParameter("propertyURI"));
        }
        List<VClass> classes = null;
        if (vreq.getParameter("showPropertyRestrictions") != null) {
            if (vreq.getParameter("propertyType").equals("object")) {
                body.put("editController", "propertyEdit?uri=");
            } else {
                body.put("editController", "datapropEdit?uri=");
            }
            body.put("propertyName", vreq.getParameter("propertyName"));
            ObjectPropertyDao pdao = vreq.getLanguageNeutralWebappDaoFactory().getObjectPropertyDao();
            classes = pdao.getClassesWithRestrictionOnProperty(vreq.getParameter("propertyURI"));
        } else {
            VClassDao vcdao = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
            classes = vreq.getParameter("iffRoot") != null ? vcdao.getRootClasses() : vcdao.getAllVclasses();
        }
        String json = new String();
        int counter = 0;
        String ontologyURI = vreq.getParameter("ontologyUri");
        if (classes != null) {
            this.sortForPickList(classes, vreq);
            Iterator<VClass> classesIt = classes.iterator();
            while (classesIt.hasNext()) {
                String ontName;
                if (counter > 0) {
                    json = json + ", ";
                }
                VClass cls = classesIt.next();
                if (ontologyURI != null && (ontologyURI == null || cls.getNamespace() == null || !ontologyURI.equals(cls.getNamespace()))) continue;
                if (cls.getName() != null) {
                    try {
                        json = json + "{ \"name\": " + JSONUtils.quote((String)("<a href='./vclassEdit?uri=" + URLEncoder.encode(cls.getURI(), "UTF-8") + "'>" + cls.getPickListName() + "</a>")) + ", ";
                    }
                    catch (Exception e) {
                        json = json + "{ \"name\": " + JSONUtils.quote((String)cls.getPickListName()) + ", ";
                    }
                } else {
                    json = json + "{ \"name\": \"\"";
                }
                String shortDef = cls.getShortDef() == null ? "" : cls.getShortDef();
                json = json + "\"data\": { \"shortDef\": " + JSONUtils.quote((String)shortDef) + ", ";
                WebappDaoFactory wadf = vreq.getUnfilteredWebappDaoFactory();
                VClassGroupDao groupDao = wadf.getVClassGroupDao();
                String groupURI = cls.getGroupURI();
                String groupName = "";
                VClassGroup classGroup = null;
                if (groupURI != null && (classGroup = groupDao.getGroupByURI(groupURI)) != null) {
                    groupName = classGroup.getPublicName();
                }
                json = json + "\"classGroup\": " + JSONUtils.quote((String)groupName) + ", ";
                OntologyDao ontDao = wadf.getOntologyDao();
                Ontology ont = ontDao.getOntologyByURI(ontName = cls.getNamespace());
                if (ont != null && ont.getName() != null) {
                    ontName = ont.getName();
                }
                json = json + "\"ontology\": " + JSONUtils.quote((String)ontName) + "} }";
                ++counter;
            }
            body.put("jsonTree", json);
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }
}

