/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RdfResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.jena.ExtendedLinkedDataUtils;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaOutputUtils;
import edu.cornell.mannlib.vitro.webapp.web.ContentType;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualRdfAssembler {
    private static final Log log = LogFactory.getLog(IndividualRdfAssembler.class);
    private static final String RICH_EXPORT_ROOT = "/WEB-INF/rich-export/";
    private static final String INCLUDE_ALL = "all";
    private static final String NS_DC = "http://purl.org/dc/elements/1.1/";
    private static final String URI_RIGHTS = "http://purl.org/dc/elements/1.1/rights";
    private static final String URI_DATE = "http://purl.org/dc/elements/1.1/date";
    private static final String URI_PUBLISHER = "http://purl.org/dc/elements/1.1/publisher";
    private static final String NS_FOAF = "http://xmlns.com/foaf/0.1/";
    private static final String URI_DOCUMENT = "http://xmlns.com/foaf/0.1/Document";
    private static final String URI_LABEL = "http://www.w3.org/2000/01/rdf-schema#label";
    private static final String URI_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private final VitroRequest vreq;
    private final ServletContext ctx;
    private final String individualUri;
    private final ContentType rdfFormat;
    private final String[] richExportIncludes;
    private final RDFService rdfService;
    private final OntModel contentModel;
    private final WebappDaoFactory wadf;

    public IndividualRdfAssembler(VitroRequest vreq, String individualUri, ContentType rdfFormat) {
        this.vreq = vreq;
        this.ctx = vreq.getSession().getServletContext();
        this.individualUri = individualUri;
        this.rdfFormat = rdfFormat;
        String[] includes = vreq.getParameterValues("include");
        String[] stringArray = this.richExportIncludes = includes == null ? new String[]{} : includes;
        if (this.isLanguageAware()) {
            this.rdfService = vreq.getRDFService();
            this.contentModel = vreq.getJenaOntModel();
        } else {
            this.rdfService = vreq.getUnfilteredRDFService();
            this.contentModel = vreq.getLanguageNeutralUnionFullModel();
        }
        this.wadf = vreq.getWebappDaoFactory();
    }

    public ResponseValues assembleRdf() {
        OntModel newModel = this.getRdf();
        newModel.add(this.getRichExportRdf());
        JenaOutputUtils.setNameSpacePrefixes((Model)newModel, this.wadf);
        return new RdfResponseValues(this.rdfFormat, (Model)newModel);
    }

    private boolean isLanguageAware() {
        return StringUtils.isNotEmpty((String)this.vreq.getHeader("Accept-Language"));
    }

    private OntModel getRdf() {
        OntModel o = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        o.add(this.getStatementsAboutEntity());
        o.add(this.getLabelsAndTypesOfRelatedObjects());
        this.filterByPolicy(o);
        this.addDocumentMetadata(o);
        return o;
    }

    private Model getStatementsAboutEntity() {
        Model m = this.runConstructQuery(String.format("CONSTRUCT { <%1$s> ?predicate ?object .\t} WHERE { <%1$s> ?predicate ?object } ", this.individualUri));
        m.add(this.runConstructQuery(String.format("CONSTRUCT { ?s ?predicate <%1$s> .\t} WHERE { ?s ?predicate <%1$s> } ", this.individualUri)));
        if (log.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            m.write((Writer)sw);
            log.debug((Object)("Statements about '" + this.individualUri + "': " + sw));
        }
        return m;
    }

    private Model getLabelsAndTypesOfRelatedObjects() {
        Model m = this.runConstructQuery(String.format("CONSTRUCT { ?object <%2$s> ?type .\t} WHERE { <%1$s> ?predicate ?object . ?object <%2$s> ?type . } ", this.individualUri, RDF.type));
        m.add(this.runConstructQuery(String.format("CONSTRUCT { ?object <%2$s> ?label .\t} WHERE { <%1$s> ?predicate ?object . ?object <%2$s> ?label . } ", this.individualUri, RDFS.label)));
        m.add(this.runConstructQuery(String.format("CONSTRUCT { ?subject <%2$s> ?type .\t} WHERE { ?subject ?predicate <%1$s> . ?subject <%2$s> ?type . } ", this.individualUri, RDF.type)));
        m.add(this.runConstructQuery(String.format("CONSTRUCT { ?subject <%2$s> ?label .\t} WHERE { ?subject ?predicate <%1$s> . ?subject <%2$s> ?label . } ", this.individualUri, RDFS.label)));
        return m;
    }

    private void filterByPolicy(OntModel o) {
        this.removeProhibitedTriples(o);
        Set<String> okObjects = this.determineAccessibleUris(o);
        this.removeOrphanedObjects(o, okObjects);
    }

    private void removeProhibitedTriples(OntModel o) {
        StmtIterator stmts = o.listStatements();
        while (stmts.hasNext()) {
            Statement stmt = (Statement)stmts.next();
            String subjectUri = stmt.getSubject().getURI();
            String predicateUri = stmt.getPredicate().getURI();
            if (stmt.getObject().isLiteral()) {
                String value = stmt.getObject().asLiteral().getString();
                DataPropertyStatementImpl dps = new DataPropertyStatementImpl(subjectUri, predicateUri, value);
                PublishDataPropertyStatement pdps = new PublishDataPropertyStatement(o, dps);
                if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{pdps})) continue;
                log.debug((Object)("not authorized: " + pdps));
                stmts.remove();
                continue;
            }
            if (stmt.getObject().isURIResource()) {
                String objectUri = stmt.getObject().asResource().getURI();
                PublishObjectPropertyStatement pops = new PublishObjectPropertyStatement(o, subjectUri, predicateUri, objectUri);
                if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{pops})) continue;
                log.debug((Object)("not authorized: " + pops));
                stmts.remove();
                continue;
            }
            log.warn((Object)("blank node: " + stmt));
            stmts.remove();
        }
    }

    private Set<String> determineAccessibleUris(OntModel o) {
        Statement stmt;
        Resource i = o.getResource(this.individualUri);
        HashSet<String> uris = new HashSet<String>();
        uris.add(this.individualUri);
        StmtIterator stmts = o.listStatements(i, null, (RDFNode)null);
        while (stmts.hasNext()) {
            stmt = (Statement)stmts.next();
            if (!stmt.getObject().isURIResource()) continue;
            uris.add(stmt.getObject().asResource().getURI());
        }
        stmts = o.listStatements(null, null, (RDFNode)i);
        while (stmts.hasNext()) {
            stmt = (Statement)stmts.next();
            uris.add(stmt.getSubject().getURI());
        }
        return uris;
    }

    private void removeOrphanedObjects(OntModel o, Set<String> okObjects) {
        StmtIterator stmts = o.listStatements();
        while (stmts.hasNext()) {
            Statement stmt = (Statement)stmts.next();
            if (okObjects.contains(stmt.getSubject().getURI())) continue;
            log.debug((Object)("removing orphan triple: " + stmt));
            stmts.remove();
        }
    }

    private Model runConstructQuery(String query) {
        try {
            return RDFServiceUtils.parseModel(this.rdfService.sparqlConstructQuery(query, RDFService.ModelSerializationFormat.N3), RDFService.ModelSerializationFormat.N3);
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private Model getRichExportRdf() {
        Model richExportModel = ModelFactory.createDefaultModel();
        for (String include : this.richExportIncludes) {
            String rootDir = RICH_EXPORT_ROOT;
            if (!INCLUDE_ALL.equals(include)) {
                rootDir = rootDir + include + "/";
            }
            long start = System.currentTimeMillis();
            richExportModel.add(ExtendedLinkedDataUtils.createModelFromQueries(this.ctx, rootDir, this.contentModel, this.individualUri));
            long elapsedTimeMillis = System.currentTimeMillis() - start;
            log.debug((Object)("Time to create rich export model: msecs = " + elapsedTimeMillis));
        }
        return richExportModel;
    }

    private void addDocumentMetadata(OntModel o) {
        String baseUrl = this.figureBaseUrl();
        String documentUri = this.createDocumentUri();
        String label = this.createDocumentLabel(o);
        Literal dateLiteral = this.createDateLiteral(o);
        Resource md = o.getResource(documentUri);
        o.add(md, o.getProperty(URI_LABEL), label);
        o.add(md, o.getProperty(URI_TYPE), (RDFNode)o.getResource(URI_DOCUMENT));
        o.add(md, o.getProperty(URI_PUBLISHER), (RDFNode)o.getResource(baseUrl));
        o.add(md, o.getProperty(URI_DATE), (RDFNode)dateLiteral);
        o.add(md, o.getProperty(URI_RIGHTS), (RDFNode)o.getResource(baseUrl + "/termsOfUse"));
    }

    private String figureBaseUrl() {
        int cutHere = this.individualUri.indexOf("/individual");
        return cutHere > 0 ? this.individualUri.substring(0, cutHere) : this.individualUri;
    }

    private String createDocumentUri() {
        return this.vreq.getRequestURL().toString();
    }

    private String createDocumentLabel(OntModel o) {
        String label = null;
        NodeIterator nodes = o.listObjectsOfProperty(o.getResource(this.individualUri), o.getProperty(URI_LABEL));
        while (nodes.hasNext()) {
            RDFNode n = nodes.nextNode();
            if (!n.isLiteral()) continue;
            label = n.asLiteral().getString();
        }
        if (label == null) {
            return "RDF description of " + this.individualUri;
        }
        return "RDF description of " + label + " - " + this.individualUri;
    }

    private Literal createDateLiteral(OntModel o) {
        String date = new SimpleDateFormat("YYYY-MM-dd'T'HH:mm:ss").format(new Date());
        return o.createTypedLiteral(date, (RDFDatatype)XSDDatatype.XSDdateTime);
    }
}

