/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualController;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalysisContext;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestInfo;
import edu.cornell.mannlib.vitro.webapp.web.ContentType;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualRequestAnalyzer {
    private static final Log log = LogFactory.getLog(IndividualRequestAnalyzer.class);
    private static Pattern RDF_REQUEST = Pattern.compile("^/individual/([^/]+)/\\1\\.(rdf|n3|ttl|jsonld)$");
    private static Pattern HTML_REQUEST = Pattern.compile("^/display/([^/]+)$");
    private static Pattern LINKED_DATA_URL = Pattern.compile("^/individual/([^/]+)$");
    private final VitroRequest vreq;
    private final IndividualRequestAnalysisContext analysisContext;
    private final String url;
    private static Pattern URI_PATTERN = Pattern.compile("^/individual/([^/]*)$");

    public IndividualRequestAnalyzer(VitroRequest vreq, IndividualRequestAnalysisContext analysisContext) {
        this.vreq = vreq;
        this.url = vreq.getRequestURI().substring(vreq.getContextPath().length());
        this.analysisContext = analysisContext;
    }

    public IndividualRequestInfo analyze() {
        String redirectUrl = this.checkForRedirect();
        if (redirectUrl != null) {
            return IndividualRequestInfo.buildRdfRedirectInfo(redirectUrl);
        }
        Individual individual = this.getIndividualFromRequest();
        if (individual == null) {
            return IndividualRequestInfo.buildNoIndividualInfo();
        }
        redirectUrl = this.getAliasUrlForBytestreamIndividual(individual);
        if (redirectUrl != null) {
            return IndividualRequestInfo.buildBytestreamRedirectInfo(redirectUrl);
        }
        ContentType rdfFormat = this.checkUrlForLinkedDataRequest();
        if (rdfFormat != null) {
            return IndividualRequestInfo.buildLinkedDataInfo(individual, rdfFormat);
        }
        return IndividualRequestInfo.buildDefaultInfo(individual);
    }

    private String checkForRedirect() {
        String formatParam = this.getRequestParameter("format", "");
        if (!formatParam.isEmpty()) {
            return null;
        }
        Matcher m = URI_PATTERN.matcher(this.url);
        if (!m.matches() || m.groupCount() < 1) {
            return null;
        }
        ContentType c = this.checkAcceptHeaderForLinkedDataRequest();
        if (c != null) {
            String mediaType = c.getMediaType();
            if ("application/rdf+xml".equals(mediaType)) {
                return "/individual/" + m.group(1) + "/" + m.group(1) + ".rdf";
            }
            if ("text/n3".equals(mediaType)) {
                return "/individual/" + m.group(1) + "/" + m.group(1) + ".n3";
            }
            if ("text/turtle".equals(mediaType)) {
                return "/individual/" + m.group(1) + "/" + m.group(1) + ".ttl";
            }
            if ("application/json".equals(mediaType) || "application/ld+json".equals(mediaType)) {
                return "/individual/" + m.group(1) + "/" + m.group(1) + ".jsonld";
            }
        }
        return "/display/" + m.group(1);
    }

    protected ContentType checkAcceptHeaderForLinkedDataRequest() {
        String acceptHeader = this.vreq.getHeader("Accept");
        if (acceptHeader == null) {
            acceptHeader = this.vreq.getHeader("accept");
        }
        if (acceptHeader == null) {
            return null;
        }
        try {
            Map<String, Float> typesAndQ = ContentType.getTypesAndQ(acceptHeader);
            String ctStr = ContentType.getBestContentType(typesAndQ, IndividualController.ACCEPTED_CONTENT_TYPES);
            if ("application/rdf+xml".equals(ctStr) || "text/n3".equals(ctStr) || "text/turtle".equals(ctStr) || "application/json".equals(ctStr) || "application/ld+json".equals(ctStr)) {
                return new ContentType(ctStr);
            }
        }
        catch (Throwable th) {
            log.error((Object)"Problem while checking accept header ", th);
        }
        return null;
    }

    public Individual getIndividualFromRequest() {
        try {
            String uri = this.getRequestParameter("uri", "");
            if (!uri.isEmpty()) {
                return this.getIndividualByUri(uri);
            }
            String netId = this.getRequestParameter("netId", this.getRequestParameter("netid", ""));
            if (!netId.isEmpty()) {
                return this.getIndividualByNetId(netId);
            }
            Matcher linkedDataMatch = LINKED_DATA_URL.matcher(this.url);
            if (linkedDataMatch.matches() && linkedDataMatch.groupCount() == 1) {
                return this.getIndividualByLocalname(linkedDataMatch.group(1));
            }
            Matcher htmlMatch = HTML_REQUEST.matcher(this.url);
            if (htmlMatch.matches() && htmlMatch.groupCount() == 1) {
                return this.getIndividualByLocalname(htmlMatch.group(1));
            }
            Matcher rdfMatch = RDF_REQUEST.matcher(this.url);
            if (rdfMatch.matches() && rdfMatch.groupCount() == 2) {
                return this.getIndividualByLocalname(rdfMatch.group(1));
            }
            return null;
        }
        catch (Throwable e) {
            log.error((Object)"Problems trying to find Individual", e);
            return null;
        }
    }

    private String getAliasUrlForBytestreamIndividual(Individual individual) {
        String aliasUrl = this.analysisContext.getAliasUrlForBytestreamIndividual(individual);
        if (individual.getURI().equals(aliasUrl)) {
            return null;
        }
        return aliasUrl;
    }

    protected ContentType checkUrlForLinkedDataRequest() {
        String formatParam = this.getRequestParameter("format", "");
        if (formatParam.contains("rdfxml")) {
            return ContentType.RDFXML;
        }
        if (formatParam.contains("n3")) {
            return ContentType.N3;
        }
        if (formatParam.contains("ttl")) {
            return ContentType.TURTLE;
        }
        if (formatParam.contains("jsonld") || formatParam.contains("json")) {
            return ContentType.JSON;
        }
        Matcher rdfMatch = RDF_REQUEST.matcher(this.url);
        if (rdfMatch.matches() && rdfMatch.groupCount() == 2) {
            String rdfType = rdfMatch.group(2);
            if ("rdf".equals(rdfType)) {
                return ContentType.RDFXML;
            }
            if ("n3".equals(rdfType)) {
                return ContentType.N3;
            }
            if ("ttl".equals(rdfType)) {
                return ContentType.TURTLE;
            }
            if ("jsonld".equals(rdfType)) {
                return ContentType.JSON;
            }
        }
        return null;
    }

    private String getRequestParameter(String key, String defaultValue) {
        String value = this.vreq.getParameter(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    private Individual getIndividualByUri(String uri) {
        return this.analysisContext.getIndividualByURI(uri);
    }

    private Individual getIndividualByLocalname(String localname) {
        String defaultNamespace = this.analysisContext.getDefaultNamespace();
        String uri = defaultNamespace + localname;
        return this.getIndividualByUri(uri);
    }

    private Individual getIndividualByNetId(String netId) {
        return this.analysisContext.getIndividualByNetId(netId);
    }
}

