/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonObjectProducer;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class GetSearchIndividualsByVClass
extends JsonObjectProducer {
    private static final Log log = LogFactory.getLog(GetSearchIndividualsByVClass.class);

    protected GetSearchIndividualsByVClass(VitroRequest vreq) {
        super(vreq);
    }

    @Override
    protected JSONObject process() throws Exception {
        VClass vclass = null;
        String queryType = (String)this.vreq.getAttribute("queryType");
        String vitroClassIdStr = this.vreq.getParameter("vclassId");
        if (vitroClassIdStr != null && !vitroClassIdStr.isEmpty()) {
            vclass = this.vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(vitroClassIdStr);
            if (vclass == null) {
                log.debug((Object)"Couldn't retrieve vclass ");
                throw new Exception("Class " + vitroClassIdStr + " not found");
            }
        } else {
            log.debug((Object)"parameter vclassId URI parameter expected ");
            throw new Exception("parameter vclassId URI parameter expected ");
        }
        this.vreq.setAttribute("displayType", vitroClassIdStr);
        if (queryType != null && queryType.equals("random")) {
            return JsonServlet.getRandomSearchIndividualsByVClass(vclass.getURI(), (HttpServletRequest)this.vreq);
        }
        return JsonServlet.getSearchIndividualsByVClass(vclass.getURI(), (HttpServletRequest)this.vreq);
    }
}

