/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import com.hp.hpl.jena.rdf.model.Literal;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.BaseFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.DataPropertyStatementFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

class DataPropertyStatementDaoFiltering
extends BaseFiltering
implements DataPropertyStatementDao {
    final DataPropertyStatementDao innerDataPropertyStatementDao;
    final VitroFilters filters;

    public DataPropertyStatementDaoFiltering(DataPropertyStatementDao dataPropertyStatementDao, VitroFilters filters) {
        this.innerDataPropertyStatementDao = dataPropertyStatementDao;
        this.filters = filters;
    }

    @Override
    public void deleteDataPropertyStatement(DataPropertyStatement dataPropertyStatement) {
        this.innerDataPropertyStatementDao.deleteDataPropertyStatement(dataPropertyStatement);
    }

    @Override
    public Individual fillExistingDataPropertyStatementsForIndividual(Individual individual) {
        if (individual == null) {
            return null;
        }
        Individual ind = this.innerDataPropertyStatementDao.fillExistingDataPropertyStatementsForIndividual(individual);
        if (ind == null) {
            return null;
        }
        List<DataPropertyStatement> dprops = ind.getDataPropertyStatements();
        if (dprops != null) {
            ind.setDataPropertyStatements(this.filter(dprops, this.filters.getDataPropertyStatementFilter()));
        }
        return ind;
    }

    @Override
    public void deleteDataPropertyStatementsForIndividualByDataProperty(Individual individual, DataProperty dataProperty) {
        this.innerDataPropertyStatementDao.deleteDataPropertyStatementsForIndividualByDataProperty(individual, dataProperty);
    }

    @Override
    public void deleteDataPropertyStatementsForIndividualByDataProperty(String individualURI, String dataPropertyURI) {
        this.innerDataPropertyStatementDao.deleteDataPropertyStatementsForIndividualByDataProperty(individualURI, dataPropertyURI);
    }

    @Override
    public Collection<DataPropertyStatement> getDataPropertyStatementsForIndividualByDataPropertyURI(Individual entity, String datapropURI) {
        Collection<DataPropertyStatement> col = this.innerDataPropertyStatementDao.getDataPropertyStatementsForIndividualByDataPropertyURI(entity, datapropURI);
        if (col != null) {
            return this.filter(col, this.filters.getDataPropertyStatementFilter());
        }
        return null;
    }

    @Override
    @Deprecated
    public List getExistingQualifiers(String dataPropertyURI) {
        return this.innerDataPropertyStatementDao.getExistingQualifiers(dataPropertyURI);
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements(DataProperty dataProperty) {
        List<DataPropertyStatement> dps = this.innerDataPropertyStatementDao.getDataPropertyStatements(dataProperty);
        if (dps != null) {
            return this.filter(dps, this.filters.getDataPropertyStatementFilter());
        }
        return dps;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements(DataProperty dataProperty, int startIndex, int endIndex) {
        List<DataPropertyStatement> dps = this.innerDataPropertyStatementDao.getDataPropertyStatements(dataProperty, startIndex, endIndex);
        if (dps != null) {
            return this.filter(dps, this.filters.getDataPropertyStatementFilter());
        }
        return dps;
    }

    @Override
    public int insertNewDataPropertyStatement(DataPropertyStatement dataPropertyStatement) {
        return this.innerDataPropertyStatementDao.insertNewDataPropertyStatement(dataPropertyStatement);
    }

    @Override
    public List<Literal> getDataPropertyValuesForIndividualByProperty(Individual subject, DataProperty property) {
        return this.getDataPropertyValuesForIndividualByProperty(subject.getURI(), property.getURI());
    }

    @Override
    public List<Literal> getDataPropertyValuesForIndividualByProperty(String subjectUri, String propertyUri) {
        List<Literal> literals = this.innerDataPropertyStatementDao.getDataPropertyValuesForIndividualByProperty(subjectUri, propertyUri);
        LinkedHashMap<DataPropertyStatementImpl, Literal> stmtsToLiterals = new LinkedHashMap<DataPropertyStatementImpl, Literal>(literals.size());
        for (Literal literal : literals) {
            String value = literal.getLexicalForm();
            DataPropertyStatementImpl statement = new DataPropertyStatementImpl(subjectUri, propertyUri, value);
            statement.setDatatypeURI(literal.getDatatypeURI());
            statement.setLanguage(literal.getLanguage());
            stmtsToLiterals.put(statement, literal);
        }
        ArrayList stmtList = new ArrayList(stmtsToLiterals.keySet());
        List<DataPropertyStatement> filteredStatements = this.filter(stmtList, this.filters.getDataPropertyStatementFilter());
        ArrayList<Literal> filteredLiterals = new ArrayList<Literal>(filteredStatements.size());
        for (DataPropertyStatement dps : filteredStatements) {
            if (dps instanceof DataPropertyStatementFiltering) {
                dps = ((DataPropertyStatementFiltering)dps).innerStmt;
            }
            filteredLiterals.add((Literal)stmtsToLiterals.get(dps));
        }
        return filteredLiterals;
    }

    @Override
    public List<Literal> getDataPropertyValuesForIndividualByProperty(Individual subject, DataProperty property, String queryString, Set<String> constructQueryStrings) {
        return this.getDataPropertyValuesForIndividualByProperty(subject.getURI(), property.getURI(), queryString, constructQueryStrings);
    }

    @Override
    public List<Literal> getDataPropertyValuesForIndividualByProperty(String subjectUri, String propertyUri, String queryString, Set<String> constructQueryStrings) {
        List<Literal> literals = this.innerDataPropertyStatementDao.getDataPropertyValuesForIndividualByProperty(subjectUri, propertyUri, queryString, constructQueryStrings);
        LinkedHashMap<DataPropertyStatementImpl, Literal> stmtsToLiterals = new LinkedHashMap<DataPropertyStatementImpl, Literal>(literals.size());
        for (Literal literal : literals) {
            String value = literal.getLexicalForm();
            DataPropertyStatementImpl statement = new DataPropertyStatementImpl(subjectUri, propertyUri, value);
            statement.setDatatypeURI(literal.getDatatypeURI());
            statement.setLanguage(literal.getLanguage());
            stmtsToLiterals.put(statement, literal);
        }
        ArrayList stmtList = new ArrayList(stmtsToLiterals.keySet());
        List<DataPropertyStatement> filteredStatements = this.filter(stmtList, this.filters.getDataPropertyStatementFilter());
        ArrayList<Literal> filteredLiterals = new ArrayList<Literal>(filteredStatements.size());
        for (DataPropertyStatement dps : filteredStatements) {
            if (dps instanceof DataPropertyStatementFiltering) {
                dps = ((DataPropertyStatementFiltering)dps).innerStmt;
            }
            filteredLiterals.add((Literal)stmtsToLiterals.get(dps));
        }
        return filteredLiterals;
    }
}

