/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class DependentResourceDeleteJena {
    public static List<Statement> getDependentResourceDeleteList(Statement stmt, Model model) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null.");
        }
        return DependentResourceDeleteJena.getDependentResourceDeleteList(stmt, model, new HashSet<String>(), false);
    }

    public static List<Statement> getDependentResourceDeleteList(Resource deleteMe, Model sourceModel) {
        LinkedList<Statement> deletes = new LinkedList<Statement>();
        for (Statement stmt : DependentResourceDeleteJena.getAllStatements(deleteMe, sourceModel)) {
            deletes.add(stmt);
            deletes.addAll(DependentResourceDeleteJena.getDependentResourceDeleteList(stmt, sourceModel, new HashSet<String>(), false));
        }
        return deletes;
    }

    public static Model getDependentResourceDeleteForChange(Model assertions, Model retractions, Model sourceModel) {
        if (sourceModel == null || retractions == null || assertions == null) {
            throw new IllegalArgumentException("model must not be null.");
        }
        List<Statement> removedStmts = DependentResourceDeleteJena.getRemovedStmts(assertions, retractions);
        HashSet<Statement> changedStatementsSet = new HashSet<Statement>();
        changedStatementsSet.addAll(DependentResourceDeleteJena.getChangedStmts(assertions, retractions));
        LinkedList<Statement> changedStmts = new LinkedList<Statement>();
        changedStmts.addAll(changedStatementsSet);
        ListIterator<Statement> removed = removedStmts.listIterator();
        while (removed.hasNext()) {
            Statement removedStmt = removed.next();
            Iterator<Object> changed = changedStmts.listIterator();
            while (changed.hasNext()) {
                Statement changedStmt = (Statement)changed.next();
                if (!removedStmt.equals((Object)changedStmt)) continue;
                removed.remove();
            }
        }
        LinkedList<Statement> dependentStmts = new LinkedList<Statement>();
        for (Statement stmt : removedStmts) {
            dependentStmts.addAll(DependentResourceDeleteJena.getDependentResourceDeleteList(stmt, sourceModel));
        }
        Model outModel = ModelFactory.createDefaultModel();
        outModel.add(dependentStmts);
        return outModel;
    }

    private static List<Statement> getChangedStmts(Model assertions, Model retractions) {
        LinkedList<Statement> changedStmts = new LinkedList<Statement>();
        StmtIterator it = assertions.listStatements();
        while (it.hasNext()) {
            Statement assertionStmtStatement = it.nextStatement();
            if (assertionStmtStatement.getObject().canAs(Resource.class)) {
                Resource asserObj = (Resource)assertionStmtStatement.getObject().as(Resource.class);
                StmtIterator retractionStmts = retractions.listStatements((Resource)null, retractions.createProperty(assertionStmtStatement.getPredicate().getURI()), (RDFNode)retractions.createResource(asserObj.getURI()));
                if (retractionStmts != null) {
                    if (retractionStmts.hasNext()) {
                        changedStmts.add(assertionStmtStatement);
                    }
                    while (retractionStmts.hasNext()) {
                        changedStmts.add(retractionStmts.nextStatement());
                    }
                }
                retractionStmts.close();
            }
            it.close();
        }
        return changedStmts;
    }

    private static List<Statement> getRemovedStmts(Model assertions, Model retractions) {
        LinkedList<Statement> toRemove = new LinkedList<Statement>();
        StmtIterator iter = retractions.listStatements();
        while (iter.hasNext()) {
            Statement stmt = iter.nextStatement();
            if (stmt.getObject() == null || stmt.getObject().isLiteral() || assertions.contains(stmt)) continue;
            toRemove.add(stmt);
        }
        iter.close();
        return toRemove;
    }

    private static List<Statement> getDependentResourceDeleteList(Statement stmt, Model model, Set<String> visitedUris, boolean perviousWasDependentResource) {
        if (stmt == null) {
            return Collections.emptyList();
        }
        LinkedList<Statement> toDelete = new LinkedList<Statement>();
        toDelete.add(stmt);
        RDFNode obj = stmt.getObject();
        if (obj.canAs(Resource.class) && DependentResourceDeleteJena.isPredicateDependencyRelation(stmt.getPredicate(), model) || obj.isAnon() && perviousWasDependentResource) {
            String id;
            Resource res = (Resource)obj.as(Resource.class);
            String string = id = res.isAnon() ? res.getId().toString() : res.getURI();
            if (!visitedUris.contains(id)) {
                visitedUris.add(id);
                for (Statement stubStmt : DependentResourceDeleteJena.getAllStatements(res, model)) {
                    toDelete.addAll(DependentResourceDeleteJena.getDependentResourceDeleteList(stubStmt, model, visitedUris, true));
                }
            }
        }
        return toDelete;
    }

    private static List<Statement> getAllStatements(Resource res, Model model) {
        LinkedList<Statement> deleteUs = new LinkedList<Statement>();
        StmtIterator it = model.listStatements(null, null, (RDFNode)res);
        while (it.hasNext()) {
            deleteUs.add(it.nextStatement());
        }
        it = model.listStatements(res, null, (RDFNode)null);
        while (it.hasNext()) {
            deleteUs.add(it.nextStatement());
        }
        it = model.listStatements(res, null, null, null);
        while (it.hasNext()) {
            deleteUs.add(it.nextStatement());
        }
        return deleteUs;
    }

    private static boolean isPredicateDependencyRelation(Property predicate, Model model) {
        return model.containsLiteral(model.getResource(predicate.getURI()), model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#stubObjectPropertyAnnot"), true);
    }
}

