/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.Set;

public class DifferenceGraph
implements Graph {
    private Graph g;
    private Graph subtract;

    public DifferenceGraph(Graph g, Graph subtract) {
        this.g = g;
        this.subtract = subtract;
    }

    public void close() {
    }

    public boolean contains(Triple arg0) {
        return this.g.contains(arg0) && !this.subtract.contains(arg0);
    }

    public boolean contains(Node arg0, Node arg1, Node arg2) {
        return this.g.contains(arg0, arg1, arg2) && !this.subtract.contains(arg0, arg1, arg2);
    }

    public void delete(Triple arg0) throws DeleteDeniedException {
        this.g.delete(arg0);
    }

    public void remove(Node arg0, Node arg1, Node arg2) {
        this.g.remove(arg0, arg1, arg2);
    }

    public boolean dependsOn(Graph arg0) {
        return this.g.dependsOn(arg0);
    }

    public ExtendedIterator<Triple> find(TripleMatch arg0) {
        Set tripSet = this.g.find(arg0).toSet();
        tripSet.removeAll(this.subtract.find(arg0).toSet());
        return WrappedIterator.create(tripSet.iterator());
    }

    public ExtendedIterator<Triple> find(Node arg0, Node arg1, Node arg2) {
        Set tripSet = this.g.find(arg0, arg1, arg2).toSet();
        tripSet.removeAll(this.subtract.find(arg0, arg1, arg2).toSet());
        return WrappedIterator.create(tripSet.iterator());
    }

    @Deprecated
    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.g.getBulkUpdateHandler();
    }

    public Capabilities getCapabilities() {
        return this.g.getCapabilities();
    }

    public GraphEventManager getEventManager() {
        return this.g.getEventManager();
    }

    public PrefixMapping getPrefixMapping() {
        return this.g.getPrefixMapping();
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        return this.g.getStatisticsHandler();
    }

    public TransactionHandler getTransactionHandler() {
        return this.g.getTransactionHandler();
    }

    public boolean isClosed() {
        return this.g.isClosed();
    }

    public boolean isEmpty() {
        return this.g.isEmpty();
    }

    public boolean isIsomorphicWith(Graph arg0) {
        return this.g.isIsomorphicWith(arg0);
    }

    public int size() {
        return this.g.size() - this.subtract.size();
    }

    public void add(Triple arg0) throws AddDeniedException {
        this.g.add(arg0);
    }

    public void clear() {
        this.g.clear();
    }

    public String toString() {
        return "DifferenceGraph[" + ToString.hashHex(this) + ", g=" + ToString.graphToString(this.g) + ", subtract=" + ToString.graphToString(this.subtract) + "]";
    }
}

