/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DependentResourceDeleteJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.ObjectPropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.IndividualUpdateEvent;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectPropertyStatementDaoJena
extends JenaBaseDao
implements ObjectPropertyStatementDao {
    private static final Log log = LogFactory.getLog(ObjectPropertyStatementDaoJena.class);
    protected DatasetWrapperFactory dwf;
    protected RDFService rdfService;
    private int NO_LIMIT = -1;
    protected static final String MOST_SPECIFIC_TYPE_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT DISTINCT ?label ?type WHERE { \n    ?subject vitro:mostSpecificType ?type . \n    ?type rdfs:label ?label . \n    ?type vitro:inClassGroup ?classGroup . \n    ?classGroup a ?ClassGroup \n} ORDER BY ?label ";

    public ObjectPropertyStatementDaoJena(RDFService rdfService, DatasetWrapperFactory dwf, WebappDaoFactoryJena wadf) {
        super(wadf);
        this.rdfService = rdfService;
        this.dwf = dwf;
    }

    @Override
    public void deleteObjectPropertyStatement(ObjectPropertyStatement objPropertyStmt) {
        this.deleteObjectPropertyStatement(objPropertyStmt, this.getOntModelSelector().getABoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjectPropertyStatement(ObjectPropertyStatement objPropertyStmt, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, objPropertyStmt.getSubjectURI()));
        try {
            Resource s = ontModel.getResource(objPropertyStmt.getSubjectURI());
            Property p = ontModel.getProperty(objPropertyStmt.getPropertyURI());
            Resource o = ontModel.getResource(objPropertyStmt.getObjectURI());
            if (s != null && p != null && o != null) {
                ontModel.remove(s, p, (RDFNode)o);
            }
            List<Statement> dependentResources = DependentResourceDeleteJena.getDependentResourceDeleteList(o, (Model)ontModel);
            ontModel.remove(dependentResources);
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, objPropertyStmt.getSubjectURI()));
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Individual fillExistingObjectPropertyStatements(Individual entity) {
        if (entity.getURI() == null) {
            return entity;
        }
        HashMap<String, ObjectProperty> uriToObjectProperty = new HashMap<String, ObjectProperty>();
        ObjectPropertyDaoJena opDaoJena = (ObjectPropertyDaoJena)this.getWebappDaoFactory().getObjectPropertyDao();
        OntModel ontModel = this.getOntModelSelector().getABoxModel();
        ontModel.enterCriticalSection(true);
        try {
            ArrayList<ObjectPropertyStatement> objPropertyStmtList;
            block18: {
                Resource ind = ontModel.getResource(entity.getURI());
                objPropertyStmtList = new ArrayList<ObjectPropertyStatement>();
                StmtIterator propIt = ind.listProperties();
                block12: while (true) {
                    while (propIt.hasNext()) {
                        Statement st = (Statement)propIt.next();
                        if (!st.getObject().isResource() || this.NONUSER_NAMESPACES.contains(st.getPredicate().getNameSpace())) continue;
                        try {
                            ObjectPropertyStatementImpl objPropertyStmt = new ObjectPropertyStatementImpl();
                            objPropertyStmt.setSubjectURI(entity.getURI());
                            objPropertyStmt.setSubject(entity);
                            try {
                                objPropertyStmt.setObjectURI(((Resource)st.getObject()).getURI());
                            }
                            catch (Throwable t) {
                                log.error((Object)t, t);
                            }
                            objPropertyStmt.setPropertyURI(st.getPredicate().getURI());
                            try {
                                Property prop = st.getPredicate();
                                if (uriToObjectProperty.containsKey(prop.getURI())) {
                                    objPropertyStmt.setProperty((ObjectProperty)uriToObjectProperty.get(prop.getURI()));
                                } else {
                                    ObjectProperty p = opDaoJena.propertyFromOntProperty((OntProperty)this.getOntModel().getObjectProperty(prop.getURI()));
                                    if (p == null) continue;
                                    uriToObjectProperty.put(prop.getURI(), p);
                                    objPropertyStmt.setProperty((ObjectProperty)uriToObjectProperty.get(prop.getURI()));
                                }
                            }
                            catch (Throwable g) {
                                log.debug((Object)"exception while trying to get object property for statement list, statement skipped.", g);
                                continue;
                            }
                            if (objPropertyStmt.getObjectURI() != null) {
                                Individual objInd = this.getWebappDaoFactory().getIndividualDao().getIndividualByURI(objPropertyStmt.getObjectURI());
                                objPropertyStmt.setObject(objInd);
                            }
                            if (objPropertyStmt.getSubjectURI() == null || objPropertyStmt.getPropertyURI() == null || objPropertyStmt.getObject() == null) continue block12;
                            objPropertyStmtList.add(objPropertyStmt);
                            continue block12;
                        }
                        catch (Throwable t) {
                            log.error((Object)t, t);
                        }
                    }
                    break block18;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    propIt.close();
                }
            }
            entity.setObjectPropertyStatements(objPropertyStmtList);
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return entity;
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectProperty objectProperty) {
        return this.getObjectPropertyStatements(objectProperty, this.NO_LIMIT, this.NO_LIMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectProperty objectProperty, int startIndex, int endIndex) {
        this.getOntModel().enterCriticalSection(true);
        ArrayList<ObjectPropertyStatement> opss = new ArrayList<ObjectPropertyStatement>();
        try {
            Property prop = ResourceFactory.createProperty((String)objectProperty.getURI());
            try (StmtIterator opsIt = this.getOntModel().listStatements(null, prop, (RDFNode)((Resource)null));){
                int count = 0;
                while (opsIt.hasNext() && (endIndex < 0 || count < endIndex)) {
                    Resource objRes;
                    Statement stmt = (Statement)opsIt.next();
                    if (!stmt.getObject().isResource() || startIndex >= 0 && startIndex > ++count || (objRes = (Resource)stmt.getObject()).isAnon()) continue;
                    ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
                    ops.setSubjectURI(stmt.getSubject().getURI());
                    ops.setPropertyURI(objectProperty.getURI());
                    ops.setObjectURI(objRes.getURI());
                    opss.add(ops);
                }
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return opss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectPropertyStatement objPropertyStmt) {
        ArrayList<ObjectPropertyStatement> opss = new ArrayList<ObjectPropertyStatement>();
        this.getOntModel().enterCriticalSection(true);
        try {
            String subjectUri = objPropertyStmt.getSubjectURI();
            String propertyUri = objPropertyStmt.getPropertyURI();
            String objectUri = objPropertyStmt.getObjectURI();
            Resource subject = subjectUri == null ? null : ResourceFactory.createResource((String)subjectUri);
            Property property = propertyUri == null ? null : ResourceFactory.createProperty((String)propertyUri);
            Resource object = objectUri == null ? null : ResourceFactory.createResource((String)objectUri);
            try (StmtIterator opsIt = this.getOntModel().listStatements(subject, property, (RDFNode)object);){
                while (opsIt.hasNext()) {
                    Resource objRes;
                    Statement stmt = (Statement)opsIt.next();
                    if (!stmt.getObject().isResource() || (objRes = (Resource)stmt.getObject()).isAnon()) continue;
                    ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
                    ops.setSubjectURI(stmt.getSubject().getURI());
                    ops.setPropertyURI(stmt.getPredicate().getURI());
                    ops.setObjectURI(objRes.getURI());
                    opss.add(ops);
                }
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return opss;
    }

    @Override
    public int insertNewObjectPropertyStatement(ObjectPropertyStatement objPropertyStmt) {
        return this.insertNewObjectPropertyStatement(objPropertyStmt, this.getOntModelSelector().getABoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertNewObjectPropertyStatement(ObjectPropertyStatement objPropertyStmt, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, objPropertyStmt.getSubjectURI()));
        try {
            Resource s = ontModel.getResource(objPropertyStmt.getSubjectURI());
            Property p = ontModel.getProperty(objPropertyStmt.getPropertyURI());
            Resource o = ontModel.getResource(objPropertyStmt.getObjectURI());
            if (s != null && p != null && o != null) {
                ontModel.add(s, p, (RDFNode)o);
            }
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, objPropertyStmt.getSubjectURI()));
            ontModel.leaveCriticalSection();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, String>> getObjectPropertyStatementsForIndividualByProperty(String subjectUri, String propertyUri, final String objectKey, String domainUri, String rangeUri, String queryString, Set<String> constructQueryStrings, String sortDirection) {
        final ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        long start = System.currentTimeMillis();
        try (Model constructedModel = null;){
            constructedModel = this.constructModelForSelectQueries(subjectUri, propertyUri, rangeUri, constructQueryStrings);
            if (constructedModel != null && log.isDebugEnabled()) {
                log.debug((Object)("Constructed model has " + constructedModel.size() + " statements."));
            }
            if ("desc".equalsIgnoreCase(sortDirection)) {
                queryString = queryString.replaceAll(" ASC\\(", " DESC(");
            }
            ResultSetConsumer consumer = new ResultSetConsumer(){

                @Override
                protected void processQuerySolution(QuerySolution qs) {
                    RDFNode node = qs.get(objectKey);
                    if (node != null && node.isURIResource()) {
                        list.add(QueryUtils.querySolutionToStringValueMap(qs));
                    }
                }
            };
            if (constructedModel == null) {
                this.selectFromRDFService(queryString, subjectUri, propertyUri, domainUri, rangeUri, consumer);
            } else {
                this.selectFromConstructedModel(queryString, subjectUri, propertyUri, domainUri, rangeUri, constructedModel, consumer);
            }
            if (log.isDebugEnabled()) {
                long duration = System.currentTimeMillis() - start;
                log.debug((Object)(duration + " to do list view for " + propertyUri + " / " + domainUri + " / " + rangeUri));
            }
        }
        return list;
    }

    private void selectFromRDFService(String queryString, String subjectUri, String propertyUri, String domainUri, String rangeUri, ResultSetConsumer consumer) {
        String[] part = queryString.split("[Ww][Hh][Ee][Rr][Ee]");
        part[1] = part[1].replace("?subject", "<" + subjectUri + ">");
        part[1] = part[1].replace("?property", "<" + propertyUri + ">");
        if (domainUri != null && !domainUri.startsWith("http://vitro.mannlib.cornell.edu/ns/bnode#")) {
            part[1] = part[1].replace("?subjectType", "<" + domainUri + ">");
        }
        if (rangeUri != null && !rangeUri.startsWith("http://vitro.mannlib.cornell.edu/ns/bnode#")) {
            part[1] = part[1].replace("?objectType", "<" + rangeUri + ">");
        }
        queryString = part[0] + "WHERE" + part[1];
        try {
            this.rdfService.sparqlSelectQuery(queryString, consumer);
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFromConstructedModel(String queryString, String subjectUri, String propertyUri, String domainUri, String rangeUri, Model constructedModel, ResultSetConsumer consumer) {
        Query query = null;
        try {
            query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        }
        catch (Throwable th) {
            log.error((Object)("Could not create SPARQL query for query string. " + th.getMessage()));
            log.error((Object)queryString);
            throw new RuntimeException(th);
        }
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("subject", (RDFNode)ResourceFactory.createResource((String)subjectUri));
        initialBindings.add("property", (RDFNode)ResourceFactory.createResource((String)propertyUri));
        if (domainUri != null && !domainUri.startsWith("http://vitro.mannlib.cornell.edu/ns/bnode#")) {
            initialBindings.add("subjectType", (RDFNode)ResourceFactory.createResource((String)domainUri));
        }
        if (rangeUri != null && !rangeUri.startsWith("http://vitro.mannlib.cornell.edu/ns/bnode#")) {
            initialBindings.add("objectType", (RDFNode)ResourceFactory.createResource((String)rangeUri));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Query string for object property " + propertyUri + ": " + queryString));
        }
        try (QueryExecution qexec = null;){
            qexec = QueryExecutionFactory.create((Query)query, (Model)constructedModel, (QuerySolution)initialBindings);
            consumer.processResultSet(qexec.execSelect());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model constructModelForSelectQueries(String subjectUri, String propertyUri, String rangeUri, Set<String> constructQueries) {
        if (constructQueries.size() == 0 || constructQueries == null) {
            return null;
        }
        Model constructedModel = ModelFactory.createDefaultModel();
        for (String queryString : constructQueries) {
            queryString = queryString.replace("?subject", "<" + subjectUri + ">");
            queryString = queryString.replace("?property", "<" + propertyUri + ">");
            if (rangeUri != null) {
                queryString = queryString.replace("?objectType", "<" + rangeUri + ">");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("CONSTRUCT query string for object property " + propertyUri + ": " + queryString));
            }
            try {
                if (this.rdfService == null) {
                    log.debug((Object)("RDF Service null, Using CONSTRUCT query string for object property " + propertyUri + ": " + queryString));
                    Query query = null;
                    try {
                        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
                    }
                    catch (Throwable th) {
                        log.error((Object)("Could not create CONSTRUCT SPARQL query for query string. " + th.getMessage()));
                        log.error((Object)queryString);
                        return constructedModel;
                    }
                    DatasetWrapper w = this.dwf.getDatasetWrapper();
                    Dataset dataset = w.getDataset();
                    dataset.getLock().enterCriticalSection(true);
                    QueryExecution qe = null;
                    try {
                        qe = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
                        qe.execConstruct(constructedModel);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error getting constructed model for subject " + subjectUri + " and property " + propertyUri));
                        continue;
                    }
                    finally {
                        if (qe != null) {
                            qe.close();
                        }
                        dataset.getLock().leaveCriticalSection();
                        w.close();
                        continue;
                    }
                }
                this.rdfService.sparqlConstructQuery(queryString, constructedModel);
            }
            catch (Exception e) {
                log.error((Object)("Error getting constructed model for subject " + subjectUri + " and property " + propertyUri), (Throwable)e);
            }
        }
        return constructedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMostSpecificTypesInClassgroupsForIndividual(String subjectUri) {
        String queryString = QueryUtils.subUriForQueryVar(MOST_SPECIFIC_TYPE_QUERY, "subject", subjectUri);
        log.debug((Object)("Query string for vitro:mostSpecificType : " + queryString));
        Query query = null;
        try {
            query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        }
        catch (Throwable th) {
            log.error((Object)("Could not create SPARQL query for query string. " + th.getMessage()));
            log.error((Object)queryString);
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
        DatasetWrapper w = this.dwf.getDatasetWrapper();
        Dataset dataset = w.getDataset();
        dataset.getLock().enterCriticalSection(true);
        QueryExecution qexec = null;
        try {
            qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                RDFNode typeNode = soln.get("type");
                String type = null;
                if (typeNode.isURIResource()) {
                    type = typeNode.asResource().getURI();
                }
                RDFNode labelNode = soln.get("label");
                String label = null;
                if (labelNode.isLiteral()) {
                    label = labelNode.asLiteral().getLexicalForm();
                }
                if (!StringUtils.isNotBlank((String)type) || !StringUtils.isNotBlank((String)label)) continue;
                types.put(type, label);
            }
            LinkedHashMap<String, String> linkedHashMap = types;
            return linkedHashMap;
        }
        catch (Exception e) {
            log.error((Object)("Error getting most specific types for subject " + subjectUri));
            Map<String, String> map = Collections.emptyMap();
            return map;
        }
        finally {
            dataset.getLock().leaveCriticalSection();
            if (qexec != null) {
                qexec.close();
            }
            w.close();
        }
    }

    @Override
    public void resolveAsFauxPropertyStatements(List<ObjectPropertyStatement> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        HashMap<String, List<FauxProperty>> fauxPropMap = new HashMap<String, List<FauxProperty>>();
        HashMap<String, VClass> vclassTypeMap = new HashMap<String, VClass>();
        HashMap<String, String> indVClassURIMap = new HashMap<String, String>();
        HashMap<String, List<String>> superClassMap = new HashMap<String, List<String>>();
        for (ObjectPropertyStatement stmt : list) {
            String fauxRangeVClassURI;
            VClass fauxRangeVClass;
            ObjectProperty prop = this.obtainObjectPropertyFromStatement(stmt);
            if (prop == null) continue;
            FauxProperty useThisFaux = null;
            List<FauxProperty> fauxProps = (List<FauxProperty>)fauxPropMap.get(prop.getURI());
            if (fauxProps == null) {
                fauxProps = this.getWebappDaoFactory().getFauxPropertyDao().getFauxPropertiesForBaseUri(prop.getURI());
                fauxPropMap.put(prop.getURI(), fauxProps);
            }
            if (fauxProps != null && !fauxProps.isEmpty()) {
                Object object;
                Individual subject;
                String domainVClassURI = (String)indVClassURIMap.get(stmt.getSubjectURI());
                String rangeVClassURI = (String)indVClassURIMap.get(stmt.getObjectURI());
                if (domainVClassURI == null && (subject = stmt.getSubject()) != null) {
                    domainVClassURI = subject.getVClassURI();
                    indVClassURIMap.put(subject.getURI(), domainVClassURI);
                }
                if (rangeVClassURI == null && (object = stmt.getObject()) != null) {
                    rangeVClassURI = object.getVClassURI();
                    indVClassURIMap.put(object.getURI(), rangeVClassURI);
                }
                if (domainVClassURI != null && rangeVClassURI != null) {
                    object = fauxProps.iterator();
                    while (object.hasNext()) {
                        FauxProperty fauxProp = (FauxProperty)object.next();
                        if (!domainVClassURI.equals(fauxProp.getDomainVClassURI()) || !rangeVClassURI.equals(fauxProp.getRangeVClassURI())) continue;
                        useThisFaux = fauxProp;
                        break;
                    }
                }
                if (useThisFaux == null) {
                    List<String> domainSuperClasses = (List<String>)superClassMap.get(domainVClassURI);
                    List<String> rangeSuperClasses = (List<String>)superClassMap.get(rangeVClassURI);
                    if (domainSuperClasses == null) {
                        domainSuperClasses = this.getWebappDaoFactory().getVClassDao().getAllSuperClassURIs(domainVClassURI);
                        if (!domainSuperClasses.contains(domainVClassURI)) {
                            domainSuperClasses.add(domainVClassURI);
                        }
                        superClassMap.put(domainVClassURI, domainSuperClasses);
                    }
                    if (rangeSuperClasses == null) {
                        rangeSuperClasses = this.getWebappDaoFactory().getVClassDao().getAllSuperClassURIs(rangeVClassURI);
                        if (!rangeSuperClasses.contains(rangeVClassURI)) {
                            rangeSuperClasses.add(rangeVClassURI);
                        }
                        superClassMap.put(rangeVClassURI, rangeSuperClasses);
                    }
                    if (domainSuperClasses != null && domainSuperClasses.size() > 0 && rangeSuperClasses != null && rangeSuperClasses.size() > 0) {
                        for (FauxProperty fauxProp : fauxProps) {
                            if (!domainSuperClasses.contains(fauxProp.getDomainVClassURI()) || !rangeSuperClasses.contains(fauxProp.getRangeVClassURI())) continue;
                            useThisFaux = fauxProp;
                            break;
                        }
                    }
                }
            }
            if (useThisFaux == null) continue;
            String fauxDomainVClassURI = useThisFaux.getDomainVClassURI();
            VClass fauxDomainVClass = (VClass)vclassTypeMap.get(fauxDomainVClassURI);
            if (fauxDomainVClass == null) {
                fauxDomainVClass = this.getWebappDaoFactory().getVClassDao().getVClassByURI(fauxDomainVClassURI);
                vclassTypeMap.put(fauxDomainVClassURI, fauxDomainVClass);
            }
            if ((fauxRangeVClass = (VClass)vclassTypeMap.get(fauxRangeVClassURI = useThisFaux.getRangeVClassURI())) == null) {
                fauxRangeVClass = this.getWebappDaoFactory().getVClassDao().getVClassByURI(fauxRangeVClassURI);
                vclassTypeMap.put(fauxRangeVClassURI, fauxRangeVClass);
            }
            if (fauxDomainVClass != null && fauxDomainVClassURI != null) {
                prop.setDomainVClass(fauxDomainVClass);
                prop.setDomainVClassURI(fauxDomainVClassURI);
            }
            if (fauxRangeVClass == null || fauxRangeVClassURI == null) continue;
            prop.setRangeVClass(fauxRangeVClass);
            prop.setRangeVClassURI(fauxRangeVClassURI);
        }
    }

    private ObjectProperty obtainObjectPropertyFromStatement(ObjectPropertyStatement stmt) {
        ObjectProperty prop = stmt.getProperty();
        if (prop != null) {
            return prop;
        }
        String propertyURI = stmt.getPropertyURI();
        if (propertyURI == null) {
            return null;
        }
        return this.getWebappDaoFactory().getObjectPropertyDao().getObjectPropertyByURI(propertyURI);
    }

    private Individual obtainSubjectFromStatement(ObjectPropertyStatement stmt) {
        Individual subject = stmt.getSubject();
        if (subject != null) {
            return subject;
        }
        String subjectURI = stmt.getSubjectURI();
        if (subjectURI == null) {
            return null;
        }
        return this.getWebappDaoFactory().getIndividualDao().getIndividualByURI(subjectURI);
    }

    private Individual obtainObjectFromStatement(ObjectPropertyStatement stmt) {
        Individual object = stmt.getObject();
        if (object != null) {
            return object;
        }
        String objectURI = stmt.getObjectURI();
        if (objectURI == null) {
            return null;
        }
        return this.getWebappDaoFactory().getIndividualDao().getIndividualByURI(objectURI);
    }

    private VClass selectType(List<VClass> types, String uri) {
        for (VClass type : types) {
            if (!Objects.equals(type.getURI(), uri)) continue;
            return type;
        }
        return null;
    }
}

