/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.IndividualSDB;
import edu.cornell.mannlib.vitro.webapp.dao.jena.ObjectPropertyStatementDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactorySDB;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectPropertyStatementDaoSDB
extends ObjectPropertyStatementDaoJena
implements ObjectPropertyStatementDao {
    private static final Log log = LogFactory.getLog(ObjectPropertyStatementDaoSDB.class);
    private static final String SUBJECT_TYPE_QUERY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nCONSTRUCT { \n   ?uri rdf:type ?type . \n} WHERE { \n   ?uri rdf:type ?type . \n} \n";
    private static final String OBJECT_TYPE_QUERY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nCONSTRUCT { \n   ?uri ?p ?o . \n   ?o rdf:type ?type . \n} WHERE { \n   ?uri ?p ?o . \n   ?o rdf:type ?type . \n} \n";
    private static final String OBJECT_LABEL_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nCONSTRUCT { \n   ?uri ?p ?o . \n   ?o rdfs:label ?label . \n} WHERE { \n   ?uri ?p ?o . \n   ?o rdfs:label ?label . \n} \n";
    private final WebappDaoFactorySDB wadf;
    private final WebappDaoFactorySDB.SDBDatasetMode datasetMode;

    public ObjectPropertyStatementDaoSDB(RDFService rdfService, DatasetWrapperFactory dwf, WebappDaoFactorySDB.SDBDatasetMode datasetMode, WebappDaoFactorySDB wadf) {
        super(rdfService, dwf, wadf);
        this.wadf = wadf;
        this.datasetMode = datasetMode;
    }

    @Override
    public Individual fillExistingObjectPropertyStatements(Individual entity) {
        if (entity == null || entity.getURI() == null) {
            return entity;
        }
        ArrayList<ObjectPropertyStatement> objectPropertyStatements = new ArrayList<ObjectPropertyStatement>();
        String subjectUri = entity.getURI();
        Model m = this.getInfoForObjectsOfThisEntity(subjectUri);
        Set<String> subjectTypes = this.getTypes(m, subjectUri);
        for (ObjectPropertyPair pair : this.getRawObjectPropertyPairs(m, subjectUri)) {
            String predicateUri = pair.getPredicateUri();
            String objectUri = pair.getObjectUri();
            Set<String> objectTypes = this.getTypes(m, objectUri);
            ObjectProperty prop = this.findRawProperty(predicateUri);
            if (prop == null) continue;
            IndividualSDB object = new IndividualSDB(objectUri, this.dwf, this.datasetMode, this.wadf, m);
            objectPropertyStatements.add(this.createStatement(entity, prop, object));
        }
        entity.setObjectPropertyStatements(objectPropertyStatements);
        return entity;
    }

    private Model getInfoForObjectsOfThisEntity(String subjectUri) {
        Model m = ModelFactory.createDefaultModel();
        try {
            m.add(RDFServiceUtils.parseModel(this.rdfService.sparqlConstructQuery(this.substituteUri(subjectUri, SUBJECT_TYPE_QUERY), RDFService.ModelSerializationFormat.N3), RDFService.ModelSerializationFormat.N3));
            m.add(RDFServiceUtils.parseModel(this.rdfService.sparqlConstructQuery(this.substituteUri(subjectUri, OBJECT_TYPE_QUERY), RDFService.ModelSerializationFormat.N3), RDFService.ModelSerializationFormat.N3));
            m.add(RDFServiceUtils.parseModel(this.rdfService.sparqlConstructQuery(this.substituteUri(subjectUri, OBJECT_LABEL_QUERY), RDFService.ModelSerializationFormat.N3), RDFService.ModelSerializationFormat.N3));
        }
        catch (RDFServiceException e) {
            log.warn((Object)("Failed to fill object property statements for '" + subjectUri + "'"), (Throwable)e);
        }
        return m;
    }

    private String substituteUri(String uri, String query) {
        return query.replace("?uri", "<" + uri + "> ");
    }

    private Set<String> getTypes(Model m, String uri) {
        HashSet<String> typeUris = new HashSet<String>();
        for (RDFNode typeNode : m.listObjectsOfProperty(m.createResource(uri), RDF.type).toSet()) {
            if (!typeNode.isURIResource()) continue;
            typeUris.add(typeNode.asResource().getURI());
        }
        return typeUris;
    }

    private List<ObjectPropertyPair> getRawObjectPropertyPairs(Model m, String subjectUri) {
        ArrayList<ObjectPropertyPair> list = new ArrayList<ObjectPropertyPair>();
        for (Statement stmt : m.listStatements(m.createResource(subjectUri), null, (RDFNode)null).toList()) {
            if (this.wadf.getNonuserNamespaces().contains(stmt.getPredicate().getNameSpace()) || !stmt.getObject().isURIResource()) continue;
            list.add(new ObjectPropertyPair(stmt.getPredicate().getURI(), stmt.getObject().asResource().getURI()));
        }
        return list;
    }

    private ObjectProperty findRawProperty(String predicateUri) {
        return this.wadf.getObjectPropertyDao().getObjectPropertyByURI(predicateUri);
    }

    private ObjectPropertyStatement createStatement(Individual entity, ObjectProperty prop, Individual object) {
        ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
        ops.setSubject(entity);
        ops.setProperty(prop);
        ops.setObject(object);
        return ops;
    }

    private static class ObjectPropertyPair {
        private final String predicateUri;
        private final String objectUri;

        public ObjectPropertyPair(String predicateUri, String objectUri) {
            this.predicateUri = predicateUri;
            this.objectUri = objectUri;
        }

        public String getPredicateUri() {
            return this.predicateUri;
        }

        public String getObjectUri() {
            return this.objectUri;
        }
    }
}

