/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OntologyDaoJena
extends JenaBaseDao
implements OntologyDao {
    public OntologyDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getTBoxModel();
    }

    public static synchronized String adjustOntologyURI(String ontologyURI) {
        String uri = ontologyURI.trim();
        int length = uri.length();
        if (length > 1 && uri.charAt(length - 1) == '#') {
            return uri.substring(0, length - 1);
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.hp.hpl.jena.ontology.Ontology getOntology(String ontologyURI, OntModel ontModel) {
        try {
            ontModel.enterCriticalSection(true);
            com.hp.hpl.jena.ontology.Ontology o = ontModel.getOntology(ontologyURI);
            if (o != null) {
                com.hp.hpl.jena.ontology.Ontology ontology = o;
                return ontology;
            }
            com.hp.hpl.jena.ontology.Ontology ontology = ontModel.getOntology(OntologyDaoJena.adjustOntologyURI(ontologyURI));
            return ontology;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void deleteOntology(Ontology ontology) {
        this.deleteOntology(ontology, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOntology(Ontology ontology, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            com.hp.hpl.jena.ontology.Ontology o = this.getOntology(ontology.getURI(), ontModel);
            if (o == null) {
                o = ontModel.getOntology(OntologyDaoJena.adjustOntologyURI(ontology.getURI()));
            }
            if (o != null) {
                o.remove();
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Ontology> getAllOntologies() {
        ArrayList<Ontology> ontologies = new ArrayList<Ontology>();
        this.getOntModel().enterCriticalSection(true);
        try (ExtendedIterator ontIt = this.getOntModel().listOntologies();){
            while (ontIt.hasNext()) {
                OntResource ontRes = (OntResource)ontIt.next();
                if (this.NONUSER_NAMESPACES.contains(ontRes.getURI()) || this.NONUSER_NAMESPACES.contains(ontRes.getURI() + "#")) continue;
                ontologies.add(this.ontologyFromOntologyResource(ontRes));
            }
        }
        catch (ProfileException profileException) {
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        Collections.sort(ontologies);
        return ontologies.size() > 0 ? ontologies : null;
    }

    @Override
    public Ontology getOntologyByURI(String ontologyURI) {
        Ontology o = null;
        try {
            o = this.ontologyFromOntologyResource((OntResource)this.getOntology(ontologyURI, this.getOntModel()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (o == null) {
            try {
                o = this.ontologyFromOntologyResource((OntResource)this.getOntology(OntologyDaoJena.adjustOntologyURI(ontologyURI), this.getOntModel()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o;
    }

    @Override
    public String insertNewOntology(Ontology ontology) {
        return this.insertNewOntology(ontology, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertNewOntology(Ontology ontology, OntModel ontModel) {
        String string;
        if (ontology == null) {
            return null;
        }
        String ontologyURI = this.adjustAndValidateOntologyURI(ontology.getURI());
        ontModel.enterCriticalSection(false);
        try {
            com.hp.hpl.jena.ontology.Ontology o = ontModel.createOntology(ontologyURI);
            if (ontology.getName() != null && ontology.getName().length() > 0) {
                o.setLabel(ontology.getName(), this.getDefaultLanguage());
            }
            if (ontology.getPrefix() != null && ontology.getPrefix().length() > 0) {
                this.addPropertyStringValue((Resource)o, (Property)this.ONTOLOGY_PREFIX_ANNOT, ontology.getPrefix(), (Model)ontModel);
            }
            string = o.getURI();
        }
        catch (Throwable throwable) {
            try {
                ontModel.leaveCriticalSection();
                throw throwable;
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Failed to insert new ontology: " + ontology), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        ontModel.leaveCriticalSection();
        return string;
    }

    private String adjustAndValidateOntologyURI(String uri) throws URISyntaxException {
        if (uri == null || uri.isEmpty()) {
            throw new URISyntaxException(uri, "URI is empty");
        }
        String adjusted = OntologyDaoJena.adjustOntologyURI(uri);
        return new URI(adjusted).toString();
    }

    @Override
    public void updateOntology(Ontology ontology) {
        this.updateOntology(ontology, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOntology(Ontology ontology, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        if (ontology != null && ontology.getURI() != null && ontology.getURI().length() > 0) {
            try {
                com.hp.hpl.jena.ontology.Ontology o = this.getOntology(ontology.getURI(), ontModel);
                if (o == null) {
                    log.error((Object)("OntologyDaoJena.updateOntology() could not find ontology " + ontology.getURI() + " in Jena model"));
                } else {
                    this.updateRDFSLabel((OntResource)o, ontology.getName());
                    this.updatePropertyStringValue((Resource)o, (Property)this.ONTOLOGY_PREFIX_ANNOT, ontology.getPrefix(), (Model)ontModel);
                }
            }
            finally {
                ontModel.leaveCriticalSection();
            }
        }
    }

    private Ontology ontologyFromOntologyResource(OntResource ontRes) {
        if (ontRes == null) {
            return null;
        }
        Ontology ontology = new Ontology();
        ontology.setName(this.getLabelOrId(ontRes));
        ontology.setURI(ontRes.getURI());
        ontology.setPrefix(this.getPropertyStringValue(ontRes, (Property)this.ONTOLOGY_PREFIX_ANNOT));
        if (!ontology.getURI().substring(ontology.getURI().length() - 1, ontology.getURI().length()).equals("#") && !ontology.getURI().substring(ontology.getURI().length() - 1, ontology.getURI().length()).equals("/")) {
            ontology.setURI(ontology.getURI() + "#");
        }
        return ontology;
    }
}

