/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.dao.DisplayVocabulary;
import edu.cornell.mannlib.vitro.webapp.dao.PageDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageDaoJena
extends JenaBaseDao
implements PageDao {
    static final Log log = LogFactory.getLog(PageDaoJena.class);
    protected static Query pageQuery;
    protected static Query pageTypeQuery;
    protected static Query pageDataGetterTypeQuery;
    protected static Query dataGetterURIsQuery;
    protected static Query pageMappingsQuery;
    protected static Query homePageUriQuery;
    protected static Query classGroupPageQuery;
    protected static Query classIntersectionPageQuery;
    protected static Query individualsForClassesQuery;
    protected static Query individualsForClassesRestrictedQuery;
    protected static Query institutionalInternalClassQuery;
    protected static Query individualsForClassesInternalQuery;
    protected static Query dataGetterClassQuery;
    static final String prefixes = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n";
    protected static final String pageQueryString;
    protected static final String pageTypeQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?type WHERE {\n    ?pageUri rdf:type ?type .\n} \n";
    protected static final String pageDataGetterTypesQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?dataGetterType WHERE {\n    ?pageUri display:hasDataGetter ?dg .\n \t ?dg rdf:type ?dataGetterType . \n} \n";
    protected static final String requiredActionsQuery = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?requiredAction WHERE{\n    ?pageUri <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#requiresAction>  ?requiredAction .\n}";
    protected static final String dataGetterURIsQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?dg WHERE {\n    ?pageUri display:hasDataGetter ?dg .\n}";
    protected static final String pageMappingsQueryString;
    protected static final String homePageUriQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?pageUri WHERE {\n    ?pageUri rdf:type <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#HomePage> .\n} \n";
    protected static final String classGroupPageQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?classGroup WHERE {\n ?pageUri display:hasDataGetter ?dg .\n ?dg <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup> ?classGroup . \n} \n";
    protected static final String individualsForClassesDataGetterQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?dg ?class ?restrictClass WHERE {\n    ?pageUri display:hasDataGetter ?dg .\n ?dg <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass> ?class . \n    OPTIONAL {?dg <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByClass> ?restrictClass } .\n} \n";
    protected static final String individualsForClassesRestrictedQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?restrictClass WHERE {\n    ?dg <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByClass> ?restrictClass .\n} \n";
    protected static final String institutionalInternalClassQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?restrictByInternalClass WHERE {\n    ?dg <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByInternalClass> ?restrictsByInternalClass .\n} \n";
    protected static final String individualsForClassesInternalQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?dg ?class ?isInternal WHERE {\n    ?pageUri display:hasDataGetter ?dg .\n ?dg <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass> ?class . \n OPTIONAL {  ?dg <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByInternalClass> ?isInternal } .\n} \n";
    protected static final String usesDataGetterClassQueryString;

    public PageDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getPageMappings() {
        OntModel displayModel = this.getOntModelSelector().getDisplayModel();
        HashMap<String, String> rv = new HashMap<String, String>();
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)pageQuery, (Model)displayModel);){
            ResultSet resultSet = qexec.execSelect();
            while (resultSet.hasNext()) {
                QuerySolution soln = resultSet.next();
                rv.put(PageDaoJena.nodeToString(soln.get("urlMapping")), PageDaoJena.nodeToString(soln.get("pageUri")));
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getPage(String pageUri) {
        List<Map<String, Object>> list;
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("pageUri", (RDFNode)ResourceFactory.createResource((String)pageUri));
        OntModel displayModel = this.getOntModelSelector().getDisplayModel();
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)pageQuery, (Model)displayModel, (QuerySolution)initialBindings);){
            list = this.executeQueryToCollection(qexec);
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        if (list == null) {
            log.error((Object)"executeQueryToCollection returned null.");
            return Collections.emptyMap();
        }
        if (list.size() == 0) {
            log.debug((Object)("no page found for " + pageUri));
            return Collections.emptyMap();
        }
        if (list.size() > 1) {
            log.debug((Object)("multiple results found for " + pageUri + " using only the first."));
        }
        Map<String, Object> pageData = list.get(0);
        ArrayList<String> dataGetterTypes = new ArrayList<String>();
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)pageDataGetterTypeQuery, (Model)displayModel, (QuerySolution)initialBindings);){
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution soln = rs.next();
                dataGetterTypes.add(PageDaoJena.nodeToString(soln.get("dataGetterType")));
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        pageData.put("dataGetterTypes", dataGetterTypes);
        ArrayList<String> dataGetterURIs = new ArrayList<String>();
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)dataGetterURIsQuery, (Model)displayModel, (QuerySolution)initialBindings);){
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution soln = rs.next();
                dataGetterURIs.add(PageDaoJena.nodeToString(soln.get("dg")));
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        pageData.put("dataGetterURIs", dataGetterURIs);
        return pageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHomePageUri() {
        OntModel displayModel = this.getOntModelSelector().getDisplayModel();
        ArrayList<String> rv = new ArrayList<String>();
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)homePageUriQuery, (Model)displayModel);){
            ResultSet resultSet = qexec.execSelect();
            while (resultSet.hasNext()) {
                QuerySolution soln = resultSet.next();
                rv.add(PageDaoJena.nodeToString(soln.get("pageUri")));
            }
            if (rv.size() == 0) {
                log.error((Object)"No display:HomePage defined in display model.");
                Iterator iterator = null;
                return iterator;
            }
            if (rv.size() > 1) {
                log.error((Object)"More than one display:HomePage defined in display model.");
                for (String hp : rv) {
                    log.error((Object)("home page: " + hp));
                }
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        return (String)rv.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClassGroupPage(String pageUri) {
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("pageUri", (RDFNode)ResourceFactory.createResource((String)pageUri));
        OntModel displayModel = this.getOntModelSelector().getDisplayModel();
        displayModel.enterCriticalSection(false);
        try {
            String string;
            ArrayList<String> classGroupsForPage;
            QueryExecution qexec;
            block10: {
                qexec = QueryExecutionFactory.create((Query)classGroupPageQuery, (Model)displayModel, (QuerySolution)initialBindings);
                try {
                    classGroupsForPage = new ArrayList<String>();
                    ResultSet resultSet = qexec.execSelect();
                    while (resultSet.hasNext()) {
                        QuerySolution soln = resultSet.next();
                        classGroupsForPage.add(PageDaoJena.nodeToString(soln.get("classGroup")));
                    }
                    if (classGroupsForPage.size() != 0) break block10;
                    log.debug((Object)("No classgroup info defined in display model for " + pageUri));
                    string = null;
                }
                catch (Throwable throwable) {
                    qexec.close();
                    throw throwable;
                }
                qexec.close();
                return string;
            }
            if (classGroupsForPage.size() > 1) {
                log.error((Object)("More than one display:forClassGroup defined in display model for page " + pageUri));
            }
            string = (String)classGroupsForPage.get(0);
            qexec.close();
            return string;
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getClassesAndRestrictionsForPage(String pageUri) {
        HashMap<String, Object> classesAndRestrictions = new HashMap<String, Object>();
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("pageUri", (RDFNode)ResourceFactory.createResource((String)pageUri));
        ArrayList<String> classes = new ArrayList<String>();
        OntModel displayModel = this.getOntModelSelector().getDisplayModel();
        displayModel.enterCriticalSection(false);
        try {
            HashMap<String, Object> hashMap;
            ArrayList<String> restrictClasses;
            QueryExecution qexec;
            block9: {
                qexec = QueryExecutionFactory.create((Query)individualsForClassesQuery, (Model)displayModel, (QuerySolution)initialBindings);
                try {
                    HashMap<String, String> restrictClassesPresentMap = new HashMap<String, String>();
                    restrictClasses = new ArrayList<String>();
                    ResultSet resultSet = qexec.execSelect();
                    while (resultSet.hasNext()) {
                        QuerySolution soln = resultSet.next();
                        String dg = PageDaoJena.nodeToString(soln.get("dg"));
                        classes.add(PageDaoJena.nodeToString(soln.get("class")));
                        String restrictClass = PageDaoJena.nodeToString(soln.get("restrictClass"));
                        if (restrictClass.isEmpty() || restrictClassesPresentMap.containsKey(restrictClass)) continue;
                        restrictClasses.add(restrictClass);
                        restrictClassesPresentMap.put(restrictClass, "true");
                    }
                    if (classes.size() != 0) break block9;
                    log.debug((Object)("No classes  defined in display model for " + pageUri));
                    hashMap = null;
                }
                catch (Throwable throwable) {
                    qexec.close();
                    throw throwable;
                }
                qexec.close();
                return hashMap;
            }
            classesAndRestrictions.put("classes", classes);
            classesAndRestrictions.put("restrictClasses", restrictClasses);
            hashMap = classesAndRestrictions;
            qexec.close();
            return hashMap;
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getClassesAndCheckInternal(String pageUri) {
        HashMap<String, Object> classesAndRestrictions = new HashMap<String, Object>();
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("pageUri", (RDFNode)ResourceFactory.createResource((String)pageUri));
        ArrayList<String> classes = new ArrayList<String>();
        OntModel displayModel = this.getOntModelSelector().getDisplayModel();
        displayModel.enterCriticalSection(false);
        try {
            HashMap<String, Object> hashMap;
            QueryExecution qexec;
            block9: {
                qexec = QueryExecutionFactory.create((Query)individualsForClassesInternalQuery, (Model)displayModel, (QuerySolution)initialBindings);
                try {
                    ResultSet resultSet = qexec.execSelect();
                    while (resultSet.hasNext()) {
                        QuerySolution soln = resultSet.next();
                        String dg = PageDaoJena.nodeToString(soln.get("dg"));
                        classes.add(PageDaoJena.nodeToString(soln.get("class")));
                        String isInternal = PageDaoJena.nodeToString(soln.get("isInternal"));
                        if (isInternal.isEmpty()) continue;
                        log.debug((Object)("Internal value is " + isInternal));
                        classesAndRestrictions.put("isInternal", isInternal);
                    }
                    if (classes.size() != 0) break block9;
                    log.debug((Object)("No classes  defined in display model for " + pageUri));
                    hashMap = null;
                }
                catch (Throwable throwable) {
                    qexec.close();
                    throw throwable;
                }
                qexec.close();
                return hashMap;
            }
            classesAndRestrictions.put("classes", classes);
            hashMap = classesAndRestrictions;
            qexec.close();
            return hashMap;
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDataGetterClass(String pageUri) {
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("pageUri", (RDFNode)ResourceFactory.createResource((String)pageUri));
        ArrayList<String> dataGetterClasses = new ArrayList<String>();
        OntModel displayModel = this.getOntModelSelector().getDisplayModel();
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)dataGetterClassQuery, (Model)displayModel, (QuerySolution)initialBindings);){
            ResultSet resultSet = qexec.execSelect();
            while (resultSet.hasNext()) {
                QuerySolution soln = resultSet.next();
                dataGetterClasses.add(PageDaoJena.nodeToString(soln.get("dgClass")));
            }
            if (dataGetterClasses.size() == 0) {
                log.debug((Object)("No data getter classes defined for  " + pageUri));
                List<String> list = null;
                return list;
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        return dataGetterClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRequiredActions(String pageUri) {
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("pageUri", (RDFNode)ResourceFactory.createResource((String)pageUri));
        ArrayList<String> actions = new ArrayList();
        OntModel dModel = this.getOntModelSelector().getDisplayModel();
        dModel.enterCriticalSection(false);
        try {
            QueryExecution qe = QueryExecutionFactory.create((String)requiredActionsQuery, (Model)dModel, (QuerySolution)initialBindings);
            actions = this.executeQueryToList(qe);
            qe.close();
        }
        finally {
            dModel.leaveCriticalSection();
        }
        return actions;
    }

    protected List<String> executeQueryToList(QueryExecution qex) {
        LinkedList<String> rv = new LinkedList<String>();
        ResultSet results = qex.execSelect();
        while (results.hasNext()) {
            rv.add(this.querySolutionToString(results.nextSolution()));
        }
        return rv;
    }

    protected String querySolutionToString(QuerySolution soln) {
        Iterator varNames = soln.varNames();
        if (varNames.hasNext()) {
            String name = (String)varNames.next();
            return PageDaoJena.nodeToString(soln.get(name));
        }
        return "";
    }

    protected List<Map<String, Object>> executeQueryToCollection(QueryExecution qexec) {
        ArrayList<Map<String, Object>> rv = new ArrayList<Map<String, Object>>();
        ResultSet results = qexec.execSelect();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            rv.add(this.querySolutionToMap(soln));
        }
        return rv;
    }

    protected Map<String, Object> querySolutionToMap(QuerySolution soln) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator varNames = soln.varNames();
        while (varNames.hasNext()) {
            String varName = (String)varNames.next();
            map.put(varName, PageDaoJena.nodeToObject(soln.get(varName)));
        }
        return map;
    }

    protected static Object nodeToObject(RDFNode node) {
        if (node == null) {
            return "";
        }
        if (node.isLiteral()) {
            Literal literal = node.asLiteral();
            return literal.getValue();
        }
        if (node.isURIResource()) {
            Resource resource = node.asResource();
            return resource.getURI();
        }
        if (node.isAnon()) {
            Resource resource = node.asResource();
            return resource.getId().getLabelString();
        }
        return "";
    }

    protected static String nodeToString(RDFNode node) {
        if (node == null) {
            return "";
        }
        if (node.isLiteral()) {
            Literal literal = node.asLiteral();
            return literal.getLexicalForm();
        }
        if (node.isURIResource()) {
            Resource resource = node.asResource();
            return resource.getURI();
        }
        if (node.isAnon()) {
            Resource resource = node.asResource();
            return resource.getId().getLabelString();
        }
        return "";
    }

    static {
        pageQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?pageUri ?bodyTemplate ?urlMapping ?title WHERE {\n    ?pageUri rdf:type <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#Page>.\n    OPTIONAL { ?pageUri <" + DisplayVocabulary.REQUIRES_BODY_TEMPLATE + "> ?bodyTemplate }.\n" + "    OPTIONAL { ?pageUri <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#title" + "> ?title }.\n" + "    OPTIONAL { ?pageUri <" + DisplayVocabulary.URL_MAPPING + "> ?urlMapping . }\n" + "} \n";
        pageMappingsQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?pageUri ?urlMapping WHERE {\n    ?pageUri rdf:type <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#Page> .\n    ?pageUri <" + DisplayVocabulary.URL_MAPPING + "> ?urlMapping . \n" + "} \n";
        usesDataGetterClassQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?dgClass WHERE {\n ?pageUri display:hasDataGetter ?dg .\n ?dg <" + RDF.type.getURI() + "> ?dgClass . \n" + "} \n";
        try {
            pageQuery = QueryFactory.create((String)pageQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for pageQuery " + th.getMessage()));
            log.error((Object)pageQueryString);
        }
        try {
            pageTypeQuery = QueryFactory.create((String)pageTypeQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for pageTypeQuery " + th.getMessage()));
            log.error((Object)pageTypeQueryString);
        }
        try {
            pageDataGetterTypeQuery = QueryFactory.create((String)pageDataGetterTypesQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for pageTypeQuery " + th.getMessage()));
            log.error((Object)pageDataGetterTypesQueryString);
        }
        try {
            dataGetterURIsQuery = QueryFactory.create((String)dataGetterURIsQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for dataGetterURIsQuery " + th.getMessage()));
            log.error((Object)dataGetterURIsQueryString);
        }
        try {
            pageMappingsQuery = QueryFactory.create((String)pageMappingsQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for pageMappingsQuery " + th.getMessage()));
            log.error((Object)pageMappingsQueryString);
        }
        try {
            homePageUriQuery = QueryFactory.create((String)homePageUriQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for homePageUriQuery " + th.getMessage()));
            log.error((Object)homePageUriQueryString);
        }
        try {
            classGroupPageQuery = QueryFactory.create((String)classGroupPageQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for classGroupPageQuery " + th.getMessage()));
            log.error((Object)classGroupPageQueryString);
        }
        try {
            individualsForClassesQuery = QueryFactory.create((String)individualsForClassesDataGetterQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for individualsForClassesQuery " + th.getMessage()));
            log.error((Object)individualsForClassesDataGetterQueryString);
        }
        try {
            individualsForClassesRestrictedQuery = QueryFactory.create((String)individualsForClassesRestrictedQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for individualsForClassesRestrictedQuery " + th.getMessage()));
            log.error((Object)individualsForClassesDataGetterQueryString);
        }
        try {
            institutionalInternalClassQuery = QueryFactory.create((String)institutionalInternalClassQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for institutionalInternalClassQuery " + th.getMessage()));
            log.error((Object)institutionalInternalClassQueryString);
        }
        try {
            individualsForClassesInternalQuery = QueryFactory.create((String)individualsForClassesInternalQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for individualsForClassesInternalQuery " + th.getMessage()));
            log.error((Object)individualsForClassesInternalQueryString);
        }
        try {
            dataGetterClassQuery = QueryFactory.create((String)usesDataGetterClassQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for dataGetterClassQuery " + th.getMessage()));
            log.error((Object)usesDataGetterClassQueryString);
        }
    }
}

