/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryUtils {
    private static final Log log = LogFactory.getLog(QueryUtils.class);

    private QueryUtils() {
    }

    public static Map<String, Object> querySolutionToObjectValueMap(QuerySolution soln) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator varNames = soln.varNames();
        while (varNames.hasNext()) {
            String varName = (String)varNames.next();
            Object value = QueryUtils.nodeToObject(soln.get(varName));
            log.debug((Object)("Adding " + varName + " : " + value + " to query solution data."));
            map.put(varName, value);
        }
        return map;
    }

    public static Map<String, String> querySolutionToStringValueMap(QuerySolution soln) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator varNames = soln.varNames();
        while (varNames.hasNext()) {
            String varName = (String)varNames.next();
            String value = QueryUtils.nodeToString(soln.get(varName));
            log.debug((Object)("Adding " + varName + " : " + value + " to query solution data."));
            map.put(varName, value);
        }
        return map;
    }

    public static List<Map<String, String>> removeDuplicatesMapsFromList(List<Map<String, String>> rawList, String ... keys) {
        ArrayList<Map<String, String>> filteredList = new ArrayList<Map<String, String>>();
        block0: for (Map<String, String> rawMap : rawList) {
            for (Map map : filteredList) {
                for (String key : keys) {
                    String rawValue = rawMap.get(key);
                    if (rawValue == null || !rawValue.equals(map.get(key))) continue;
                    if (!log.isDebugEnabled()) continue block0;
                    QueryUtils.logDuplicateRows(rawMap, map, keys);
                    continue block0;
                }
            }
            filteredList.add(rawMap);
        }
        return filteredList;
    }

    private static void logDuplicateRows(Map<String, String> rawMap, Map<String, String> filteredMap, String ... keys) {
        log.debug((Object)("Found duplicate rows, by at least one of these keys: " + Arrays.toString(keys) + ". Keeping " + filteredMap + ". Discarding " + rawMap + "."));
    }

    public static Object nodeToObject(RDFNode node) {
        if (node == null) {
            return "";
        }
        if (node.isLiteral()) {
            Literal literal = node.asLiteral();
            return literal.getValue();
        }
        if (node.isURIResource()) {
            Resource resource = node.asResource();
            return resource.getURI();
        }
        if (node.isAnon()) {
            Resource resource = node.asResource();
            return resource.getId().getLabelString();
        }
        return "";
    }

    public static String nodeToString(RDFNode node) {
        if (node == null) {
            return "";
        }
        if (node.isLiteral()) {
            Literal literal = node.asLiteral();
            return literal.getLexicalForm();
        }
        if (node.isURIResource()) {
            Resource resource = node.asResource();
            return resource.getURI();
        }
        if (node.isAnon()) {
            Resource resource = node.asResource();
            return resource.getId().getLabelString();
        }
        return "";
    }

    public static String subUrisForQueryVars(String queryString, Map<String, String> varsToUris) {
        for (String var : varsToUris.keySet()) {
            queryString = QueryUtils.subUriForQueryVar(queryString, var, varsToUris.get(var));
        }
        return queryString;
    }

    public static String subUriForQueryVar(String queryString, String varName, String uri) {
        return queryString.replaceAll("\\?" + varName + "\\b", "<" + uri + ">");
    }

    public static String replaceQueryVar(String queryString, String varName, String newVarName) {
        return queryString.replaceAll("\\?" + varName + "\\b", "?" + newVarName);
    }

    public static ResultSet getQueryResults(String queryStr, VitroRequest vreq) {
        return QueryUtils.getQueryResults(queryStr, vreq.getRDFService());
    }

    public static ResultSet getQueryResults(String queryStr, QuerySolution initialBindings, RDFService rdfService) {
        return QueryUtils.getQueryResults(QueryUtils.bindVariables(queryStr, initialBindings), rdfService);
    }

    public static ResultSet getLanguageNeutralQueryResults(String queryStr, VitroRequest vreq) {
        return QueryUtils.getQueryResults(queryStr, vreq.getUnfilteredRDFService());
    }

    private static ResultSet getQueryResults(String queryStr, RDFService rdfService) {
        try {
            return ResultSetFactory.fromJSON((InputStream)rdfService.sparqlSelectQuery(queryStr, RDFService.ResultFormat.JSON));
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public static String bindVariables(String queryStr, QuerySolution initialBindings) {
        String bound = queryStr;
        Iterator it = initialBindings.varNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            RDFNode node = initialBindings.get(name);
            if (node.isLiteral()) {
                bound = bound.replace('?' + name, QueryUtils.literalToString(node.asLiteral()));
                continue;
            }
            if (node.isURIResource()) {
                bound = bound.replace('?' + name, '<' + node.asResource().getURI() + '>');
                continue;
            }
            log.warn((Object)("Failed to bind anonymous resource variable '" + name + "' to query '" + bound + "'"));
        }
        return bound;
    }

    private static String literalToString(Literal l) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"').append(l.getLexicalForm()).append('\"');
        if (l.getDatatypeURI() != null) {
            buffer.append("^^<").append(l.getDatatypeURI()).append(">");
        } else if (StringUtils.isNotEmpty((String)l.getLanguage())) {
            buffer.append("@").append(l.getLanguage());
        }
        return buffer.toString();
    }
}

