/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Context;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDatasetGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFServiceDataset
implements Dataset {
    private RDFServiceDatasetGraph g;
    private ReadWrite transactionMode;
    private static final Log log = LogFactory.getLog(RDFServiceDataset.class);

    public RDFServiceDataset(RDFServiceDatasetGraph g) {
        this.g = g;
    }

    public RDFServiceDataset(RDFService rdfService) {
        this.g = new RDFServiceDatasetGraph(rdfService);
    }

    public DatasetGraph asDatasetGraph() {
        return this.g;
    }

    public void close() {
        this.g.close();
    }

    public boolean containsNamedModel(String arg0) {
        return this.g.containsGraph(NodeFactory.createURI((String)arg0));
    }

    public Model getDefaultModel() {
        return RDFServiceGraph.createRDFServiceModel(this.g.getDefaultGraph());
    }

    public Lock getLock() {
        return this.g.getLock();
    }

    public Model getNamedModel(String arg0) {
        Model model = RDFServiceGraph.createRDFServiceModel(this.g.getGraph(NodeFactory.createURI((String)arg0)));
        return model;
    }

    public Iterator<String> listNames() {
        ArrayList<String> nameList = new ArrayList<String>();
        Iterator<Node> nodeIt = this.g.listGraphNodes();
        while (nodeIt.hasNext()) {
            Node n = nodeIt.next();
            nameList.add(n.getURI());
        }
        return nameList.iterator();
    }

    public void addNamedModel(String uri, Model model) throws LabelExistsException {
        Iterator<Node> graphNodes = this.g.listGraphNodes();
        while (graphNodes.hasNext()) {
            Node graphNode = graphNodes.next();
            if (!graphNode.hasURI(uri)) continue;
            throw new LabelExistsException("Can't add named model '" + uri + "': model already exists");
        }
        this.g.addGraph(NodeFactory.createURI((String)uri), model.getGraph());
    }

    public Context getContext() {
        return this.g.getContext();
    }

    public void removeNamedModel(String uri) {
        this.g.removeGraph(NodeFactory.createURI((String)uri));
    }

    public void replaceNamedModel(String uri, Model model) {
        this.removeNamedModel(uri);
        this.addNamedModel(uri, model);
    }

    public void setDefaultModel(Model model) {
        this.g.setDefaultGraph(model.getGraph());
    }

    public boolean supportsTransactions() {
        if (this.g.getDefaultGraph().getTransactionHandler() == null) {
            return false;
        }
        return this.g.getDefaultGraph().getTransactionHandler().transactionsSupported();
    }

    public boolean isInTransaction() {
        return this.transactionMode != null;
    }

    private boolean supportsTransactions(Graph graph) {
        return graph.getTransactionHandler() != null && graph.getTransactionHandler().transactionsSupported();
    }

    public void begin(ReadWrite arg0) {
        this.transactionMode = arg0;
        this.g.begin(arg0);
        for (String graphURI : this.g.getGraphCache().keySet()) {
            Graph graph = (Graph)this.g.getGraphCache().get(graphURI);
            if (!this.supportsTransactions(graph)) continue;
            graph.getTransactionHandler().begin();
        }
    }

    public void commit() {
        for (String graphURI : this.g.getGraphCache().keySet()) {
            Graph graph = (Graph)this.g.getGraphCache().get(graphURI);
            if (!this.supportsTransactions(graph)) continue;
            graph.getTransactionHandler().commit();
        }
    }

    public void abort() {
        for (String graphURI : this.g.getGraphCache().keySet()) {
            Graph graph = (Graph)this.g.getGraphCache().get(graphURI);
            if (!this.supportsTransactions(graph)) continue;
            graph.getTransactionHandler().abort();
        }
    }

    public void end() {
        this.transactionMode = null;
        this.g.end();
    }

    public String toString() {
        return "RDFServiceDataset[" + ToString.hashHex(this) + ", " + this.g + "]";
    }
}

