/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.dao.jena.GraphGenerator;
import edu.cornell.mannlib.vitro.webapp.dao.jena.Regenerable;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegeneratingGraph
implements Graph,
Regenerable {
    private static final Log log = LogFactory.getLog(RegeneratingGraph.class);
    private GraphGenerator generator;
    private Graph g;

    public RegeneratingGraph(GraphGenerator graphGenerator) {
        this.generator = graphGenerator;
        this.regenerate();
    }

    public RegeneratingGraph(Graph initGraph, GraphGenerator graphGenerator) {
        this.g = initGraph;
        this.generator = graphGenerator;
    }

    @Override
    public void regenerate() {
        this.g = this.generator.generateGraph();
    }

    private void sendTestQuery() {
        this.g.contains(DCTerms.Agent.asNode(), RDF.type.asNode(), DCTerms.Agent.asNode());
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        try {
            this.g.close();
        }
        catch (Exception e) {
            this.regenerate();
            this.g.close();
        }
    }

    public boolean contains(Triple arg0) {
        try {
            this.regenerateIfClosed();
            return this.g.contains(arg0);
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.contains(arg0);
        }
    }

    public boolean contains(Node arg0, Node arg1, Node arg2) {
        try {
            this.regenerateIfClosed();
            return this.g.contains(arg0, arg1, arg2);
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.contains(arg0, arg1, arg2);
        }
    }

    public void delete(Triple arg0) throws DeleteDeniedException {
        try {
            this.regenerateIfClosed();
            this.g.delete(arg0);
        }
        catch (Exception e) {
            this.regenerate();
            this.g.delete(arg0);
        }
    }

    public boolean dependsOn(Graph arg0) {
        try {
            this.regenerateIfClosed();
            return this.g.dependsOn(arg0);
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.dependsOn(arg0);
        }
    }

    public ExtendedIterator<Triple> find(TripleMatch arg0) {
        try {
            this.regenerateIfClosed();
            return this.g.find(arg0);
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.find(arg0);
        }
    }

    public ExtendedIterator<Triple> find(Node arg0, Node arg1, Node arg2) {
        try {
            this.regenerateIfClosed();
            return this.g.find(arg0, arg1, arg2);
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.find(arg0, arg1, arg2);
        }
    }

    @Deprecated
    public BulkUpdateHandler getBulkUpdateHandler() {
        try {
            this.regenerateIfClosed();
            this.sendTestQuery();
            return this.g.getBulkUpdateHandler();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.getBulkUpdateHandler();
        }
    }

    public Capabilities getCapabilities() {
        try {
            this.regenerateIfClosed();
            this.sendTestQuery();
            return this.g.getCapabilities();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.getCapabilities();
        }
    }

    public GraphEventManager getEventManager() {
        try {
            this.regenerateIfClosed();
            this.sendTestQuery();
            return this.g.getEventManager();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.getEventManager();
        }
    }

    public PrefixMapping getPrefixMapping() {
        try {
            this.regenerateIfClosed();
            this.sendTestQuery();
            return this.g.getPrefixMapping();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.getPrefixMapping();
        }
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        try {
            this.regenerateIfClosed();
            this.sendTestQuery();
            return this.g.getStatisticsHandler();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.getStatisticsHandler();
        }
    }

    public TransactionHandler getTransactionHandler() {
        try {
            this.regenerateIfClosed();
            this.sendTestQuery();
            return this.g.getTransactionHandler();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.getTransactionHandler();
        }
    }

    public boolean isClosed() {
        try {
            this.regenerateIfClosed();
            return this.g.isClosed();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.isClosed();
        }
    }

    public boolean isEmpty() {
        try {
            this.regenerateIfClosed();
            return this.g.isEmpty();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.isEmpty();
        }
    }

    public boolean isIsomorphicWith(Graph arg0) {
        try {
            this.regenerateIfClosed();
            return this.g.isIsomorphicWith(arg0);
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.isIsomorphicWith(arg0);
        }
    }

    public int size() {
        try {
            this.regenerateIfClosed();
            return this.g.size();
        }
        catch (Exception e) {
            this.regenerate();
            return this.g.size();
        }
    }

    public void add(Triple arg0) throws AddDeniedException {
        try {
            this.regenerateIfClosed();
            this.g.add(arg0);
        }
        catch (Exception e) {
            this.regenerate();
            this.g.add(arg0);
        }
    }

    public void clear() {
        try {
            this.regenerateIfClosed();
            this.g.clear();
        }
        catch (Exception e) {
            this.regenerate();
            this.g.clear();
        }
    }

    public void remove(Node arg0, Node arg1, Node arg2) {
        try {
            this.regenerateIfClosed();
            this.g.remove(arg0, arg1, arg2);
        }
        catch (Exception e) {
            this.regenerate();
            this.g.remove(arg0, arg1, arg2);
        }
    }

    private void regenerateIfClosed() {
        if (this.generator.isGraphClosed()) {
            this.regenerate();
        }
    }

    public String toString() {
        return "RegeneratingGraph[" + ToString.hashHex(this) + ", " + ToString.graphToString(this.g) + "]";
    }
}

