/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SparqlGraph;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SparqlGraphBulkUpdater
extends SimpleBulkUpdateHandler {
    private static final Log log = LogFactory.getLog(SparqlGraphBulkUpdater.class);
    private SparqlGraph graph;

    public SparqlGraphBulkUpdater(SparqlGraph graph) {
        super((GraphWithPerform)graph);
        this.graph = graph;
    }

    @Deprecated
    public void add(Triple[] arg0) {
        Graph g = GraphFactory.createPlainGraph();
        for (int i = 0; i < arg0.length; ++i) {
            g.add(arg0[i]);
        }
        this.add(g);
    }

    @Deprecated
    public void add(List<Triple> arg0) {
        Graph g = GraphFactory.createPlainGraph();
        for (Triple t : arg0) {
            g.add(t);
        }
        this.add(g);
    }

    @Deprecated
    public void add(Iterator<Triple> arg0) {
        Graph g = GraphFactory.createPlainGraph();
        while (arg0.hasNext()) {
            Triple t = arg0.next();
            g.add(t);
        }
        this.add(g);
    }

    @Deprecated
    public void add(Graph arg0) {
        this.add(arg0, false);
    }

    @Deprecated
    public void add(Graph g, boolean arg1) {
        log.info((Object)"adding graph");
        Model[] model = this.separateStatementsWithBlankNodes(g);
        this.addModel(model[1]);
        this.addModel(model[0]);
    }

    private Model[] separateStatementsWithBlankNodes(Graph g) {
        Model gm = ModelFactory.createModelForGraph((Graph)g);
        Model blankNodeModel = ModelFactory.createDefaultModel();
        Model nonBlankNodeModel = ModelFactory.createDefaultModel();
        StmtIterator sit = gm.listStatements();
        while (sit.hasNext()) {
            Statement stmt = sit.nextStatement();
            if (!stmt.getSubject().isAnon() && !stmt.getObject().isAnon()) {
                nonBlankNodeModel.add(stmt);
                continue;
            }
            blankNodeModel.add(stmt);
        }
        Model[] result = new Model[]{blankNodeModel, nonBlankNodeModel};
        return result;
    }

    @Deprecated
    public void delete(Graph g, boolean withReifications) {
        this.delete(g);
    }

    @Deprecated
    public void delete(Graph g) {
        Model[] model = this.separateStatementsWithBlankNodes(g);
        this.deleteModel(model[1]);
        StringBuffer patternBuff = new StringBuffer();
        ExtendedIterator tripIt = g.find(null, null, null);
        while (tripIt.hasNext()) {
            Triple t = (Triple)tripIt.next();
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getSubject(), null));
            patternBuff.append(" ");
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getPredicate(), null));
            patternBuff.append(" ");
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getObject(), null));
            patternBuff.append(" .\n");
        }
        StringBuffer queryBuff = new StringBuffer();
        String graphURI = this.graph.getGraphURI();
        queryBuff.append("DELETE { " + (graphURI != null ? "GRAPH <" + graphURI + "> { " : "") + " \n");
        queryBuff.append(patternBuff);
        if (graphURI != null) {
            queryBuff.append("    } \n");
        }
        queryBuff.append("} WHERE { \n");
        if (graphURI != null) {
            queryBuff.append("    GRAPH <" + graphURI + "> { \n");
        }
        queryBuff.append(patternBuff);
        if (graphURI != null) {
            queryBuff.append("    } \n");
        }
        queryBuff.append("} \n");
        log.debug((Object)queryBuff.toString());
        this.graph.executeUpdate(queryBuff.toString());
    }

    public void addModel(Model model) {
        this.verbModel(model, "INSERT");
    }

    public void deleteModel(Model model) {
        this.verbModel(model, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verbModel(Model model, String verb) {
        Model m = ModelFactory.createDefaultModel();
        int testLimit = 1000;
        int count = 0;
        try (StmtIterator stmtIt = model.listStatements();){
            while (stmtIt.hasNext()) {
                m.add(stmtIt.nextStatement());
                if (++count % testLimit != 0 && stmtIt.hasNext()) continue;
                StringWriter sw = new StringWriter();
                m.write((Writer)sw, "N-TRIPLE");
                StringBuffer updateStringBuff = new StringBuffer();
                String graphURI = this.graph.getGraphURI();
                updateStringBuff.append(verb + " DATA { " + (graphURI != null ? "GRAPH <" + graphURI + "> { " : ""));
                updateStringBuff.append(sw);
                updateStringBuff.append((graphURI != null ? " } " : "") + " }");
                String updateString = updateStringBuff.toString();
                this.graph.executeUpdate(updateString);
                m.removeAll();
            }
        }
    }

    @Deprecated
    public void removeAll() {
        SparqlGraphBulkUpdater.removeAll((Graph)this.graph);
        this.notifyRemoveAll();
    }

    @Deprecated
    protected void notifyRemoveAll() {
        this.manager.notifyEvent((Graph)this.graph, (Object)GraphEvents.removeAll);
    }

    @Deprecated
    public void remove(Node s, Node p, Node o) {
        SparqlGraphBulkUpdater.removeAll((Graph)this.graph, s, p, o);
        this.manager.notifyEvent((Graph)this.graph, (Object)GraphEvents.remove((Node)s, (Node)p, (Node)o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph g, Node s, Node p, Node o) {
        try (ExtendedIterator it = g.find(s, p, o);){
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                g.delete(t);
                it.remove();
            }
        }
    }

    public static void removeAll(Graph g) {
        try (ExtendedIterator it = GraphUtil.findAll((Graph)g);){
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                g.delete(t);
                it.remove();
            }
        }
        if (g instanceof SparqlGraph) {
            ((SparqlGraph)g).removeAll();
        }
    }
}

