/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactorySDB;
import java.util.Collections;

public class VClassDaoSDB
extends VClassDaoJena {
    private DatasetWrapperFactory dwf;
    private WebappDaoFactorySDB.SDBDatasetMode datasetMode;

    public VClassDaoSDB(DatasetWrapperFactory datasetWrapperFactory, WebappDaoFactorySDB.SDBDatasetMode datasetMode, WebappDaoFactoryJena wadf, boolean isUnderlyingStoreReasoned) {
        super(wadf, isUnderlyingStoreReasoned);
        this.dwf = datasetWrapperFactory;
        this.datasetMode = datasetMode;
    }

    protected DatasetWrapper getDatasetWrapper() {
        return this.dwf.getDatasetWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public void addVClassesToGroup(VClassGroup group, boolean includeUninstantiatedClasses, boolean getIndividualCount) {
        if (getIndividualCount) {
            group.setIndividualCount(this.getClassGroupInstanceCount(group));
        }
        this.getOntModel().enterCriticalSection(true);
        try {
            if (group != null && group.getURI() != null) {
                Resource groupRes = ResourceFactory.createResource((String)group.getURI());
                Property inClassGroup = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup");
                if (inClassGroup != null) {
                    try (StmtIterator annotIt = this.getOntModel().listStatements((Resource)null, inClassGroup, (RDFNode)groupRes);){
                        while (annotIt.hasNext()) {
                            try {
                                Statement annot = (Statement)annotIt.next();
                                Resource cls = annot.getSubject();
                                VClass vcw = this.getVClassByURI(cls.getURI());
                                if (vcw == null) continue;
                                boolean classIsInstantiated = false;
                                if (getIndividualCount) {
                                    int count = 0;
                                    String[] graphVars = new String[]{"?g"};
                                    String countQueryStr = "SELECT COUNT(DISTINCT ?s) WHERE \n{ GRAPH ?g { ?s a <" + cls.getURI() + "> } \n" + WebappDaoFactorySDB.getFilterBlock(graphVars, this.datasetMode) + "} \n";
                                    Query countQuery = QueryFactory.create((String)countQueryStr, (Syntax)Syntax.syntaxARQ);
                                    DatasetWrapper w = this.getDatasetWrapper();
                                    Dataset dataset = w.getDataset();
                                    dataset.getLock().enterCriticalSection(true);
                                    try {
                                        QueryExecution qe = QueryExecutionFactory.create((Query)countQuery, (Dataset)dataset);
                                        ResultSet rs = qe.execSelect();
                                        count = Integer.parseInt(((Literal)rs.nextSolution().get(".1")).getLexicalForm());
                                    }
                                    finally {
                                        dataset.getLock().leaveCriticalSection();
                                        w.close();
                                    }
                                    vcw.setEntityCount(count);
                                    classIsInstantiated = count > 0;
                                } else if (!includeUninstantiatedClasses) {
                                    OntModel aboxModel = this.getOntModelSelector().getABoxModel();
                                    aboxModel.enterCriticalSection(true);
                                    try (StmtIterator countIt = aboxModel.listStatements(null, RDF.type, (RDFNode)cls);){
                                        if (countIt.hasNext()) {
                                            classIsInstantiated = true;
                                        }
                                    }
                                    finally {
                                        aboxModel.leaveCriticalSection();
                                    }
                                }
                                if (!includeUninstantiatedClasses && !classIsInstantiated) continue;
                                group.add(vcw);
                            }
                            catch (ClassCastException cce) {
                                log.error((Object)cce, (Throwable)cce);
                            }
                        }
                    }
                }
            }
            Collections.sort(group.getVitroClassList());
            return;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getClassGroupInstanceCount(VClassGroup vcg) {
        int count = 0;
        try {
            String queryText = "SELECT COUNT( DISTINCT ?instance ) WHERE { \n      ?class <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup> <" + vcg.getURI() + "> .\n" + "      ?instance a ?class .  \n" + "} \n";
            Query countQuery = QueryFactory.create((String)queryText, (Syntax)Syntax.syntaxARQ);
            DatasetWrapper w = this.getDatasetWrapper();
            Dataset dataset = w.getDataset();
            dataset.getLock().enterCriticalSection(true);
            try {
                QueryExecution qe = QueryExecutionFactory.create((Query)countQuery, (Dataset)dataset);
                ResultSet rs = qe.execSelect();
                count = Integer.parseInt(((Literal)rs.nextSolution().get(".1")).getLexicalForm());
            }
            finally {
                dataset.getLock().leaveCriticalSection();
                w.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)"error in getClassGroupInstanceCount()", (Throwable)ex);
        }
        return count;
    }
}

