/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.WebappDaoFactoryFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilterUtils;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import edu.cornell.mannlib.vitro.webapp.dao.jena.ModelContext;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.BulkUpdateEvent;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchFacetField;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VClassGroupCache
implements SearchIndexer.Listener {
    private static final Log log = LogFactory.getLog(VClassGroupCache.class);
    private static final String ATTRIBUTE_NAME = "VClassGroupCache";
    private static final boolean ORDER_BY_DISPLAYRANK = true;
    private static final boolean INCLUDE_UNINSTANTIATED = true;
    private static final boolean DONT_INCLUDE_INDIVIDUAL_COUNT = false;
    private List<VClassGroup> _groupList;
    private Map<String, VClass> VclassMap = new HashMap<String, VClass>();
    private final RebuildGroupCacheThread _cacheRebuildThread;
    private final ServletContext context;
    private boolean paused = false;
    private boolean updateRequested = false;

    private VClassGroupCache(ServletContext context) {
        this.context = context;
        this._groupList = null;
        if (StartupStatus.getBean(context).isStartupAborted()) {
            this._cacheRebuildThread = null;
            return;
        }
        VClassGroupCacheChangeListener bccl = new VClassGroupCacheChangeListener();
        ModelContext.registerListenerForChanges(context, (ModelChangedListener)bccl);
        this._cacheRebuildThread = new RebuildGroupCacheThread(this);
        this._cacheRebuildThread.setDaemon(true);
        this._cacheRebuildThread.start();
    }

    public synchronized VClassGroup getGroup(String vClassGroupURI) {
        if (vClassGroupURI == null || vClassGroupURI.isEmpty()) {
            return null;
        }
        List<VClassGroup> cgList = this.getGroups();
        for (VClassGroup cg : cgList) {
            if (!vClassGroupURI.equals(cg.getURI())) continue;
            return cg;
        }
        return null;
    }

    public synchronized List<VClassGroup> getGroups() {
        if (this._groupList == null) {
            this.doSynchronousRebuild();
        }
        if (this._groupList == null) {
            this.requestCacheUpdate();
            return Collections.emptyList();
        }
        return this._groupList;
    }

    public synchronized VClass getCachedVClass(String classUri) {
        if (this.VclassMap == null) {
            this.doSynchronousRebuild();
        }
        if (this.VclassMap == null) {
            this.requestCacheUpdate();
            return null;
        }
        if (this.VclassMap.containsKey(classUri)) {
            return this.VclassMap.get(classUri);
        }
        return null;
    }

    protected synchronized void setCache(List<VClassGroup> newGroups, Map<String, VClass> classMap) {
        this._groupList = newGroups;
        this.VclassMap = classMap;
    }

    public void pause() {
        this.paused = true;
    }

    public void unpause() {
        this.paused = false;
        if (this.updateRequested) {
            this.updateRequested = false;
            this.requestCacheUpdate();
        }
    }

    public void requestCacheUpdate() {
        log.debug((Object)"requesting update");
        if (this.paused) {
            this.updateRequested = true;
        } else {
            this._cacheRebuildThread.informOfQueueChange();
        }
    }

    protected void requestStop() {
        if (this._cacheRebuildThread != null) {
            this._cacheRebuildThread.kill();
            try {
                this._cacheRebuildThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected VClassGroupDao getVCGDao() {
        return ModelAccess.on(this.context).getWebappDaoFactory().getVClassGroupDao();
    }

    public void doSynchronousRebuild() {
        int attempts = 0;
        int maxTries = 5;
        SearchEngineException exception = null;
        while (attempts < maxTries) {
            try {
                ++attempts;
                VClassGroupCache.rebuildCacheUsingSearch(this);
                break;
            }
            catch (SearchEngineException e) {
                exception = e;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exception != null) {
            log.error((Object)("Could not rebuild cache. " + exception.getCause().getMessage()));
        }
    }

    @Override
    public void receiveSearchIndexerEvent(SearchIndexer.Event event) {
        switch (event.getType()) {
            case STOP_URIS: {
                log.debug((Object)("rebuilding because of IndexBuilder " + (Object)((Object)event.getType())));
                this.requestCacheUpdate();
                break;
            }
            default: {
                log.debug((Object)("ignoring event type " + (Object)((Object)event.getType())));
            }
        }
    }

    public static VClassGroupCache getVClassGroupCache(ServletContext sc) {
        return (VClassGroupCache)sc.getAttribute(ATTRIBUTE_NAME);
    }

    public static VClassGroupsForRequest getVClassGroups(HttpServletRequest req) {
        return new VClassGroupsForRequest(req, VClassGroupCache.getVClassGroupCache(req.getSession().getServletContext()));
    }

    protected static void rebuildCacheUsingSearch(VClassGroupCache cache) throws SearchEngineException {
        long start = System.currentTimeMillis();
        WebappDaoFactory wdFactory = ModelAccess.on(cache.context).getWebappDaoFactory();
        SearchEngine searchEngine = ApplicationUtils.instance().getSearchEngine();
        VitroFilters vFilters = VitroFilterUtils.getPublicFilter(cache.context);
        VClassGroupDao vcgDao = new WebappDaoFactoryFiltering(wdFactory, vFilters).getVClassGroupDao();
        List<VClassGroup> groups = vcgDao.getPublicGroupsWithVClasses(true, true, false);
        VClassGroupCache.addCountsUsingSearch(groups, searchEngine);
        cache.setCache(groups, VClassGroupCache.classMapForGroups(groups));
        log.debug((Object)("msec to build cache: " + (System.currentTimeMillis() - start)));
    }

    protected static Map<String, VClass> classMapForGroups(List<VClassGroup> groups) {
        HashMap<String, VClass> newClassMap = new HashMap<String, VClass>();
        for (VClassGroup vcg : groups) {
            List<VClass> vclasses = vcg.getVitroClassList();
            for (VClass vclass : vclasses) {
                String classUri = vclass.getURI();
                if (newClassMap.containsKey(classUri)) continue;
                newClassMap.put(classUri, vclass);
            }
        }
        return newClassMap;
    }

    protected static void addCountsUsingSearch(List<VClassGroup> groups, SearchEngine searchEngine) throws SearchEngineException {
        if (groups == null || searchEngine == null) {
            return;
        }
        for (VClassGroup group : groups) {
            VClassGroupCache.addClassCountsToGroup(group, searchEngine);
        }
    }

    protected static void addClassCountsToGroup(VClassGroup group, SearchEngine searchEngine) throws SearchEngineException {
        if (group == null) {
            return;
        }
        String groupUri = group.getURI();
        String facetOnField = "type";
        SearchQuery query = searchEngine.createQuery().setRows(0).setQuery("classgroup:" + groupUri).addFacetFields(facetOnField).setFacetMinCount(0);
        log.debug((Object)("query: " + query));
        SearchResponse rsp = searchEngine.query(query);
        long individualCount = rsp.getResults().getNumFound();
        log.debug((Object)("Number of individuals found " + individualCount));
        group.setIndividualCount((int)individualCount);
        SearchFacetField ff = rsp.getFacetField(facetOnField);
        if (ff != null) {
            List<SearchFacetField.Count> counts = ff.getValues();
            if (counts != null) {
                for (SearchFacetField.Count ct : counts) {
                    if (ct == null) continue;
                    String classUri = ct.getName();
                    long individualsInClass = ct.getCount();
                    VClassGroupCache.setClassCount(group, classUri, individualsInClass);
                }
            } else {
                log.debug((Object)("no Counts found for FacetField " + facetOnField));
            }
        } else {
            log.debug((Object)("no FaccetField found for " + facetOnField));
        }
    }

    protected static void setClassCount(VClassGroup group, String classUri, long individualsInClass) {
        for (VClass clz : group) {
            if (!clz.getURI().equals(classUri)) continue;
            clz.setEntityCount((int)individualsInClass);
        }
    }

    protected static boolean isClassNameChange(Statement stmt, OntModel jenaOntModel) {
        if (RDFS.label.equals(stmt.getPredicate())) {
            jenaOntModel.enterCriticalSection(true);
            try {
                boolean bl = jenaOntModel.contains(ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)stmt.getSubject().getURI()), (Property)RDF.type, (RDFNode)OWL.Class));
                return bl;
            }
            finally {
                jenaOntModel.leaveCriticalSection();
            }
        }
        return false;
    }

    public static class Setup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext context = sce.getServletContext();
            VClassGroupCache vcgc = new VClassGroupCache(context);
            vcgc.requestCacheUpdate();
            context.setAttribute(VClassGroupCache.ATTRIBUTE_NAME, (Object)vcgc);
            log.info((Object)"VClassGroupCache added to context");
            SearchIndexer searchIndexer = ApplicationUtils.instance().getSearchIndexer();
            searchIndexer.addListener(vcgc);
            log.info((Object)"VClassGroupCache set to listen to events from IndexBuilder");
        }

        public void contextDestroyed(ServletContextEvent sce) {
            Object o = sce.getServletContext().getAttribute(VClassGroupCache.ATTRIBUTE_NAME);
            if (o instanceof VClassGroupCache) {
                ((VClassGroupCache)o).requestStop();
            }
        }
    }

    protected class VClassGroupCacheChangeListener
    extends StatementListener {
        protected VClassGroupCacheChangeListener() {
        }

        public void addedStatement(Statement stmt) {
            this.checkAndDoUpdate(stmt);
        }

        public void removedStatement(Statement stmt) {
            this.checkAndDoUpdate(stmt);
        }

        protected void checkAndDoUpdate(Statement stmt) {
            OntModel jenaOntModel;
            if (stmt == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("subject: " + stmt.getSubject().getURI()));
                log.debug((Object)("predicate: " + stmt.getPredicate().getURI()));
            }
            if (RDF.type.equals(stmt.getPredicate())) {
                VClassGroupCache.this.requestCacheUpdate();
            } else if ("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup".equals(stmt.getPredicate().getURI())) {
                VClassGroupCache.this.requestCacheUpdate();
            } else if ("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayRank".equals(stmt.getPredicate().getURI())) {
                VClassGroupCache.this.requestCacheUpdate();
            } else if (RDFS.label.equals(stmt.getPredicate()) && VClassGroupCache.isClassNameChange(stmt, jenaOntModel = ModelAccess.on(VClassGroupCache.this.context).getOntModelSelector().getTBoxModel())) {
                VClassGroupCache.this.requestCacheUpdate();
            }
        }

        public void notifyEvent(Model model, Object event) {
            if (event instanceof BulkUpdateEvent) {
                if (((BulkUpdateEvent)event).getBegin().booleanValue()) {
                    VClassGroupCache.this.pause();
                } else {
                    VClassGroupCache.this.unpause();
                }
            }
        }
    }

    protected class RebuildGroupCacheThread
    extends VitroBackgroundThread {
        private final VClassGroupCache cache;
        private long queueChangeMillis;
        private boolean rebuildRequested;
        private volatile boolean die;
        private int failedAttempts;
        private final int maxFailedAttempts = 5;

        RebuildGroupCacheThread(VClassGroupCache cache) {
            super("VClassGroupCache.RebuildGroupCacheThread");
            this.queueChangeMillis = 0L;
            this.rebuildRequested = false;
            this.die = false;
            this.failedAttempts = 0;
            this.maxFailedAttempts = 5;
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.die) {
                int delay;
                if (!this.rebuildRequested) {
                    log.debug((Object)"rebuildGroupCacheThread.run() -- nothing to do, sleep");
                    delay = 60000;
                } else if (System.currentTimeMillis() - this.queueChangeMillis < 500L) {
                    log.debug((Object)"rebuildGroupCacheThread.run() -- delay start of rebuild");
                    delay = 500;
                } else {
                    this.setWorkLevel(VitroBackgroundThread.WorkLevel.WORKING, new String[0]);
                    this.rebuildRequested = false;
                    try {
                        VClassGroupCache.rebuildCacheUsingSearch(this.cache);
                        log.debug((Object)"rebuildGroupCacheThread.run() -- rebuilt cache ");
                        this.failedAttempts = 0;
                        delay = 100;
                    }
                    catch (SearchEngineException e) {
                        ++this.failedAttempts;
                        if (this.failedAttempts >= 5) {
                            log.error((Object)("Could not build VClassGroupCache. Could not connect with the search engine after " + this.failedAttempts + " attempts."), e.getCause());
                            this.rebuildRequested = false;
                            this.failedAttempts = 0;
                            delay = 1000;
                        } else {
                            this.rebuildRequested = true;
                            delay = (int)(Math.pow(2.0, this.failedAttempts) * 1000.0);
                            log.debug((Object)("Could not connect with the search engine, will attempt again in " + delay + " msec."));
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)"could not build cache", (Throwable)ex);
                        delay = 1000;
                    }
                    this.setWorkLevel(VitroBackgroundThread.WorkLevel.IDLE, new String[0]);
                }
                if (delay <= 0) continue;
                RebuildGroupCacheThread rebuildGroupCacheThread = this;
                synchronized (rebuildGroupCacheThread) {
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)("Waiting " + delay + " milliseconds, but interrupted."), (Throwable)e);
                    }
                }
            }
            log.debug((Object)"rebuildGroupCacheThread.run() -- die()");
        }

        synchronized void informOfQueueChange() {
            this.queueChangeMillis = System.currentTimeMillis();
            this.rebuildRequested = true;
            this.notifyAll();
        }

        synchronized void kill() {
            this.die = true;
            this.notifyAll();
        }
    }
}

