/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dwr;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;

public class EntityDWR {
    IndividualDao entityWADao;

    public EntityDWR() {
        WebContext ctx = WebContextFactory.get();
        ServletContext sc = ctx.getServletContext();
        this.entityWADao = ModelAccess.on(sc).getWebappDaoFactory().getIndividualDao();
    }

    public String insertNewEntity(Individual ent) {
        try {
            return this.entityWADao.insertNewIndividual(ent);
        }
        catch (InsertException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Individual entityByURI(String entityURI) {
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        Individual ind = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(entityURI);
        return ind;
    }

    public Collection getEntitiesByVClass(String vclassURI) {
        VClass vc = new VClass(vclassURI);
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest req = ctx.getHttpServletRequest();
        VitroRequest vreq = new VitroRequest(req);
        IndividualDao entityWADao = vreq.getWebappDaoFactory().getIndividualDao();
        return entityWADao.getIndividualsByVClass(vc);
    }
}

