/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProfile;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.IsUser;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.AdditionsAndRetractions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditN3GeneratorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.RdfLiteralHash;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ModelChangePreprocessor;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.XMLChar;

public class N3EditUtils {
    static final Log log = LogFactory.getLog(N3EditUtils.class);

    public static void preprocessModels(AdditionsAndRetractions changes, EditConfigurationVTwo editConfiguration, VitroRequest request) {
        List<ModelChangePreprocessor> modelChangePreprocessors = editConfiguration.getModelChangePreprocessors();
        List<ModelChangePreprocessor> defaultPreprocessors = N3EditUtils.getDefaultModelChangePreprocessors(request, (Model)ModelAccess.on((HttpServletRequest)request).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata", new ModelAccess.LanguageOption[0]));
        if (modelChangePreprocessors != null) {
            modelChangePreprocessors.addAll(defaultPreprocessors);
        } else {
            modelChangePreprocessors = defaultPreprocessors;
        }
        if (modelChangePreprocessors != null) {
            for (ModelChangePreprocessor pp : modelChangePreprocessors) {
                pp.preprocess(changes.getRetractions(), changes.getAdditions(), (HttpServletRequest)request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ModelChangePreprocessor> getDefaultModelChangePreprocessors(VitroRequest vreq, Model displayModel) {
        ArrayList<ModelChangePreprocessor> preprocessors = new ArrayList<ModelChangePreprocessor>();
        String preprocessorOwlClass = "java:edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ModelChangePreprocessor";
        String prefixes = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n";
        String query = prefixes + "SELECT ?modelChangePreprocessor  WHERE { ?modelChangePreprocessor a <" + preprocessorOwlClass + "> . }";
        Query preprocessorQuery = QueryFactory.create((String)query);
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)preprocessorQuery, (Model)displayModel);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                Resource modelChangePreprocessor = soln.getResource("modelChangePreprocessor");
                if (modelChangePreprocessor == null || modelChangePreprocessor.getURI() == null) continue;
                String preprocessorClass = modelChangePreprocessor.getURI();
                try {
                    ModelChangePreprocessor p = N3EditUtils.preprocessorForURI(vreq, displayModel, preprocessorClass);
                    if (p == null) continue;
                    preprocessors.add(p);
                }
                catch (Exception ex) {
                    log.error((Object)"Retrieving model change preprocessor resulted in an error", (Throwable)ex);
                }
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        return preprocessors;
    }

    public static ModelChangePreprocessor preprocessorForURI(VitroRequest vreq, Model displayModel, String preprocessorURI) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, SecurityException {
        String preprocessorClassName = DataGetterUtils.getClassNameFromUri(preprocessorURI);
        Class<?> clz = Class.forName(preprocessorClassName);
        if (!ModelChangePreprocessor.class.isAssignableFrom(clz)) {
            log.debug((Object)("Class doesn't implement ModelChangePreprocessor: '" + preprocessorClassName + "'"));
            return null;
        }
        return (ModelChangePreprocessor)clz.newInstance();
    }

    public static String processEntityToReturnTo(EditConfigurationVTwo configuration, MultiValueEditSubmission submission, VitroRequest vreq) {
        String returnTo = null;
        if (submission != null && submission.getEntityToReturnTo() != null && !submission.getEntityToReturnTo().trim().isEmpty()) {
            returnTo = submission.getEntityToReturnTo();
        } else {
            ArrayList<String> entityToReturnTo = new ArrayList<String>();
            String entity = configuration.getEntityToReturnTo();
            entityToReturnTo.add(entity);
            EditN3GeneratorVTwo n3Subber = configuration.getN3Generator();
            n3Subber.subInMultiUris(submission.getUrisFromForm(), entityToReturnTo);
            n3Subber.subInMultiLiterals(submission.getLiteralsFromForm(), entityToReturnTo);
            returnTo = (String)entityToReturnTo.get(0);
        }
        if (returnTo != null) {
            returnTo = returnTo.trim().replaceAll("<", "").replaceAll(">", "");
        }
        return returnTo;
    }

    public static void updateEditConfigurationForBackButton(EditConfigurationVTwo editConfig, MultiValueEditSubmission submission, VitroRequest vreq, Model writeModel) {
        if (EditConfigurationUtils.isDataProperty(editConfig.getPredicateUri(), vreq)) {
            EditConfigurationVTwo copy = editConfig.copy();
            DataPropertyStatementImpl dps = new DataPropertyStatementImpl();
            List<Literal> submitted = submission.getLiteralsFromForm().get(copy.getVarNameForObject());
            if (submitted != null && submitted.size() > 0) {
                for (Literal submittedLiteral : submitted) {
                    dps.setIndividualURI(copy.getSubjectUri());
                    dps.setDatapropURI(copy.getPredicateUri());
                    dps.setDatatypeURI(submittedLiteral.getDatatypeURI());
                    dps.setLanguage(submittedLiteral.getLanguage());
                    dps.setData(submittedLiteral.getLexicalForm());
                    copy.setDatapropKey(RdfLiteralHash.makeRdfLiteralHash(dps));
                    copy.prepareForDataPropUpdate(writeModel, vreq.getWebappDaoFactory().getDataPropertyDao());
                }
                EditConfigurationVTwo.putConfigInSession(copy, vreq.getSession());
            }
        }
    }

    public static String getEditorUri(HttpServletRequest request) {
        IdentifierBundle ids = RequestIdentifiers.getIdBundleForRequest((ServletRequest)request);
        ArrayList<String> uris = new ArrayList<String>();
        uris.addAll(IsUser.getUserUris(ids));
        uris.addAll(HasProfile.getProfileUris(ids));
        uris.add("Unknown N3 Editor");
        return (String)uris.get(0);
    }

    public static String stripInvalidXMLChars(String in) {
        if (in == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (XMLChar.isInvalid((int)c)) continue;
            out.append(c);
        }
        return out.toString();
    }
}

