/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.IndividualsViaObjectPropetyOptions;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualsViaObjectPropertyByRankOptions
extends IndividualsViaObjectPropetyOptions {
    static final Log log = LogFactory.getLog(IndividualsViaObjectPropertyByRankOptions.class);
    private WebappDaoFactory wdf = null;
    private Model queryModel = null;

    public IndividualsViaObjectPropertyByRankOptions(String subjectUri, String predicateUri, String objectUri, WebappDaoFactory wdf, Model model) throws Exception {
        super(subjectUri, predicateUri, objectUri);
        this.wdf = wdf;
        this.queryModel = model;
    }

    @Override
    public Comparator<String[]> getCustomComparator() {
        return new DisplayRankComparator(this.wdf, this.queryModel);
    }

    private static class DisplayRankComparator
    implements Comparator<String[]> {
        private WebappDaoFactory wdf = null;
        private Model queryModel = null;

        public DisplayRankComparator(WebappDaoFactory wdf, Model model) {
            this.wdf = wdf;
            this.queryModel = model;
        }

        @Override
        public int compare(String[] s1, String[] s2) {
            if (s2 == null) {
                return 1;
            }
            if (s1 == null) {
                return -1;
            }
            if ("".equals(s1[0])) {
                return -1;
            }
            if ("".equals(s2[0])) {
                return 1;
            }
            if (s2[1] == null) {
                return 1;
            }
            if (s1[1] == null) {
                return -1;
            }
            return this.compareRanks(s1, s2);
        }

        private int compareRanks(String[] s1, String[] s2) {
            int displayRank2;
            String uri1 = s1[0];
            String uri2 = s2[0];
            Individual ind1 = this.wdf.getIndividualDao().getIndividualByURI(uri1);
            Individual ind2 = this.wdf.getIndividualDao().getIndividualByURI(uri2);
            int displayRank1 = this.getDisplayRank(ind1);
            return displayRank1 > (displayRank2 = this.getDisplayRank(ind2).intValue()) ? 1 : (displayRank1 == displayRank2 ? 0 : -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer getDisplayRank(Individual ind) {
            Integer rankResult = new Integer(0);
            String query = this.getRankQuery();
            QuerySolutionMap initBindings = new QuerySolutionMap();
            initBindings.add("individualURI", (RDFNode)ResourceFactory.createResource((String)ind.getURI()));
            Query rankQuery = QueryFactory.create((String)query);
            this.queryModel.enterCriticalSection(true);
            try {
                QueryExecution qe = QueryExecutionFactory.create((Query)rankQuery, (Model)this.queryModel, (QuerySolution)initBindings);
                ResultSet res = qe.execSelect();
                try {
                    while (res.hasNext()) {
                        QuerySolution qs = res.nextSolution();
                        if (qs.get("rank") != null && qs.get("rank").isLiteral()) {
                            Literal rankLiteral = qs.getLiteral("rank");
                            rankResult = new Integer(rankLiteral.getInt());
                            continue;
                        }
                        log.debug((Object)"Rank was not returned in query or was not literal");
                    }
                }
                finally {
                    qe.close();
                }
            }
            catch (Exception ex) {
                log.error((Object)("Error occurred in executing query " + query), (Throwable)ex);
            }
            finally {
                this.queryModel.leaveCriticalSection();
            }
            return rankResult;
        }

        private String getRankQuery() {
            return "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> SELECT ?rank WHERE {?individualURI vitro:displayRankAnnot ?rank .} ";
        }
    }
}

