/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import java.util.HashMap;
import javax.servlet.http.HttpSession;

public class DateTimeIntervalFormGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    static final String vivoCore = "http://vivoweb.org/ontology/core#";
    static final String toDateTimeInterval = "http://vivoweb.org/ontology/core#dateTimeInterval";
    static final String intervalType = "http://vivoweb.org/ontology/core#DateTimeInterval";
    static final String intervalToStart = "http://vivoweb.org/ontology/core#start";
    static final String intervalToEnd = "http://vivoweb.org/ontology/core#end";
    static final String dateTimeValue = "http://vivoweb.org/ontology/core#dateTime";
    static final String dateTimeValueType = "http://vivoweb.org/ontology/core#DateTimeValue";
    static final String dateTimePrecision = "http://vivoweb.org/ontology/core#dateTimePrecision";
    final String n3ForStart = "?subject <" + this.getToDateTimeIntervalPredicate() + "> " + this.getNodeN3Var() + " . \n" + this.getNodeN3Var() + "  a <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> . \n" + this.getNodeN3Var() + " <" + "http://vivoweb.org/ontology/core#start" + "> ?startNode . \n" + "?startNode a <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> . \n" + "?startNode  <" + "http://vivoweb.org/ontology/core#dateTime" + "> ?startField-value . \n" + "?startNode  <" + "http://vivoweb.org/ontology/core#dateTimePrecision" + "> ?startField-precision . \n";
    final String n3ForEnd = "?subject <" + this.getToDateTimeIntervalPredicate() + "> " + this.getNodeN3Var() + " . \n" + this.getNodeN3Var() + " a <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> . \n" + this.getNodeN3Var() + " <" + "http://vivoweb.org/ontology/core#end" + "> ?endNode . \n" + "?endNode a <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> . \n" + "?endNode  <" + "http://vivoweb.org/ontology/core#dateTime" + "> ?endField-value . \n" + "?endNode  <" + "http://vivoweb.org/ontology/core#dateTimePrecision" + "> ?endField-precision .";
    final String existingStartDateQuery = "SELECT ?existingDateStart WHERE { \n?subject <" + this.getToDateTimeIntervalPredicate() + "> " + this.getNodeN3Var() + " . \n" + this.getNodeN3Var() + " a <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> . \n" + this.getNodeN3Var() + " <" + "http://vivoweb.org/ontology/core#start" + "> ?startNode . \n" + "?startNode a <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> . \n" + "?startNode <" + "http://vivoweb.org/ontology/core#dateTime" + "> ?existingDateStart }";
    final String existingEndDateQuery = "SELECT ?existingEndDate WHERE { \n?subject <" + this.getToDateTimeIntervalPredicate() + "> " + this.getNodeN3Var() + " . \n" + this.getNodeN3Var() + " a <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> . \n" + this.getNodeN3Var() + " <" + "http://vivoweb.org/ontology/core#end" + "> ?endNode . \n" + "?endNode a <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> . \n " + "?endNode <" + "http://vivoweb.org/ontology/core#dateTime" + "> ?existingEndDate . }";
    final String existingStartNodeQuery = "SELECT ?existingStartNode WHERE { \n?subject <" + this.getToDateTimeIntervalPredicate() + "> " + this.getNodeN3Var() + " . \n" + this.getNodeN3Var() + " a <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> . \n" + this.getNodeN3Var() + " <" + "http://vivoweb.org/ontology/core#start" + "> ?existingStartNode . \n" + "?existingStartNode a <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> .}  ";
    final String existingEndNodeQuery = "SELECT ?existingEndNode WHERE { \n?subject <" + this.getToDateTimeIntervalPredicate() + "> " + this.getNodeN3Var() + " . \n" + this.getNodeN3Var() + " a <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> . \n" + this.getNodeN3Var() + " <" + "http://vivoweb.org/ontology/core#end" + "> ?existingEndNode . \n" + "?existingEndNode a <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> .} ";
    final String existingStartPrecisionQuery = "SELECT ?existingStartPrecision WHERE { \n?subject <" + this.getToDateTimeIntervalPredicate() + "> " + this.getNodeN3Var() + " . \n" + this.getNodeN3Var() + " a <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> . \n" + this.getNodeN3Var() + " <" + "http://vivoweb.org/ontology/core#start" + "> ?startNode . \n" + "?startNode a <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> . \n" + "?startNode <" + "http://vivoweb.org/ontology/core#dateTimePrecision" + "> ?existingStartPrecision . }";
    final String existingEndPrecisionQuery = "SELECT ?existingEndPrecision WHERE { \n?subject <" + this.getToDateTimeIntervalPredicate() + "> " + this.getNodeN3Var() + " . \n" + this.getNodeN3Var() + " a <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> . \n" + this.getNodeN3Var() + " <" + "http://vivoweb.org/ontology/core#end" + "> ?endNode . \n" + "?endNode a <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> . \n" + "?endNode <" + "http://vivoweb.org/ontology/core#dateTimePrecision" + "> ?existingEndPrecision . }";

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.setupEditConfiguration(conf, vreq, session);
        this.prepare(vreq, conf);
        return conf;
    }

    public void setupEditConfiguration(EditConfigurationVTwo conf, VitroRequest vreq, HttpSession session) {
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("dateTimeIntervalForm.ftl");
        conf.setVarNameForSubject("subject");
        conf.setVarNameForPredicate("toDateTimeInterval");
        conf.setVarNameForObject(this.getNodeVar());
        conf.setN3Optional(this.n3ForStart, this.n3ForEnd);
        conf.addNewResource(this.getNodeVar(), "");
        conf.addNewResource("startNode", "");
        conf.addNewResource("endNode", "");
        conf.addSparqlForExistingLiteral("startField-value", this.existingStartDateQuery);
        conf.addSparqlForExistingLiteral("endField-value", this.existingEndDateQuery);
        conf.addSparqlForExistingUris("startNode", this.existingStartNodeQuery);
        conf.addSparqlForExistingUris("endNode", this.existingEndNodeQuery);
        conf.addSparqlForExistingUris("startField-precision", this.existingStartPrecisionQuery);
        conf.addSparqlForExistingUris("endField-precision", this.existingEndPrecisionQuery);
        FieldVTwo startField = new FieldVTwo().setName("startField");
        startField.setEditElement(new DateTimeWithPrecisionVTwo(startField, VitroVocabulary.Precision.SECOND.uri(), VitroVocabulary.Precision.NONE.uri()));
        FieldVTwo endField = new FieldVTwo().setName("endField");
        endField.setEditElement(new DateTimeWithPrecisionVTwo(endField, VitroVocabulary.Precision.SECOND.uri(), VitroVocabulary.Precision.NONE.uri()));
        conf.addField(startField);
        conf.addField(endField);
        conf.addValidator(new DateTimeIntervalValidationVTwo("startField", "endField", "dateTimeIntervalForm.ftl"));
        this.addFormSpecificData(conf, vreq);
    }

    public String getToDateTimeIntervalPredicate() {
        return toDateTimeInterval;
    }

    public String getNodeVar() {
        return "intervalNode";
    }

    public String getNodeN3Var() {
        return "?" + this.getNodeVar();
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        FrontEndEditingUtils.EditMode editMode = FrontEndEditingUtils.EditMode.ADD;
        if (objectUri != null && !objectUri.isEmpty()) {
            editMode = FrontEndEditingUtils.EditMode.EDIT;
        }
        return editMode;
    }
}

