/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.DefaultAddMissingIndividualFormModelPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultAddMissingIndividualFormGenerator
implements EditConfigurationGenerator {
    private static final Log log = LogFactory.getLog(DefaultAddMissingIndividualFormGenerator.class);
    private boolean isObjectPropForm = false;
    private String subjectUri = null;
    private String predicateUri = null;
    private String objectUri = null;
    private String template = "defaultAddMissingIndividualForm.ftl";
    private static String createCommand = "create";
    protected static String objectVarName = "newIndividual";
    private static HashMap<String, String> defaultsForXSDtypes = new HashMap();

    public static final boolean isCreateNewIndividual(VitroRequest vreq, HttpSession session) {
        String command = vreq.getParameter("cmd");
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        ObjectProperty objProp = EditConfigurationUtils.getObjectPropertyForPredicate(vreq, predicateUri);
        if (objProp != null) {
            return objProp.getOfferCreateNewOption() && (command != null && command.equals(createCommand) || !objProp.getSelectFromExisting());
        }
        return false;
    }

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        editConfiguration.setN3Required(this.generateN3Required(vreq));
        editConfiguration.setN3Optional(this.generateN3Optional(vreq));
        editConfiguration.setNewResources(this.generateNewResources(vreq));
        this.setUrisAndLiteralsInScope(editConfiguration);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        editConfiguration.setFilesOnForm(new ArrayList<String>());
        this.setSparqlQueries(editConfiguration);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri(vreq));
        this.addFormSpecificData(editConfiguration, vreq);
        this.addPreprocessors(vreq, editConfiguration);
        this.prepareForUpdate(vreq, session, editConfiguration);
        this.setTemplate(editConfiguration, vreq);
        editConfiguration.addValidator(new AntiXssValidation());
        return editConfiguration;
    }

    protected Map<String, String> generateNewResources(VitroRequest vreq) {
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put(objectVarName, null);
        return newResources;
    }

    private void setEditKey(HttpSession session, EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        String editKey = EditConfigurationVTwo.newEditKey(session);
        editConfiguration.setEditKey(editKey);
    }

    private void setTemplate(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setTemplate(this.template);
    }

    private void initProcessParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        String formUrl = EditConfigurationUtils.getFormUrlWithoutContext(vreq);
        this.subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        this.predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        editConfiguration.setFormUrl(formUrl);
        editConfiguration.setUrlPatternToReturnTo("/individual");
        editConfiguration.setVarNameForSubject("subject");
        editConfiguration.setSubjectUri(this.subjectUri);
        editConfiguration.setEntityToReturnTo(this.subjectUri);
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setPredicateUri(this.predicateUri);
        if (EditConfigurationUtils.isObjectProperty(this.predicateUri, vreq)) {
            this.isObjectPropForm = true;
            this.initObjectParameters(vreq);
            this.processObjectPropForm(vreq, editConfiguration);
        } else {
            log.error((Object)"Add missing individual called for a data property instead of object property");
        }
    }

    private void initObjectParameters(VitroRequest vreq) {
        String thisObjectUri = EditConfigurationUtils.getObjectUri(vreq);
        if (thisObjectUri != null && !thisObjectUri.isEmpty()) {
            this.objectUri = EditConfigurationUtils.getObjectUri(vreq);
        }
    }

    private void processObjectPropForm(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        editConfiguration.setVarNameForObject(objectVarName);
        if (this.isReplaceWithNew(vreq)) {
            editConfiguration.setObject(null);
        } else {
            editConfiguration.setObject(this.objectUri);
        }
    }

    private List<String> generateN3Required(VitroRequest vreq) {
        ArrayList<String> n3ForEdit = new ArrayList<String>();
        n3ForEdit.add(this.getN3PrefixesAsString() + "\n" + this.getN3ForName());
        n3ForEdit.add("?subject ?predicate ?" + objectVarName + " .");
        n3ForEdit.add(this.getN3PrefixesAsString() + "\n" + "?" + objectVarName + " rdf:type <" + this.getRangeClassUri(vreq) + "> . ");
        return n3ForEdit;
    }

    protected List<String> getN3Prefixes() {
        ArrayList<String> prefixStrings = new ArrayList<String>();
        prefixStrings.add("@prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .");
        prefixStrings.add("@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .");
        return prefixStrings;
    }

    protected String getN3PrefixesAsString() {
        String prefixes = StringUtils.join(this.getN3Prefixes(), (String)"\n");
        return prefixes;
    }

    protected String getN3ForName() {
        return "?" + objectVarName + " rdfs:label ?name .";
    }

    protected List<String> generateN3Optional(VitroRequest vreq) {
        ArrayList<String> n3Optional = new ArrayList<String>();
        n3Optional.add("?" + objectVarName + " ?inverseProp ?subject .");
        n3Optional.add(this.getN3PrefixesAsString() + "\n" + "?" + objectVarName + " rdf:type <" + this.getFlagURI(vreq) + "> . ");
        return n3Optional;
    }

    private String getFlagURI(VitroRequest vreq) {
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        String flagURI = wdf.getVClassDao().getTopConcept().getURI();
        return flagURI;
    }

    private String getN3AssertedTypes(VitroRequest vreq) {
        return null;
    }

    private String retrieveQueryForInverse() {
        String queryForInverse = "PREFIX owl:  <http://www.w3.org/2002/07/owl#> SELECT ?inverse_property     WHERE { ?inverse_property owl:inverseOf ?predicate } ";
        return queryForInverse;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap<String, List<Literal>>());
    }

    protected void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add("name");
        editConfiguration.setUrisOnform(urisOnForm);
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap<String, String>());
        HashMap<String, String> urisInScope = new HashMap<String, String>();
        urisInScope.put("inverseProp", this.retrieveQueryForInverse());
        editConfiguration.setSparqlForAdditionalUrisInScope(urisInScope);
        editConfiguration.setSparqlForExistingLiterals(this.generateSparqlForExistingLiterals());
        editConfiguration.setSparqlForExistingUris(this.generateSparqlForExistingUris());
    }

    private HashMap<String, String> generateSparqlForExistingUris() {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    private HashMap<String, String> generateSparqlForExistingLiterals() {
        HashMap<String, String> map = new HashMap<String, String>();
        String query = "PREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> ";
        query = query + "SELECT ?existingName WHERE { ?" + objectVarName + " rdfs:label ?existingName . }";
        map.put("name", query);
        return map;
    }

    protected void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        HashMap<String, FieldVTwo> fields = new HashMap<String, FieldVTwo>();
        if (EditConfigurationUtils.isObjectProperty(EditConfigurationUtils.getPredicateUri(vreq), vreq)) {
            FieldVTwo field = new FieldVTwo();
            field.setName("name");
            ArrayList<String> validators = new ArrayList<String>();
            validators.add("nonempty");
            field.setValidators(validators);
            fields.put(field.getName(), field);
        } else {
            log.error((Object)"Is not object property so fields not set");
        }
        editConfiguration.setFields(fields);
    }

    private String getRangeClassUri(VitroRequest vreq) {
        Individual subject = EditConfigurationUtils.getSubjectIndividual(vreq);
        ObjectProperty prop = EditConfigurationUtils.getObjectProperty(vreq);
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        if (prop.getRangeVClassURI() == null) {
            VClass top = wdf.getVClassDao().getTopConcept();
            prop.setRangeVClassURI(top.getURI());
        }
        BaseResourceBean rangeClass = null;
        String typeOfNew = this.getTypeOfNew(vreq);
        if (typeOfNew != null) {
            rangeClass = wdf.getVClassDao().getVClassByURI(typeOfNew);
        }
        if (rangeClass == null && (rangeClass = wdf.getVClassDao().getVClassByURI(prop.getRangeVClassURI())) == null) {
            throw new Error("Cannot find class for range for property.  Looking for " + prop.getRangeVClassURI());
        }
        return rangeClass.getURI();
    }

    private void prepareForUpdate(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        OntModel model = ModelAccess.on(session.getServletContext()).getOntModel();
        if (EditConfigurationUtils.isObjectProperty(EditConfigurationUtils.getPredicateUri(vreq), vreq)) {
            Individual objectIndividual = EditConfigurationUtils.getObjectIndividual(vreq);
            if (!this.isReplaceWithNew(vreq) && (this.isForwardToCreateButEdit(vreq) || objectIndividual != null)) {
                editConfiguration.prepareForObjPropUpdate((Model)model);
            } else {
                editConfiguration.prepareForNonUpdate((Model)model);
            }
        } else {
            log.error((Object)"Data property not object property so update can't be done correctly");
        }
    }

    private void addPreprocessors(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        if (this.isReplaceWithNew(vreq)) {
            editConfiguration.addModelChangePreprocessor(new DefaultAddMissingIndividualFormModelPreprocessor(this.subjectUri, this.predicateUri, this.objectUri));
        }
    }

    private boolean isTypeOfNew(VitroRequest vreq) {
        String typeOfNew = this.getTypeOfNew(vreq);
        return typeOfNew != null && !typeOfNew.isEmpty();
    }

    protected String getTypeOfNew(VitroRequest vreq) {
        return vreq.getParameter("typeOfNew");
    }

    private boolean isReplaceWithNew(VitroRequest vreq) {
        ObjectProperty objectProp = EditConfigurationUtils.getObjectProperty(vreq);
        boolean isEditOfExistingStmt = this.isEditOfExistingStatement(vreq);
        String command = vreq.getParameter("cmd");
        return isEditOfExistingStmt && "create".equals(command) && objectProp != null && objectProp.getOfferCreateNewOption();
    }

    private boolean isForwardToCreateButEdit(VitroRequest vreq) {
        boolean isEditOfExistingStmt = this.isEditOfExistingStatement(vreq);
        ObjectProperty objectProp = EditConfigurationUtils.getObjectProperty(vreq);
        String command = vreq.getParameter("cmd");
        return isEditOfExistingStmt && !"create".equals(command) && objectProp != null && objectProp.getOfferCreateNewOption() && !objectProp.getSelectFromExisting();
    }

    private boolean isEditOfExistingStatement(VitroRequest vreq) {
        if (EditConfigurationUtils.isDataProperty(EditConfigurationUtils.getPredicateUri(vreq), vreq)) {
            return false;
        }
        Individual object = EditConfigurationUtils.getObjectIndividual(vreq);
        return object != null;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
    }

    static {
        defaultsForXSDtypes.put("http://www.w3.org/2001/XMLSchema#dateTime", "#Unparseable datetime defaults to now");
    }
}

