/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultObjectPropertyFormGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDeleteGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(DefaultObjectPropertyFormGenerator.class);
    private String subjectUri = null;
    private String predicateUri = null;
    private String objectUri = null;
    private Integer dataHash = 0;
    private DataPropertyStatement dps = null;
    private String dataLiteral = null;
    private String template = "confirmDeletePropertyForm.ftl";
    private static HashMap<String, String> defaultsForXSDtypes = new HashMap();

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = EditConfigurationVTwo.getConfigFromSession(session, (HttpServletRequest)vreq);
        if (editConfiguration == null) {
            editConfiguration = this.setupEditConfiguration(vreq, session);
        }
        editConfiguration.setTemplate(this.template);
        this.prepare(vreq, editConfiguration);
        return editConfiguration;
    }

    private EditConfigurationVTwo setupEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        editConfiguration.setEditKey(EditConfigurationVTwo.newEditKey(session));
        return editConfiguration;
    }

    private void initProcessParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        this.subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        this.predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        editConfiguration.setSubjectUri(this.subjectUri);
        editConfiguration.setPredicateUri(this.predicateUri);
        editConfiguration.setEntityToReturnTo(this.subjectUri);
        editConfiguration.setUrlPatternToReturnTo("/individual");
        if (EditConfigurationUtils.isObjectProperty(this.predicateUri, vreq)) {
            this.initObjectParameters(vreq);
            this.processObjectPropForm(vreq, editConfiguration);
        } else {
            this.processDataPropForm(vreq, session, editConfiguration);
        }
    }

    private void initObjectParameters(VitroRequest vreq) {
        this.objectUri = EditConfigurationUtils.getObjectUri(vreq);
    }

    private void processObjectPropForm(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        editConfiguration.setObject(this.objectUri);
    }

    private void processDataPropForm(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        this.dataHash = EditConfigurationUtils.getDataHash(vreq);
        if (this.dataHash != null) {
            this.log.debug((Object)("Found a datapropKey in parameters and parsed it to int: " + this.dataHash));
            editConfiguration.setDatapropKey(this.dataHash);
            this.dps = EditConfigurationUtils.getDataPropertyStatement(vreq, session, this.dataHash, this.predicateUri);
            if (this.dps != null) {
                editConfiguration.addFormSpecificData("dataPropertyLexicalValue", this.dps.getData());
            } else {
                editConfiguration.addFormSpecificData("dataPropertyLexicalValue", "unknown value");
            }
        } else {
            this.log.debug((Object)"Did NOT find a datapropKey for hte data hash.");
            editConfiguration.addFormSpecificData("dataPropertyLexicalValue", "unknown value");
        }
    }

    static {
        defaultsForXSDtypes.put("http://www.w3.org/2001/XMLSchema#dateTime", "#Unparseable datetime defaults to now");
    }
}

