/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class NewIndividualFormGenerator
implements EditConfigurationGenerator {
    private String subjectUri = null;
    private String predicateUri = null;
    private String objectUri = null;
    private String template = "newIndividualForm.ftl";
    private static HashMap<String, String> defaultsForXSDtypes = new HashMap();

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        editConfiguration.setN3Required(this.generateN3Required(vreq));
        editConfiguration.setN3Optional(this.generateN3Optional());
        editConfiguration.setNewResources(this.generateNewResources(vreq));
        this.setUrisAndLiteralsInScope(editConfiguration);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        editConfiguration.setFilesOnForm(new ArrayList<String>());
        this.setSparqlQueries(editConfiguration);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri(vreq));
        this.prepareForUpdate(vreq, session, editConfiguration);
        editConfiguration.addValidator(new AntiXssValidation());
        this.setTemplate(editConfiguration, vreq);
        this.setEditKey(editConfiguration, vreq);
        this.addFormSpecificData(editConfiguration, vreq);
        return editConfiguration;
    }

    private Map<String, String> generateNewResources(VitroRequest vreq) {
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put("newInd", null);
        return newResources;
    }

    private void setEditKey(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        String editKey = EditConfigurationUtils.getEditKey(vreq);
        editConfiguration.setEditKey(editKey);
    }

    private void setTemplate(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setTemplate(this.template);
    }

    private void initProcessParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        String formUrl = EditConfigurationUtils.getFormUrlWithoutContext(vreq);
        this.subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        this.predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        editConfiguration.setFormUrl(formUrl);
        editConfiguration.setUrlPatternToReturnTo("/individual");
        editConfiguration.setVarNameForSubject("subjectNotUsed");
        editConfiguration.setSubjectUri(this.subjectUri);
        editConfiguration.setEntityToReturnTo("?newInd");
        editConfiguration.setVarNameForPredicate("predicateNotUsed");
        editConfiguration.setPredicateUri(this.predicateUri);
        this.initObjectParameters(vreq);
        this.processObjectPropForm(vreq, editConfiguration);
    }

    private void initObjectParameters(VitroRequest vreq) {
        this.objectUri = EditConfigurationUtils.getObjectUri(vreq);
    }

    private void processObjectPropForm(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        editConfiguration.setVarNameForObject("objectNotUsed");
        editConfiguration.setObject(this.objectUri);
    }

    private List<String> generateN3Required(VitroRequest vreq) {
        ArrayList<String> n3ForEdit = new ArrayList<String>();
        String editString = "?newInd <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <" + this.getTypeOfNew(vreq) + "> .";
        n3ForEdit.add(editString);
        return n3ForEdit;
    }

    private List<String> generateN3Optional() {
        ArrayList<String> n3Optional = new ArrayList<String>();
        String editString = "?newInd <" + RDFS.label.getURI() + "> ?label .";
        n3Optional.add(editString);
        return n3Optional;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap<String, List<Literal>>());
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add("label");
        editConfiguration.setUrisOnform(urisOnForm);
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap<String, String>());
        HashMap<String, String> urisInScope = new HashMap<String, String>();
        editConfiguration.setSparqlForAdditionalUrisInScope(urisInScope);
        editConfiguration.setSparqlForExistingLiterals(this.generateSparqlForExistingLiterals());
        editConfiguration.setSparqlForExistingUris(this.generateSparqlForExistingUris());
    }

    private HashMap<String, String> generateSparqlForExistingUris() {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    private HashMap<String, String> generateSparqlForExistingLiterals() {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    private void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        HashMap<String, FieldVTwo> fields = new HashMap<String, FieldVTwo>();
        this.setLabelField(editConfiguration, vreq, fields);
    }

    private void setLabelField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        FieldVTwo field = new FieldVTwo();
        field.setName("label");
        field.setRangeDatatypeUri(XSD.xstring.toString());
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("nonempty");
        field.setValidators(validators);
        fields.put(field.getName(), field);
        editConfiguration.setFields(fields);
    }

    private void prepareForUpdate(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        OntModel model = ModelAccess.on(session.getServletContext()).getOntModel();
        editConfiguration.prepareForNonUpdate((Model)model);
    }

    private String getTypeOfNew(VitroRequest vreq) {
        return vreq.getParameter("typeOfNew");
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        formSpecificData.put("typeName", this.getTypeName(vreq));
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    private String getTypeName(VitroRequest vreq) {
        String typeOfNew = this.getTypeOfNew(vreq);
        VClass type = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(typeOfNew);
        return type.getName();
    }

    static {
        defaultsForXSDtypes.put("http://www.w3.org/2001/XMLSchema#dateTime", "#Unparseable datetime defaults to now");
    }
}

