/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import com.hp.hpl.jena.rdf.model.Literal;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.BaseEditSubmissionPreprocessorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.ManagePageGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterN3;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterN3Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagePagePreprocessor
extends BaseEditSubmissionPreprocessorVTwo {
    protected static final Log log = LogFactory.getLog((String)ManagePagePreprocessor.class.getName());
    private static MultiValueEditSubmission submission = null;
    private static EditConfigurationVTwo editConfiguration = null;
    private static Map<String, List<String>> transformedLiteralsFromForm = null;
    private static Map<String, List<String>> urisFromForm = null;
    private static List<String> pageContentUnits = null;
    private static List<JSONObject> pageContentUnitsJSON = null;

    public ManagePagePreprocessor(EditConfigurationVTwo editConfig) {
        super(editConfig);
        editConfiguration = editConfig;
    }

    @Override
    public void preprocess(MultiValueEditSubmission inputSubmission, VitroRequest vreq) {
        submission = inputSubmission;
        this.copySubmissionValues();
        this.processDataGetters();
        this.processExistingValues();
    }

    private void copySubmissionValues() {
        Map<String, List<Literal>> literalsFromForm = submission.getLiteralsFromForm();
        transformedLiteralsFromForm = this.copyMap(EditConfigurationUtils.transformLiteralMap(literalsFromForm));
        urisFromForm = this.copyMap(submission.getUrisFromForm());
        pageContentUnits = transformedLiteralsFromForm.get("pageContentUnit");
    }

    private Map<String, List<String>> copyMap(Map<String, List<String>> originalMap) {
        HashMap<String, List<String>> copyMap = new HashMap<String, List<String>>();
        copyMap.putAll(originalMap);
        return copyMap;
    }

    private void processExistingValues() {
        if (editConfiguration.isParamUpdate()) {
            Map<String, List<Literal>> literalsInScope = editConfiguration.getLiteralsInScope();
            Map<String, List<String>> urisInScope = editConfiguration.getUrisInScope();
            ArrayList<String> literalKeys = new ArrayList<String>(literalsInScope.keySet());
            ArrayList<String> uriKeys = new ArrayList<String>(urisInScope.keySet());
            for (String literalName : literalKeys) {
                boolean haslv = submission.hasLiteralValue(literalName);
                if (submission.hasLiteralValue(literalName)) continue;
                submission.addLiteralToForm(editConfiguration, editConfiguration.getField(literalName), literalName, new String[]{null});
            }
            for (String uriName : uriKeys) {
                if (uriName == "page") continue;
                boolean hasuv = submission.hasUriValue(uriName);
                if (submission.hasUriValue(uriName)) continue;
                submission.addUriToForm(editConfiguration, uriName, new String[]{">SUBMITTED VALUE WAS BLANK<"});
            }
        }
    }

    private void processDataGetters() {
        this.convertToJson();
        int counter = 0;
        for (JSONObject jsonObject : pageContentUnitsJSON) {
            String dataGetterClass = this.getDataGetterClass(jsonObject);
            ProcessDataGetterN3 pn = ProcessDataGetterN3Utils.getDataGetterProcessorN3(dataGetterClass, jsonObject);
            jsonObject.put((Object)"classType", (Object)pn.getClassType());
            this.addN3Optional(pn, counter);
            this.addLiteralsAndUrisOnForm(pn, counter);
            this.addFields(pn, counter);
            this.addNewResources(pn, counter);
            this.addInputsToSubmission(pn, counter, jsonObject);
            ++counter;
        }
    }

    private void addNewResources(ProcessDataGetterN3 pn, int counter) {
        List<String> newResources = pn.getNewResources(counter);
        for (String newResource : newResources) {
            editConfiguration.addNewResource(newResource, null);
        }
    }

    private void convertToJson() {
        pageContentUnitsJSON = new ArrayList<JSONObject>();
        if (pageContentUnits != null) {
            for (String pageContentUnit : pageContentUnits) {
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON((Object)pageContentUnit);
                pageContentUnitsJSON.add(jsonObject);
            }
        }
    }

    private void addInputsToSubmission(ProcessDataGetterN3 pn, int counter, JSONObject jsonObject) {
        JSONArray values;
        Object jsonValue;
        List<String> literalLabels = pn.getLiteralVarNamesBase();
        List<String> uriLabels = pn.getUriVarNamesBase();
        for (String literalLabel : literalLabels) {
            List<String> literalValues = new ArrayList<String>();
            jsonValue = jsonObject.get(literalLabel);
            String submissionLiteralName = pn.getVarName(literalLabel, counter);
            if (jsonValue instanceof String) {
                String jsonString = jsonObject.getString(literalLabel);
                jsonString = pn.replaceEncodedQuotesWithEscapedQuotes(jsonString);
                literalValues.add(jsonString);
            } else if (jsonValue instanceof JSONArray) {
                values = jsonObject.getJSONArray(literalLabel);
                literalValues = (List)JSONSerializer.toJava((JSON)values);
                this.replaceEncodedQuotesInList(pn, literalValues);
            } else if (jsonValue instanceof Boolean) {
                Boolean booleanValue = jsonObject.getBoolean(literalLabel);
                literalValues.add(booleanValue.toString());
            }
            String[] literalValuesSubmission = new String[literalValues.size()];
            literalValuesSubmission = literalValues.toArray(literalValuesSubmission);
            submission.addLiteralToForm(editConfiguration, editConfiguration.getField(submissionLiteralName), submissionLiteralName, literalValuesSubmission);
        }
        for (String uriLabel : uriLabels) {
            List<String> uriValues = new ArrayList<String>();
            jsonValue = jsonObject.get(uriLabel);
            String submissionUriName = pn.getVarName(uriLabel, counter);
            if (jsonValue instanceof String) {
                uriValues.add(jsonObject.getString(uriLabel));
            } else if (jsonValue instanceof JSONArray) {
                values = jsonObject.getJSONArray(uriLabel);
                uriValues = (List)JSONSerializer.toJava((JSON)values);
            }
            String[] uriValuesSubmission = new String[uriValues.size()];
            uriValuesSubmission = uriValues.toArray(uriValuesSubmission);
            submission.addUriToForm(editConfiguration, submissionUriName, uriValuesSubmission);
        }
        if (editConfiguration.isParamUpdate()) {
            String dataGetterURISubmissionName = pn.getDataGetterVarName(counter);
            if (jsonObject.containsKey((Object)"URI")) {
                String URIValue = jsonObject.getString("URI");
                if (URIValue != null) {
                    log.debug((Object)("Existing URI for data getter found: " + URIValue));
                    submission.addUriToForm(editConfiguration, dataGetterURISubmissionName, new String[]{URIValue});
                }
            } else {
                submission.addUriToForm(editConfiguration, dataGetterURISubmissionName, new String[]{">NEW URI REQUIRED<"});
            }
        }
    }

    private void replaceEncodedQuotesInList(ProcessDataGetterN3 pn, List<String> values) {
        int len = values.size();
        for (int i = 0; i < len; ++i) {
            String value = values.get(i);
            if (!value.contains("&quot;") && !value.contains("&#39;")) continue;
            value = pn.replaceEncodedQuotesWithEscapedQuotes(value);
            values.set(i, value);
        }
    }

    private void addFields(ProcessDataGetterN3 pn, int counter) {
        List<FieldVTwo> fields = pn.retrieveFields(counter);
        Map<String, FieldVTwo> existingFields = editConfiguration.getFields();
        for (FieldVTwo newField : fields) {
            String newFieldName = newField.getName();
            if (existingFields.containsKey(newFieldName)) {
                FieldVTwo existingField = existingFields.get(newFieldName);
                if (existingField.isEqualTo(newField)) {
                    log.debug((Object)("This field already exists and so will not be added:" + newFieldName));
                    continue;
                }
                log.error((Object)("The field with the same name is different and will not be added as a different field exists which is different:" + newFieldName));
                continue;
            }
            editConfiguration.addField(newField);
        }
    }

    private void addLiteralsAndUrisOnForm(ProcessDataGetterN3 pn, int counter) {
        List<String> literalsOnForm = pn.retrieveLiteralsOnForm(counter);
        editConfiguration.addLiteralsOnForm(literalsOnForm);
        List<String> urisOnForm = pn.retrieveUrisOnForm(counter);
        editConfiguration.addUrisOnForm(urisOnForm);
    }

    private List<String> getPageToDataGetterN3(ProcessDataGetterN3 pn, int counter) {
        String dataGetterVar = pn.getDataGetterVar(counter);
        String pageToDataGetterN3 = ManagePageGenerator.getDataGetterN3(dataGetterVar);
        return Arrays.asList(pageToDataGetterN3);
    }

    private void addN3Optional(ProcessDataGetterN3 pn, int counter) {
        ArrayList<String> addList = new ArrayList<String>();
        List<String> requiredList = pn.retrieveN3Required(counter);
        requiredList.addAll(this.getPageToDataGetterN3(pn, counter));
        List<String> optionalList = pn.retrieveN3Optional(counter);
        if (requiredList != null) {
            addList.addAll(requiredList);
        }
        if (optionalList != null) {
            addList.addAll(optionalList);
        }
        editConfiguration.addN3Optional(addList);
    }

    private String getDataGetterClass(JSONObject jsonObject) {
        String javaURI = jsonObject.getString("dataGetterClass");
        return this.getQualifiedDataGetterName(javaURI);
    }

    private String getQualifiedDataGetterName(String dataGetterTypeURI) {
        String javaURI = "java:";
        if (dataGetterTypeURI.startsWith(javaURI)) {
            int beginIndex = javaURI.length();
            return dataGetterTypeURI.substring(beginIndex);
        }
        return dataGetterTypeURI;
    }
}

