/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators;

import com.hp.hpl.jena.rdf.model.Literal;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.web.AntiScript;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class AntiXssValidation
implements N3ValidatorVTwo {
    List<String> fieldNamesToValidate;
    public static String XSS_ERROR_MESSAGE = "Field contains unacceptable markup";
    private static final Map<String, String> NO_ERROR = Collections.emptyMap();
    private static final List<String> ALL_FIELDS = null;

    public AntiXssValidation() {
        this.fieldNamesToValidate = ALL_FIELDS;
    }

    public AntiXssValidation(List<String> fieldNamesToValidate) {
        this.fieldNamesToValidate = fieldNamesToValidate;
    }

    @Override
    public Map<String, String> validate(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        if (editSub == null) {
            return null;
        }
        HashMap<String, String> varToErrMsg = new HashMap<String, String>();
        if (this.fieldNamesToValidate == null) {
            if (editSub.getLiteralsFromForm() != null) {
                for (String name : editSub.getLiteralsFromForm().keySet()) {
                    varToErrMsg.putAll(this.checkSubmissionForField(name, editSub));
                }
            }
            if (editSub.getUrisFromForm() != null) {
                for (String name : editSub.getUrisFromForm().keySet()) {
                    varToErrMsg.putAll(this.checkSubmissionForField(name, editSub));
                }
            }
        } else {
            for (String fieldName : this.fieldNamesToValidate) {
                varToErrMsg.putAll(this.checkSubmissionForField(fieldName, editSub));
            }
        }
        if (varToErrMsg.isEmpty()) {
            return null;
        }
        return varToErrMsg;
    }

    protected Map<String, String> checkSubmissionForField(String fieldName, MultiValueEditSubmission editSub) {
        if (fieldName == null || fieldName.isEmpty() || editSub == null) {
            return NO_ERROR;
        }
        if (editSub.getLiteralsFromForm() != null && editSub.getLiteralsFromForm().containsKey(fieldName)) {
            String error = null;
            try {
                error = this.literalHasXSS(editSub.getLiteralsFromForm().get(fieldName));
            }
            catch (ScanException e) {
                error = e.getMessage();
            }
            catch (PolicyException e) {
                error = e.getMessage();
            }
            if (error != null) {
                return Collections.singletonMap(fieldName, XSS_ERROR_MESSAGE + " " + error);
            }
            return NO_ERROR;
        }
        if (editSub.getUrisFromForm() != null && editSub.getUrisFromForm().containsKey(fieldName)) {
            String error;
            try {
                error = this.uriHasXSS(editSub.getUrisFromForm().get(fieldName));
            }
            catch (ScanException e) {
                error = e.getMessage();
            }
            catch (PolicyException e) {
                error = e.getMessage();
            }
            if (error != null) {
                return Collections.singletonMap(fieldName, XSS_ERROR_MESSAGE + " " + error);
            }
            return NO_ERROR;
        }
        return NO_ERROR;
    }

    private String uriHasXSS(List<String> uriList) throws ScanException, PolicyException {
        AntiSamy antiSamy = AntiScript.getAntiSamyScanner();
        ArrayList errorMsgs = new ArrayList();
        for (String uri : uriList) {
            CleanResults cr = antiSamy.scan(uri);
            errorMsgs.addAll(cr.getErrorMessages());
        }
        if (errorMsgs.isEmpty()) {
            return null;
        }
        return StringUtils.join(errorMsgs, (String)", ");
    }

    private String literalHasXSS(List<Literal> list) throws ScanException, PolicyException {
        AntiSamy antiSamy = AntiScript.getAntiSamyScanner();
        ArrayList errorMsgs = new ArrayList();
        for (Literal literal : list) {
            String lang;
            if (literal == null) continue;
            CleanResults cr = antiSamy.scan(literal.getLexicalForm());
            errorMsgs.addAll(cr.getErrorMessages());
            String dt = literal.getDatatypeURI();
            if (dt != null) {
                cr = antiSamy.scan(dt);
                errorMsgs.addAll(cr.getErrorMessages());
            }
            if ((lang = literal.getLanguage()) == null) continue;
            cr = antiSamy.scan(lang);
            errorMsgs.addAll(cr.getErrorMessages());
        }
        if (errorMsgs.isEmpty()) {
            return null;
        }
        return StringUtils.join(errorMsgs, (String)", ");
    }
}

