/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileServingHelper {
    private static final Log log = LogFactory.getLog(FileServingHelper.class);
    public static final String PROPERTY_DEFAULT_NAMESPACE = "Vitro.defaultNamespace";
    private static final String DEFAULT_PATH = "/individual/";
    private static final String FILE_PATH = "/file/";
    private static boolean warned;

    private static String getDefaultNamespace(ServletContext ctx) {
        String defaultNamespace = ConfigurationProperties.getBean(ctx).getProperty(PROPERTY_DEFAULT_NAMESPACE);
        if (defaultNamespace == null) {
            throw new IllegalArgumentException("Configuration properties must contain a value for 'Vitro.defaultNamespace'");
        }
        if (!defaultNamespace.endsWith(DEFAULT_PATH) && !warned) {
            log.warn((Object)("Default namespace does not match the expected form: '" + defaultNamespace + "'"));
            warned = true;
        }
        return defaultNamespace;
    }

    public static String getBytestreamAliasUrl(String uri, String filename, ServletContext ctx) {
        if (uri == null || filename == null) {
            return null;
        }
        String defaultNamespace = FileServingHelper.getDefaultNamespace(ctx);
        if (!uri.startsWith(defaultNamespace)) {
            log.warn((Object)("uri does not start with the default namespace: '" + uri + "'"));
            return uri;
        }
        String remainder = uri.substring(defaultNamespace.length());
        try {
            filename = URLEncoder.encode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"No UTF-8 encoding?", (Throwable)e);
        }
        String separator = remainder.endsWith("/") ? "" : "/";
        return FILE_PATH + remainder + separator + filename;
    }

    private FileServingHelper() {
    }

    public static String getBytestreamUri(String path, ServletContext ctx) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith(FILE_PATH)) {
            log.warn((Object)("path does not start with a file prefix: '" + path + "'"));
            return null;
        }
        String remainder = path.substring(FILE_PATH.length());
        int slashHere = remainder.lastIndexOf(47);
        if (slashHere == -1) {
            log.debug((Object)("path does not include a filename: '" + path + "'"));
            return null;
        }
        remainder = remainder.substring(0, slashHere);
        return FileServingHelper.getDefaultNamespace(ctx) + remainder;
    }
}

