/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage.impl;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.filestorage.impl.FileStorageImpl;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileAlreadyExistsException;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileStorage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletContext;

public class FileStorageImplWrapper
implements FileStorage {
    public static final String PROPERTY_DEFAULT_NAMESPACE = "Vitro.defaultNamespace";
    public static final String FILE_STORAGE_SUBDIRECTORY = "uploads";
    private FileStorageImpl fs;

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        ServletContext ctx = application.getServletContext();
        try {
            File baseDirectory = this.figureBaseDir();
            Collection<String> fileNamespace = this.confirmDefaultNamespace(ctx);
            this.fs = new FileStorageImpl(baseDirectory, fileNamespace);
        }
        catch (Exception e) {
            ss.fatal("Failed to initialize the file system.", e);
        }
    }

    private File figureBaseDir() throws IOException {
        boolean created;
        File homeDir = ApplicationUtils.instance().getHomeDirectory().getPath().toFile();
        File baseDir = new File(homeDir, FILE_STORAGE_SUBDIRECTORY);
        if (!baseDir.exists() && !(created = baseDir.mkdir())) {
            throw new IOException("Unable to create uploads directory at '" + baseDir + "'");
        }
        return baseDir;
    }

    private Collection<String> confirmDefaultNamespace(ServletContext ctx) {
        String defaultNamespace = ConfigurationProperties.getBean(ctx).getProperty(PROPERTY_DEFAULT_NAMESPACE);
        if (defaultNamespace == null) {
            throw new IllegalArgumentException("Configuration properties must contain a value for 'Vitro.defaultNamespace'");
        }
        return Collections.singleton(defaultNamespace);
    }

    @Override
    public void shutdown(Application application) {
    }

    @Override
    public void createFile(String id, String filename, InputStream bytes) throws FileAlreadyExistsException, IOException {
        this.fs.createFile(id, filename, bytes);
    }

    @Override
    public String getFilename(String id) throws IOException {
        return this.fs.getFilename(id);
    }

    @Override
    public InputStream getInputStream(String id, String filename) throws FileNotFoundException, IOException {
        return this.fs.getInputStream(id, filename);
    }

    @Override
    public boolean deleteFile(String id) throws IOException {
        return this.fs.deleteFile(id);
    }
}

