/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage.model;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.FileInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageInfo {
    private static final Log log = LogFactory.getLog(ImageInfo.class);
    public static final ImageInfo EMPTY_IMAGE_INFO = ImageInfo.emptyInstance();
    private final FileInfo mainImage;
    private final FileInfo thumbnail;

    private static ImageInfo emptyInstance() {
        FileInfo emptyFileInfo = new FileInfo.Builder().build();
        return new ImageInfo(emptyFileInfo, emptyFileInfo);
    }

    public static ImageInfo instanceFromEntityUri(WebappDaoFactory webappDaoFactory, Individual entity) {
        if (webappDaoFactory == null) {
            throw new NullPointerException("webappDaoFactory may not be null.");
        }
        if (entity == null) {
            return null;
        }
        IndividualDao individualDao = webappDaoFactory.getIndividualDao();
        String mainImageUri = entity.getMainImageUri();
        if (mainImageUri == null) {
            log.debug((Object)("Entity '" + entity.getURI() + "' had no associated main image."));
            return null;
        }
        log.debug((Object)("Entity '" + entity.getURI() + "' had associated main image: '" + mainImageUri + "'"));
        Individual mainFile = individualDao.getIndividualByURI(mainImageUri);
        if (mainFile == null) {
            log.error((Object)("Entity '" + entity.getURI() + "' has a main image URI that does not refer to an " + "individual: mainImageURI=" + mainImageUri));
            return null;
        }
        Individual thumbFile = mainFile.getRelatedIndividual("http://vitro.mannlib.cornell.edu/ns/vitro/public#thumbnailImage");
        if (thumbFile == null) {
            log.warn((Object)("Main image file '" + mainImageUri + "' had no associated thumbnail."));
            return null;
        }
        log.debug((Object)("Main image file '" + mainImageUri + "' had associated thumbnail: '" + thumbFile.getURI() + "'"));
        FileInfo mainInfo = FileInfo.instanceFromSurrogateUri(webappDaoFactory, mainFile.getURI());
        if (mainInfo == null) {
            log.error((Object)("Entity '" + entity.getURI() + "' has a mainImage that is not a File " + "surrogate: mainImageURI=" + mainImageUri));
            return null;
        }
        FileInfo thumbInfo = FileInfo.instanceFromSurrogateUri(webappDaoFactory, thumbFile.getURI());
        if (thumbInfo == null) {
            log.error((Object)("Entity '" + entity.getURI() + "' has a mainImage with a thumbnail that is not a File " + "surrogate: mainImageURI=" + mainImageUri + ", thumbnailURI=" + thumbFile.getURI()));
            return null;
        }
        return new ImageInfo(mainInfo, thumbInfo);
    }

    public ImageInfo(FileInfo mainImage, FileInfo thumbnail) {
        if (mainImage == null) {
            throw new NullPointerException("mainImage may not be null.");
        }
        if (thumbnail == null) {
            throw new NullPointerException("thumbnail may not be null.");
        }
        this.mainImage = mainImage;
        this.thumbnail = thumbnail;
    }

    public FileInfo getMainImage() {
        return this.mainImage;
    }

    public FileInfo getThumbnail() {
        return this.thumbnail;
    }
}

