/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VitroModelSource;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.RequestModelAccessImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelSwitcher {
    private static final Log log = LogFactory.getLog(ModelSwitcher.class);

    public static boolean authorizedForSpecialModel(HttpServletRequest req) {
        if (ModelSwitcher.isParameterPresent(req, "switchToDisplayModel")) {
            return PolicyHelper.isAuthorizedForActions(req, new AuthorizationRequest[]{SimplePermission.MANAGE_MENUS.ACTION});
        }
        if (ModelSwitcher.anyOtherSpecialProperties(req)) {
            return PolicyHelper.isAuthorizedForActions(req, new AuthorizationRequest[]{SimplePermission.ACCESS_SPECIAL_DATA_MODELS.ACTION});
        }
        return true;
    }

    private static boolean anyOtherSpecialProperties(HttpServletRequest req) {
        return ModelSwitcher.isParameterPresent(req, "useThisModel") || ModelSwitcher.isParameterPresent(req, "useThisTboxModel") || ModelSwitcher.isParameterPresent(req, "useThisDisplayModel");
    }

    private static boolean isParameterPresent(HttpServletRequest req, String key) {
        return StringUtils.isNotEmpty((String)req.getParameter(key));
    }

    public WebappDaoFactory checkForModelSwitching(VitroRequest vreq, WebappDaoFactory inputWadf) {
        ServletContext _context = vreq.getSession().getServletContext();
        if (!(inputWadf instanceof WebappDaoFactoryJena)) {
            log.warn((Object)"Can't set special models: WebappDaoFactory is not a WebappDaoFactoryJena");
            this.removeSpecialWriteModel(vreq);
            return inputWadf;
        }
        WebappDaoFactoryJena wadf = (WebappDaoFactoryJena)inputWadf;
        if (ModelSwitcher.isParameterPresent((HttpServletRequest)vreq, "switchToDisplayModel")) {
            OntModel mainOntModel = ModelAccess.on(_context).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata");
            OntModel tboxOntModel = ModelAccess.on(_context).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadataTBOX");
            this.setSpecialWriteModel(vreq, mainOntModel);
            vreq.setAttribute("idForAboxModel", VitroModelSource.ModelName.DISPLAY.toString());
            vreq.setAttribute("idForTboxModel", VitroModelSource.ModelName.DISPLAY_TBOX.toString());
            vreq.setAttribute("idForDisplayModel", VitroModelSource.ModelName.DISPLAY_DISPLAY.toString());
            vreq.setAttribute("idForWriteModel", VitroModelSource.ModelName.DISPLAY.toString());
            return this.createNewWebappDaoFactory(wadf, mainOntModel, tboxOntModel, null);
        }
        if (ModelSwitcher.anyOtherSpecialProperties((HttpServletRequest)vreq)) {
            OntModel mainOntModel = this.createSpecialModel(vreq, "useThisModel");
            OntModel tboxOntModel = this.createSpecialModel(vreq, "useThisTboxModel");
            OntModel displayOntModel = this.createSpecialModel(vreq, "useThisDisplayModel");
            vreq.setAttribute("idForAboxModel", vreq.getParameter("useThisModel"));
            vreq.setAttribute("idForWriteModel", vreq.getParameter("useThisModel"));
            vreq.setAttribute("idForTboxModel", vreq.getParameter("useThisTboxModel"));
            vreq.setAttribute("idForDisplayModel", vreq.getParameter("useThisDisplayModel"));
            this.setSpecialWriteModel(vreq, mainOntModel);
            return this.createNewWebappDaoFactory(wadf, mainOntModel, tboxOntModel, displayOntModel);
        }
        this.removeSpecialWriteModel(vreq);
        return wadf;
    }

    private void setSpecialWriteModel(VitroRequest vreq, OntModel mainOntModel) {
        if (mainOntModel != null) {
            ((RequestModelAccessImpl)ModelAccess.on((HttpServletRequest)vreq)).setSpecialWriteModel(mainOntModel);
            vreq.setAttribute("specialWriteModel", mainOntModel);
        }
    }

    private void removeSpecialWriteModel(VitroRequest vreq) {
        if (vreq.getAttribute("specialWriteModel") != null) {
            vreq.removeAttribute("specialWriteModel");
        }
    }

    private WebappDaoFactory createNewWebappDaoFactory(WebappDaoFactoryJena inputWadf, OntModel mainOntModel, OntModel tboxOntModel, OntModel displayOntModel) {
        WebappDaoFactoryJena wadfj = new WebappDaoFactoryJena(inputWadf);
        wadfj.setSpecialDataModel(mainOntModel, tboxOntModel, displayOntModel);
        return wadfj;
    }

    private OntModel createSpecialModel(VitroRequest vreq, String key) {
        if (!ModelSwitcher.isParameterPresent((HttpServletRequest)vreq, key)) {
            return null;
        }
        String modelUri = vreq.getParameter(key);
        OntModel ont = this.findModelInRdfService(vreq, modelUri, ModelAccess.WhichService.CONFIGURATION);
        if (ont == null) {
            ont = this.findModelInRdfService(vreq, modelUri, ModelAccess.WhichService.CONTENT);
        }
        if (ont == null) {
            throw new IllegalStateException("Main Model Uri " + modelUri + " did not retrieve model");
        }
        return ont;
    }

    private OntModel findModelInRdfService(VitroRequest vreq, String modelUri, ModelAccess.WhichService which) {
        try {
            RDFService rdfService = RDFServiceUtils.getRDFService(vreq, which);
            if (!rdfService.getGraphURIs().contains(modelUri)) {
                return null;
            }
            Model m = new RDFServiceDataset(rdfService).getNamedModel(modelUri);
            return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)m);
        }
        catch (Exception e) {
            log.error((Object)("failed to find model: '" + modelUri + "' in RDFService " + which), (Throwable)e);
            return null;
        }
    }
}

