/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.filters.ModelSwitcher;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.io.IOException;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestModelsPrep
implements Filter {
    private static final Log log = LogFactory.getLog(RequestModelsPrep.class);

    public void init(FilterConfig fc) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!ModelSwitcher.authorizedForSpecialModel(req)) {
            VitroHttpServlet.redirectUnauthorizedRequest(req, resp);
            return;
        }
        try {
            this.setCollator(new VitroRequest(req));
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            if (ModelAccess.isPresent(req)) {
                ModelAccess.on(req).close();
            }
        }
    }

    private void setCollator(VitroRequest vreq) {
        Enumeration locales = vreq.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            Collator collator = Collator.getInstance(locale);
            if (collator == null) continue;
            vreq.setCollator(collator);
            return;
        }
        vreq.setCollator(Collator.getInstance());
    }

    public void destroy() {
    }
}

