/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.filters.VitroURL;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.NamespaceMapper;
import edu.cornell.mannlib.vitro.webapp.utils.NamespaceMapperFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLRewritingHttpServletResponse
extends HttpServletResponseWrapper {
    private static final Log log = LogFactory.getLog(URLRewritingHttpServletResponse.class);
    private HttpServletResponse _response;
    private ServletContext _context;
    private WebappDaoFactory wadf;
    private int contextPathDepth;
    private Pattern slashPattern = Pattern.compile("/");

    public URLRewritingHttpServletResponse(HttpServletResponse response, HttpServletRequest request, ServletContext context) {
        super(response);
        this._response = response;
        this._context = context;
        this.wadf = ModelAccess.on(context).getWebappDaoFactory();
        this.contextPathDepth = this.slashPattern.split(request.getContextPath()).length - 1;
    }

    protected URLRewritingHttpServletResponse(HttpServletResponse res) {
        super(res);
    }

    public String encodeRedirectUrl(String arg0) {
        return this._response.encodeRedirectUrl(arg0);
    }

    public String encodeRedirectURL(String arg0) {
        return this._response.encodeRedirectURL(arg0);
    }

    public String encodeUrl(String arg0) {
        return this._response.encodeUrl(arg0);
    }

    public String encodeURL(String inUrl) {
        List<String> externallyLinkedNamespaces = this.wadf.getApplicationDao().getExternallyLinkedNamespaces();
        NamespaceMapper nsMap = NamespaceMapperFactory.getNamespaceMapper(this._context);
        if (log.isDebugEnabled()) {
            log.debug((Object)"START");
            log.debug((Object)("charEncoding: " + this.getCharacterEncoding()));
            log.debug((Object)("contextPathDepth," + this.contextPathDepth));
            log.debug((Object)("nsMap," + nsMap));
            log.debug((Object)("wadf.getDefaultNamespace(), " + this.wadf.getDefaultNamespace()));
            log.debug((Object)("externallyLinkedNamespaces " + externallyLinkedNamespaces));
            log.debug((Object)inUrl);
        }
        String encodedUrl = this.encodeForVitro(inUrl, this.getCharacterEncoding(), true, this.contextPathDepth, nsMap, this.wadf.getDefaultNamespace(), externallyLinkedNamespaces);
        log.debug((Object)encodedUrl);
        log.debug((Object)"END");
        return encodedUrl;
    }

    protected String encodeForVitro(String inUrl, String characterEncoding, Boolean isSInglePortal, int contextPathDepth, NamespaceMapper nsMap, String defaultNamespace, List<String> externalNamespaces) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Incoming URL '" + inUrl + "'"));
            }
            VitroURL url = new VitroURL(inUrl, characterEncoding);
            if (url.host != null) {
                String rv = inUrl;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Encoded as  '" + rv + "'"));
                }
                return rv;
            }
            if ("entity".equals(url.pathParts.get(url.pathParts.size() - 1))) {
                url.pathParts.set(url.pathParts.size() - 1, "individual");
            }
            if ("individual".equals(url.pathParts.get(url.pathParts.size() - 1))) {
                Iterator<String[]> qpIt = url.queryParams.iterator();
                int qpIndex = -1;
                int indexToRemove = -1;
                while (qpIt.hasNext()) {
                    String[] keyAndValue = qpIt.next();
                    ++qpIndex;
                    if (!"uri".equals(keyAndValue[0]) || keyAndValue.length <= 1 || keyAndValue[1] == null) continue;
                    try {
                        IndividualImpl uri = new IndividualImpl(keyAndValue[1]);
                        String namespace = uri.getNamespace();
                        String localName = uri.getLocalName();
                        if (namespace == null || localName == null) continue;
                        String prefix = nsMap.getPrefixForNamespace(namespace);
                        if (defaultNamespace.equals(namespace) && prefix == null) {
                            url.pathParts.add(localName);
                            indexToRemove = qpIndex;
                            continue;
                        }
                        if (this.isExternallyLinkedNamespace(namespace, externalNamespaces)) {
                            log.debug((Object)("Found externally linked namespace " + namespace));
                            url.pathParts = new ArrayList<String>();
                            url.pathParts.add(namespace.replaceAll("/$", ""));
                            url.pathParts.add(localName);
                            indexToRemove = qpIndex;
                            url.protocol = null;
                            url.host = null;
                            url.port = null;
                            url.pathBeginsWithSlash = false;
                            continue;
                        }
                        if (prefix == null) continue;
                        url.pathParts.add(prefix);
                        url.pathParts.add(localName);
                        indexToRemove = qpIndex;
                    }
                    catch (Exception e) {
                        if (keyAndValue.length > 0) {
                            log.debug((Object)("Invalid URI: '" + keyAndValue[1] + "'"));
                            continue;
                        }
                        log.debug((Object)"empty URI");
                    }
                }
                if (indexToRemove > -1) {
                    url.queryParams.remove(indexToRemove);
                }
            }
            String rv = url.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Encoded as  '" + rv + "'"));
            }
            return rv;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            String rv = inUrl;
            log.error((Object)("Encoded as  '" + rv + "'"));
            return rv;
        }
    }

    private boolean isExternallyLinkedNamespace(String namespace, List<String> externallyLinkedNamespaces) {
        return externallyLinkedNamespaces.contains(namespace);
    }
}

