/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.freemarker.config;

import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerConfigurationImpl
extends Configuration {
    private static final Log log = LogFactory.getLog(FreemarkerConfigurationImpl.class);
    private static final String ATTRIBUTE_NAME = RequestBasedInformation.class.getName();
    private final ThreadLocal<WeakReference<HttpServletRequest>> reqRef = new ThreadLocal();

    void setRequestInfo(HttpServletRequest req) {
        this.reqRef.set(new WeakReference<HttpServletRequest>(req));
        req.setAttribute(ATTRIBUTE_NAME, (Object)new RequestBasedInformation(req, this));
    }

    private RequestBasedInformation getRequestInfo() {
        HttpServletRequest req = (HttpServletRequest)this.reqRef.get().get();
        return (RequestBasedInformation)req.getAttribute(ATTRIBUTE_NAME);
    }

    public Object getCustomAttribute(String name) {
        Map<String, Object> attribs = this.getRequestInfo().getCustomAttributes();
        if (attribs.containsKey(name)) {
            return attribs.get(name);
        }
        return super.getCustomAttribute(name);
    }

    public String[] getCustomAttributeNames() {
        Set<String> rbiNames = this.getRequestInfo().getCustomAttributes().keySet();
        return this.joinNames(rbiNames, super.getCustomAttributeNames());
    }

    public TemplateModel getSharedVariable(String name) {
        Map<String, TemplateModel> vars = this.getRequestInfo().getSharedVariables();
        if (vars.containsKey(name)) {
            return vars.get(name);
        }
        return super.getSharedVariable(name);
    }

    public Set<String> getSharedVariableNames() {
        Set<String> rbiNames = this.getRequestInfo().getSharedVariables().keySet();
        Set superNames = super.getSharedVariableNames();
        HashSet<String> allNames = new HashSet<String>(superNames);
        allNames.addAll(rbiNames);
        return allNames;
    }

    public Locale getLocale() {
        return this.getRequestInfo().getReq().getLocale();
    }

    private String[] joinNames(Set<String> nameSet, String[] nameArray) {
        HashSet<String> allNames = new HashSet<String>(nameSet);
        for (String n : nameArray) {
            allNames.add(n);
        }
        return (String[])allNames.toArray();
    }

    public Template getTemplate(String name, Locale locale, Object customLookupCondition, String encoding, boolean parseAsFTL, boolean ignoreMissing) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        Template template = super.getTemplate(name, locale, customLookupCondition, encoding, parseAsFTL, ignoreMissing);
        if (template == null) {
            log.debug((Object)("Template '" + name + "' not found for locale '" + locale + "'."));
            return template;
        }
        Environment env = this.getEnvironment();
        if (env == null) {
            log.debug((Object)("Not fetching data getters for template '" + template.getName() + "'. No environment."));
            return template;
        }
        FreemarkerConfigurationImpl.retrieveAndRunDataGetters(env, template.getName());
        return template;
    }

    public static void retrieveAndRunDataGetters(Environment env, String templateName) {
        HttpServletRequest req = (HttpServletRequest)env.getCustomAttribute("request");
        VitroRequest vreq = new VitroRequest(req);
        if (FreemarkerConfigurationImpl.dataGettersAlreadyApplied(env, templateName)) {
            log.debug((Object)("DataGetters for '" + templateName + "' have already been applied"));
            return;
        }
        try {
            List<DataGetter> dgList = DataGetterUtils.getDataGettersForTemplate(vreq, (Model)vreq.getDisplayModel(), templateName);
            log.debug((Object)("Retrieved " + dgList.size() + " data getters for template '" + templateName + "'"));
            Map dataMap = (Map)DeepUnwrap.permissiveUnwrap((TemplateModel)env.getDataModel());
            for (DataGetter dg : dgList) {
                FreemarkerConfigurationImpl.applyDataGetter(dg, env, dataMap);
            }
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    private static boolean dataGettersAlreadyApplied(Environment env, String templateName) {
        Object o = env.getCustomAttribute("dataGettersApplied");
        HashSet<String> names = o instanceof Set ? (HashSet<String>)o : new HashSet<String>();
        boolean added = names.add(templateName);
        if (added) {
            env.setCustomAttribute("dataGettersApplied", names);
            return false;
        }
        return true;
    }

    private static void applyDataGetter(DataGetter dg, Environment env, Map<String, Object> dataMap) throws TemplateModelException {
        Map<String, Object> moreData = dg.getData(dataMap);
        ObjectWrapper wrapper = env.getObjectWrapper();
        if (moreData != null) {
            for (String key : moreData.keySet()) {
                Object value = moreData.get(key);
                env.setGlobalVariable(key, wrapper.wrap(value));
                log.debug((Object)("Stored in environment: '" + key + "' = '" + value + "'"));
            }
        }
    }

    private static class RequestBasedInformation {
        private final HttpServletRequest req;
        private final Configuration c;
        private final Map<String, Object> customAttributes = new HashMap<String, Object>();
        private final Map<String, TemplateModel> sharedVariables = new HashMap<String, TemplateModel>();

        public RequestBasedInformation(HttpServletRequest req, Configuration c) {
            this.req = req;
            this.c = c;
            this.setSharedVariables(req);
            this.setCustomAttributes(req);
        }

        public HttpServletRequest getReq() {
            return this.req;
        }

        public Map<String, Object> getCustomAttributes() {
            return this.customAttributes;
        }

        public Map<String, TemplateModel> getSharedVariables() {
            return this.sharedVariables;
        }

        private void setSharedVariables(HttpServletRequest req) {
            ServletContext ctx = req.getSession().getServletContext();
            VitroRequest vreq = new VitroRequest(req);
            ApplicationBean appBean = vreq.getAppBean();
            String siteName = appBean.getApplicationName();
            String tagLine = appBean.getShortHand();
            String themeDir = appBean.getThemeDir().replaceAll("/$", "");
            String currentTheme = themeDir.substring(themeDir.lastIndexOf(47) + 1);
            Map<String, String> siteUrls = this.getSiteUrls(ctx, themeDir);
            this.sharedVariables.put("siteName", this.wrap(siteName));
            this.sharedVariables.put("themeDir", this.wrap(themeDir));
            this.sharedVariables.put("currentTheme", this.wrap(currentTheme));
            this.sharedVariables.put("siteTagline", this.wrap(tagLine));
            this.sharedVariables.put("urls", this.wrap(siteUrls));
        }

        private Map<String, String> getSiteUrls(ServletContext ctx, String themeDir) {
            HashMap<String, String> urls = new HashMap<String, String>();
            urls.put("base", ctx.getContextPath());
            urls.put("home", UrlBuilder.getHomeUrl());
            urls.put("about", UrlBuilder.getUrl(UrlBuilder.Route.ABOUT));
            urls.put("search", UrlBuilder.getUrl(UrlBuilder.Route.SEARCH));
            urls.put("termsOfUse", UrlBuilder.getUrl(UrlBuilder.Route.TERMS_OF_USE));
            urls.put("login", UrlBuilder.getLoginUrl());
            urls.put("logout", UrlBuilder.getLogoutUrl());
            urls.put("siteAdmin", UrlBuilder.getUrl(UrlBuilder.Route.SITE_ADMIN));
            urls.put("themeImages", UrlBuilder.getUrl(themeDir + "/images"));
            urls.put("images", UrlBuilder.getUrl("/images"));
            urls.put("theme", UrlBuilder.getUrl(themeDir));
            urls.put("index", UrlBuilder.getUrl("/browse"));
            urls.put("developerAjax", UrlBuilder.getUrl("/admin/developerAjax"));
            return urls;
        }

        private TemplateModel wrap(Object o) {
            try {
                return this.c.getObjectWrapper().wrap(o);
            }
            catch (TemplateModelException e) {
                log.error((Object)("Failed to wrap this for the Freemarker configuration: " + o), (Throwable)e);
                return new SimpleScalar(String.valueOf(o));
            }
        }

        private void setCustomAttributes(HttpServletRequest req) {
            this.customAttributes.put("request", req);
        }
    }
}

