/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.freemarker.loader;

import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerTemplateLoader
implements TemplateLoader {
    private static final Log log = LogFactory.getLog(FreemarkerTemplateLoader.class);
    private final File baseDir;

    public FreemarkerTemplateLoader(File baseDir) {
        if (baseDir == null) {
            throw new NullPointerException("baseDir may not be null.");
        }
        String path = baseDir.getAbsolutePath();
        if (!baseDir.exists()) {
            throw new IllegalArgumentException("Template directory '" + path + "' does not exist");
        }
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("Template directory '" + path + "' is not a directory");
        }
        if (!baseDir.canRead()) {
            throw new IllegalArgumentException("Can't read template directory '" + path + "'");
        }
        log.debug((Object)("Created template loader - baseDir is '" + path + "'"));
        this.baseDir = baseDir;
    }

    public Object findTemplateSource(String name) throws IOException {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        SortedSet<PathPieces> matches = this.findAllMatches(new PathPieces(name));
        if (matches.isEmpty()) {
            return null;
        }
        return matches.last().path.toFile();
    }

    private SortedSet<PathPieces> findAllMatches(PathPieces searchTerm) {
        PathPiecesFileVisitor visitor = new PathPiecesFileVisitor(searchTerm);
        try {
            Files.walkFileTree(this.baseDir.toPath(), visitor);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return visitor.getMatches();
    }

    public long getLastModified(Object templateSource) {
        return this.asFile(templateSource).lastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return new FileReader(this.asFile(templateSource));
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    private File asFile(Object templateSource) {
        if (templateSource instanceof File) {
            return (File)templateSource;
        }
        throw new IllegalArgumentException("templateSource is not a File: " + templateSource);
    }

    static class PathPiecesComparator
    implements Comparator<PathPieces> {
        private final PathPieces searchFor;

        public PathPiecesComparator(PathPieces searchFor) {
            this.searchFor = searchFor;
        }

        @Override
        public int compare(PathPieces p1, PathPieces p2) {
            int scoring = this.searchFor.score(p1) - this.searchFor.score(p2);
            if (scoring != 0) {
                return scoring;
            }
            int pathLength = p1.path.getNameCount() - p2.path.getNameCount();
            if (pathLength != 0) {
                return -pathLength;
            }
            return -p1.path.compareTo(p2.path);
        }
    }

    static class PathPiecesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final PathPieces searchTerm;
        private final SortedSet<PathPieces> matches;

        public PathPiecesFileVisitor(PathPieces searchTerm) {
            this.searchTerm = searchTerm;
            this.matches = new TreeSet<PathPieces>(new PathPiecesComparator(searchTerm));
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            PathPieces found;
            if (this.fileQualifies(path) && this.searchTerm.matches(found = new PathPieces(path))) {
                this.matches.add(found);
            }
            return FileVisitResult.CONTINUE;
        }

        public boolean fileQualifies(Path path) {
            return !Files.isDirectory(path, new LinkOption[0]);
        }

        public SortedSet<PathPieces> getMatches() {
            return this.matches;
        }
    }

    static class PathPieces {
        static final Pattern PATTERN = Pattern.compile("(.+?)(_[a-z]{2})?(_[A-Z]{2})?(\\.\\w+)?");
        final Path path;
        final String base;
        final String language;
        final String region;
        final String extension;

        public PathPieces(String pathString) {
            this(Paths.get(pathString, new String[0]));
        }

        public PathPieces(Path path) {
            this.path = path;
            String filename = path.getFileName().toString();
            Matcher m = PATTERN.matcher(filename);
            if (m.matches()) {
                this.base = this.getGroup(m, 1);
                this.language = this.getGroup(m, 2);
                this.region = this.getGroup(m, 3);
                this.extension = this.getGroup(m, 4);
            } else {
                this.base = filename;
                this.language = "";
                this.region = "";
                this.extension = "";
            }
        }

        private String getGroup(Matcher m, int i) {
            return m.start(i) == -1 ? "" : m.group(i);
        }

        public boolean matches(PathPieces that) {
            return !(!this.base.equals(that.base) || !this.extension.equals(that.extension) || !this.language.isEmpty() && !this.language.equals(that.language) || !this.region.isEmpty() && !this.region.equals(that.region));
        }

        public int score(PathPieces that) {
            if (this.matches(that)) {
                if (that.language.equals(this.language)) {
                    if (that.region.equals(this.region)) {
                        return 3;
                    }
                    return 2;
                }
                return 1;
            }
            return -1;
        }

        public String toString() {
            return "PathPieces[" + this.base + ", " + this.language + ", " + this.region + ", " + this.extension + "]";
        }
    }
}

