/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.selection;

import edu.cornell.mannlib.vitro.webapp.beans.DisplayMessage;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleSelectionController
extends HttpServlet {
    private static final Log log = LogFactory.getLog(LocaleSelectionController.class);
    public static final String PARAMETER_SELECTION = "selection";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String referrer = req.getHeader("referer");
        String selectedLocale = req.getParameter(PARAMETER_SELECTION);
        try {
            this.processSelectedLocale(req, selectedLocale);
        }
        catch (Exception e) {
            log.error((Object)"Failed to process the user's Locale selection", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)referrer)) {
            resp.sendRedirect(UrlBuilder.getHomeUrl());
        } else {
            resp.sendRedirect(referrer);
        }
    }

    private void processSelectedLocale(HttpServletRequest req, String selectedLocale) {
        if (StringUtils.isBlank((String)selectedLocale)) {
            log.debug((Object)"No 'selection' parameter");
            return;
        }
        Locale locale = null;
        try {
            locale = LocaleUtils.toLocale((String)selectedLocale.trim());
            log.debug((Object)("Locale selection is " + locale));
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Failed to convert the selection to a Locale", (Throwable)e);
            DisplayMessage.setMessage(req, I18n.bundle(req).text("language_selection_failed", new Object[0]));
            return;
        }
        List<Locale> selectables = SelectedLocale.getSelectableLocales(req);
        if (!selectables.contains(locale)) {
            log.warn((Object)("User selected a locale '" + locale + "' that was not in the list: " + selectables));
        } else if (!LocaleUtils.isAvailableLocale((Locale)locale)) {
            log.warn((Object)("User selected an unrecognized locale: '" + locale + "'"));
        }
        SelectedLocale.setSelectedLocale(req, locale);
        log.debug((Object)("Setting selected locale to " + locale));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

