/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.imageprocessor.jai;

import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.imageProcessor.ImageProcessor;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.StreamDescriptor;
import javax.media.jai.util.ImagingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JaiImageProcessor
implements ImageProcessor {
    private static final Log log = LogFactory.getLog(JaiImageProcessor.class);
    private static final int[] COLOR_BAND_INDEXES = new int[]{0, 1, 2};

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        JAI.getDefaultInstance().setImagingListener((ImagingListener)new NonNoisyImagingListener());
    }

    @Override
    public void shutdown(Application application) {
    }

    @Override
    public ImageProcessor.Dimensions getDimensions(InputStream imageStream) throws ImageProcessor.ImageProcessorException, IOException {
        MemoryCacheSeekableStream stream = new MemoryCacheSeekableStream(imageStream);
        RenderedOp image = JAI.create((String)"stream", (Object)stream);
        return new ImageProcessor.Dimensions(image.getWidth(), image.getHeight());
    }

    @Override
    public InputStream cropAndScale(InputStream mainImageStream, ImageProcessor.CropRectangle crop, ImageProcessor.Dimensions limits) throws ImageProcessor.ImageProcessorException, IOException {
        try {
            RenderedOp mainImage = this.loadImage(mainImageStream);
            BufferedImage bufferedImage = new BufferedImage(mainImage.getWidth(), mainImage.getHeight(), 5);
            new ColorConvertOp(null).filter(mainImage.getAsBufferedImage(), bufferedImage);
            log.debug((Object)("initial image: " + this.imageSize(bufferedImage)));
            log.debug((Object)("initial crop: " + crop));
            ImageProcessor.CropRectangle boundedCrop = this.limitCropRectangleToImageBounds(bufferedImage, crop);
            log.debug((Object)("bounded crop: " + boundedCrop));
            float scaleFactor = this.figureScaleFactor(boundedCrop, limits);
            log.debug((Object)("scale factor: " + scaleFactor));
            BufferedImage scaledImage = this.scaleImage(bufferedImage, scaleFactor);
            log.debug((Object)("scaled image: " + this.imageSize(scaledImage)));
            ImageProcessor.CropRectangle rawScaledCrop = this.adjustCropRectangleToScaledImage(boundedCrop, scaleFactor);
            log.debug((Object)("scaled crop: " + rawScaledCrop));
            ImageProcessor.CropRectangle scaledCrop = this.limitCropRectangleToImageBounds(scaledImage, rawScaledCrop);
            log.debug((Object)("bounded scaled crop: " + scaledCrop));
            BufferedImage croppedImage = this.cropImage(scaledImage, scaledCrop);
            log.debug((Object)("cropped image: " + this.imageSize(croppedImage)));
            byte[] jpegBytes = this.encodeAsJpeg(croppedImage);
            return new ByteArrayInputStream(jpegBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to scale the image", e);
        }
    }

    private RenderedOp loadImage(InputStream imageStream) {
        return StreamDescriptor.create((SeekableStream)new MemoryCacheSeekableStream(imageStream), null, null);
    }

    private RenderedOp makeImageOpaque(RenderedOp image) {
        ColorModel colorModel = image.getColorModel();
        if (!colorModel.hasAlpha()) {
            return image;
        }
        if (image.getNumBands() == 4) {
            return BandSelectDescriptor.create((RenderedImage)image, (int[])COLOR_BAND_INDEXES, null);
        }
        return image;
    }

    private String imageSize(BufferedImage image) {
        return image.getWidth() + " by " + image.getHeight();
    }

    private ImageProcessor.CropRectangle limitCropRectangleToImageBounds(BufferedImage image, ImageProcessor.CropRectangle crop) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int greatestX = imageWidth - 5;
        int greatestY = imageHeight - 5;
        int x = Math.max(0, Math.min(greatestX, Math.abs(crop.x)));
        int y = Math.max(0, Math.min(greatestY, Math.abs(crop.y)));
        int greatestW = imageWidth - x;
        int greatestH = imageHeight - y;
        int w = Math.max(5, Math.min(greatestW, crop.width));
        int h = Math.max(5, Math.min(greatestH, crop.height));
        return new ImageProcessor.CropRectangle(x, y, h, w);
    }

    private float figureScaleFactor(ImageProcessor.CropRectangle boundedCrop, ImageProcessor.Dimensions limits) {
        float horizontalScale = (float)limits.width / (float)boundedCrop.width;
        float verticalScale = (float)limits.height / (float)boundedCrop.height;
        return Math.min(horizontalScale, verticalScale);
    }

    private BufferedImage scaleImage(BufferedImage image, float scaleFactor) {
        AffineTransform transform = AffineTransform.getScaleInstance(scaleFactor, scaleFactor);
        AffineTransformOp atoOp = new AffineTransformOp(transform, null);
        return atoOp.filter(image, null);
    }

    private ImageProcessor.CropRectangle adjustCropRectangleToScaledImage(ImageProcessor.CropRectangle crop, float scaleFactor) {
        int newX = (int)((float)crop.x * scaleFactor);
        int newY = (int)((float)crop.y * scaleFactor);
        int newHeight = (int)((float)crop.height * scaleFactor);
        int newWidth = (int)((float)crop.width * scaleFactor);
        return new ImageProcessor.CropRectangle(newX, newY, newHeight, newWidth);
    }

    private BufferedImage cropImage(BufferedImage image, ImageProcessor.CropRectangle crop) {
        return image.getSubimage(crop.x, crop.y, crop.width, crop.height);
    }

    private byte[] encodeAsJpeg(BufferedImage image) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "JPG", bytes);
        return bytes.toByteArray();
    }

    static class NonNoisyImagingListener
    implements ImagingListener {
        NonNoisyImagingListener() {
        }

        public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
            if (thrown instanceof RuntimeException) {
                throw (RuntimeException)thrown;
            }
            if (thrown instanceof NoClassDefFoundError && thrown.getMessage().contains("com/sun/medialib/mlib/Image")) {
                log.info((Object)"Java Advanced Imaging: Could not find mediaLib accelerator wrapper classes. Continuing in pure Java mode.");
                return false;
            }
            log.error((Object)thrown, thrown);
            return false;
        }
    }
}

