/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.rel18;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.RDFServiceJena;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class RemoveObsoleteMetadataGraphs {
    private static final String OBSOLETE_METADATA_MODEL = "http://vitro.mannlib.cornell.edu/ns/vitro/sdb/metadata";
    private final ServletContext ctx;
    private final ServletContextListener parent;

    public RemoveObsoleteMetadataGraphs(ServletContext ctx, ServletContextListener parent) {
        this.ctx = ctx;
        this.parent = parent;
    }

    public void migrate() {
        StartupStatus ss = StartupStatus.getBean(this.ctx);
        this.removeMetadataModel(this.ctx, ss, ModelAccess.WhichService.CONTENT);
        this.removeMetadataModel(this.ctx, ss, ModelAccess.WhichService.CONFIGURATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMetadataModel(ServletContext ctx, StartupStatus ss, ModelAccess.WhichService which) {
        Logger rdfServiceLogger = Logger.getLogger(RDFServiceJena.class);
        Level rdfServiceLogLevel = rdfServiceLogger.getLevel();
        rdfServiceLogger.setLevel(Level.ERROR);
        try {
            ModelAccess.on(ctx).getModelMaker(which).removeModel(OBSOLETE_METADATA_MODEL);
        }
        catch (Exception e) {
            ss.warning(this.parent, "Failed to remove 'http://vitro.mannlib.cornell.edu/ns/vitro/sdb/metadata' from " + which, e);
        }
        finally {
            rdfServiceLogger.setLevel(rdfServiceLogLevel);
        }
    }
}

