/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.impl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryConfig;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.WebappDaoFactoryFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.HideFromDisplayByPolicyFilter;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelectorImpl;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactorySDB;
import edu.cornell.mannlib.vitro.webapp.filters.ModelSwitcher;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.RequestModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys.DatasetKey;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys.OntModelKey;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys.OntModelSelectorKey;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys.RDFServiceKey;
import edu.cornell.mannlib.vitro.webapp.modelaccess.impl.keys.WebappDaoFactoryKey;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringRDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringUtils;
import edu.cornell.mannlib.vitro.webapp.triplesource.ShortTermCombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestModelAccessImpl
implements RequestModelAccess {
    private static final Log log = LogFactory.getLog(RequestModelAccessImpl.class);
    private final HttpServletRequest req;
    private final ServletContext ctx;
    private final ConfigurationProperties props;
    private final ShortTermCombinedTripleSource source;
    private final Map<RDFServiceKey, RDFService> rdfServiceMap = new HashMap<RDFServiceKey, RDFService>();
    private final Map<DatasetKey, Dataset> datasetMap = new HashMap<DatasetKey, Dataset>();
    private final Map<OntModelKey, OntModel> ontModelMap = new HashMap<OntModelKey, OntModel>();
    private final Map<OntModelSelectorKey, OntModelSelector> ontModelSelectorMap = new HashMap<OntModelSelectorKey, OntModelSelector>();
    private final Map<WebappDaoFactoryKey, WebappDaoFactory> wadfMap = new HashMap<WebappDaoFactoryKey, WebappDaoFactory>();

    public RequestModelAccessImpl(HttpServletRequest req, ShortTermCombinedTripleSource source) {
        this.req = req;
        this.ctx = req.getSession().getServletContext();
        this.props = ConfigurationProperties.getBean((ServletRequest)req);
        this.source = source;
    }

    private Boolean isLanguageAwarenessEnabled() {
        return Boolean.valueOf(this.props.getProperty("RDFService.languageFilter", "false"));
    }

    private List<String> getPreferredLanguages() {
        return LanguageFilteringUtils.localesToLanguages(this.req.getLocales());
    }

    @Override
    public void close() {
        this.source.close();
    }

    public String toString() {
        return "RequestModelAccessImpl[" + ToString.hashHex(this) + ", req=" + ToString.hashHex(this.req) + ", source=" + this.source + "]";
    }

    @Override
    public RDFService getRDFService(ModelAccess.RdfServiceOption ... options) {
        return this.getRDFService(new RDFServiceKey(options));
    }

    private RDFService getRDFService(RDFServiceKey key) {
        RDFService rdfService;
        if (!this.rdfServiceMap.containsKey(key)) {
            rdfService = this.createRDFService(key);
            log.debug((Object)("Creating:   " + key + ", request=" + this.req.hashCode() + ", " + rdfService));
            this.rdfServiceMap.put(key, rdfService);
        }
        rdfService = this.rdfServiceMap.get(key);
        log.debug((Object)("getRDFService, " + key + ": " + rdfService));
        return rdfService;
    }

    private RDFService createRDFService(RDFServiceKey key) {
        if (key.getLanguageOption() == ModelAccess.LanguageOption.LANGUAGE_AWARE) {
            return this.addLanguageAwareness(this.getRDFService(ModelAccess.LanguageOption.LANGUAGE_NEUTRAL));
        }
        return this.source.getRDFService(key.getWhichService());
    }

    private RDFService addLanguageAwareness(RDFService unaware) {
        if (this.isLanguageAwarenessEnabled().booleanValue()) {
            return new LanguageFilteringRDFService(unaware, this.getPreferredLanguages());
        }
        return unaware;
    }

    @Override
    public Dataset getDataset(ModelAccess.DatasetOption ... options) {
        return this.getDataset(new DatasetKey(options));
    }

    private Dataset getDataset(DatasetKey key) {
        Dataset dataset;
        if (!this.datasetMap.containsKey(key)) {
            dataset = this.createDataset(key);
            log.debug((Object)("Creating:   " + key + ", request=" + this.req.hashCode() + ", " + dataset));
            this.datasetMap.put(key, dataset);
        }
        dataset = this.datasetMap.get(key);
        log.debug((Object)("getDataset, " + key + ": " + dataset));
        return dataset;
    }

    private Dataset createDataset(DatasetKey key) {
        return new RDFServiceDataset(this.getRDFService(key.rdfServiceKey()));
    }

    @Override
    public OntModel getOntModel(ModelAccess.LanguageOption ... options) {
        return this.getOntModel("vitro:jenaOntModel", options);
    }

    @Override
    public OntModel getOntModel(String name, ModelAccess.LanguageOption ... options) {
        return this.getOntModel(new OntModelKey(name, options));
    }

    private OntModel getOntModel(OntModelKey key) {
        String ontModelStr;
        OntModel ontModel;
        if (!this.ontModelMap.containsKey(key)) {
            ontModel = this.createOntModel(key);
            if (log.isDebugEnabled()) {
                ontModelStr = ToString.ontModelToString(ontModel);
                log.debug((Object)("Creating:   " + key + ", request=" + this.req.hashCode() + ", " + ontModelStr));
            }
            this.ontModelMap.put(key, ontModel);
        }
        ontModel = this.ontModelMap.get(key);
        if (log.isDebugEnabled()) {
            ontModelStr = ToString.ontModelToString(ontModel);
            log.debug((Object)("getOntModel, " + key + ": " + ontModelStr));
        }
        return ontModel;
    }

    private OntModel createOntModel(OntModelKey key) {
        if (key.getLanguageOption() == ModelAccess.LanguageOption.LANGUAGE_AWARE) {
            return this.addLanguageAwareness(this.getOntModel(key.getName(), ModelAccess.LanguageOption.LANGUAGE_NEUTRAL));
        }
        return this.source.getOntModelCache().getOntModel(key.getName());
    }

    private OntModel addLanguageAwareness(OntModel unaware) {
        if (this.isLanguageAwarenessEnabled().booleanValue()) {
            return LanguageFilteringUtils.wrapOntModelInALanguageFilter(unaware, (ServletRequest)this.req);
        }
        return unaware;
    }

    public void setSpecialWriteModel(OntModel mainOntModel) {
        this.ontModelMap.put(new OntModelKey("vitro:jenaOntModel", new ModelAccess.LanguageOption[0]), mainOntModel);
    }

    @Override
    public OntModelSelector getOntModelSelector(ModelAccess.OntModelSelectorOption ... options) {
        return this.getOntModelSelector(new OntModelSelectorKey(options));
    }

    private OntModelSelector getOntModelSelector(OntModelSelectorKey key) {
        if (!this.ontModelSelectorMap.containsKey(key)) {
            OntModelSelector oms = this.createOntModelSelector(key);
            log.debug((Object)("Creating:   " + key + ", request=" + this.req.hashCode() + ", " + oms));
            this.ontModelSelectorMap.put(key, oms);
        }
        OntModelSelector ontModelSelector = this.ontModelSelectorMap.get(key);
        log.debug((Object)("getOntModelSelector, " + key + ": " + ontModelSelector));
        return ontModelSelector;
    }

    private OntModelSelector createOntModelSelector(OntModelSelectorKey key) {
        OntModelSelectorImpl oms = new OntModelSelectorImpl();
        oms.setABoxModel(this.getOntModel(key.aboxKey()));
        oms.setTBoxModel(this.getOntModel(key.tboxKey()));
        oms.setFullModel(this.getOntModel(key.fullKey()));
        oms.setApplicationMetadataModel(this.getOntModel(key.ontModelKey("http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata")));
        oms.setDisplayModel(this.getOntModel(key.ontModelKey("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata")));
        oms.setUserAccountsModel(this.getOntModel(key.ontModelKey("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts")));
        return oms;
    }

    @Override
    public WebappDaoFactory getWebappDaoFactory(ModelAccess.WebappDaoFactoryOption ... options) {
        return this.getWebappDaoFactory(new WebappDaoFactoryKey(options));
    }

    private WebappDaoFactory getWebappDaoFactory(WebappDaoFactoryKey key) {
        WebappDaoFactory wadf;
        if (!this.wadfMap.containsKey(key)) {
            wadf = this.createWebappDaoFactory(key);
            log.debug((Object)("Creating:   " + key + ", request=" + this.req.hashCode() + ", " + wadf));
            this.wadfMap.put(key, wadf);
        }
        wadf = this.wadfMap.get(key);
        log.debug((Object)("getWebappDaoFactory, " + key + ": " + wadf));
        return wadf;
    }

    private WebappDaoFactory createWebappDaoFactory(WebappDaoFactoryKey key) {
        if (key.getPolicyOption() == ModelAccess.PolicyOption.POLICY_AWARE) {
            return this.addPolicyAwareness(this.getWebappDaoFactory(key.policyNeutral()));
        }
        RDFService rdfService = this.getRDFService(key.rdfServiceKey());
        OntModelSelector ontModelSelector = this.getOntModelSelector(key.ontModelSelectorKey());
        WebappDaoFactoryConfig config = this.source.getWebappDaoFactoryConfig();
        switch (key.getReasoningOption()) {
            case ASSERTIONS_ONLY: {
                return new WebappDaoFactorySDB(rdfService, ontModelSelector, config, WebappDaoFactorySDB.SDBDatasetMode.ASSERTIONS_ONLY);
            }
            case INFERENCES_ONLY: {
                return new WebappDaoFactorySDB(rdfService, ontModelSelector, config, WebappDaoFactorySDB.SDBDatasetMode.INFERENCES_ONLY);
            }
        }
        WebappDaoFactorySDB unswitched = new WebappDaoFactorySDB(rdfService, ontModelSelector, config);
        return new ModelSwitcher().checkForModelSwitching(new VitroRequest(this.req), unswitched);
    }

    private WebappDaoFactory addPolicyAwareness(WebappDaoFactory unaware) {
        HideFromDisplayByPolicyFilter filter = new HideFromDisplayByPolicyFilter(RequestIdentifiers.getIdBundleForRequest((ServletRequest)this.req), ServletPolicyList.getPolicies(this.ctx));
        return new WebappDaoFactoryFiltering(unaware, filter);
    }
}

