/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels;

import com.hp.hpl.jena.ontology.OntModel;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MaskingOntModelCache
implements OntModelCache {
    private static final Log log = LogFactory.getLog(MaskingOntModelCache.class);
    private final OntModelCache baseCache;
    private final OntModelCache maskingCache;
    private final Set<String> maskingNames;

    public MaskingOntModelCache(OntModelCache baseCache, OntModelCache maskingCache, Collection<String> maskingNames) {
        this.baseCache = baseCache;
        this.maskingCache = maskingCache;
        this.maskingNames = new HashSet<String>(maskingNames);
        this.checkForMissingNamedModels();
    }

    private void checkForMissingNamedModels() {
        HashSet<String> missingModelNames = new HashSet<String>(this.maskingNames);
        missingModelNames.removeAll(this.maskingCache.getModelNames());
        if (!missingModelNames.isEmpty()) {
            log.warn((Object)("Specifed models do not exist in the masking cache: " + missingModelNames));
            this.maskingNames.removeAll(missingModelNames);
        }
    }

    @Override
    public OntModel getOntModel(String name) {
        if (this.maskingNames.contains(name)) {
            return this.maskingCache.getOntModel(name);
        }
        return this.baseCache.getOntModel(name);
    }

    @Override
    public SortedSet<String> getModelNames() {
        TreeSet<String> allNames = new TreeSet<String>(this.baseCache.getModelNames());
        allNames.addAll(this.maskingNames);
        return allNames;
    }

    public String toString() {
        return "MaskingOntModelCache[" + ToString.hashHex(this) + ", baseCache=" + this.baseCache + ", maskingCache=" + this.maskingCache + ", maskingNames=" + this.maskingNames + "]";
    }
}

