/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.ontology.update;

import edu.cornell.mannlib.vitro.webapp.ontology.update.AtomicOntologyChange;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.skife.csv.SimpleReader;

public class OntologyChangeParser {
    private final Log log = LogFactory.getLog(OntologyChangeParser.class);
    private ChangeLogger logger;

    public OntologyChangeParser(ChangeLogger logger) {
        this.logger = logger;
    }

    public ArrayList<AtomicOntologyChange> parseFile(String diffPath) throws IOException {
        ArrayList<AtomicOntologyChange> changeObjects = new ArrayList<AtomicOntologyChange>();
        boolean countColumns = false;
        Object URI2 = null;
        Object rename = null;
        Object sourceURI = null;
        Object destinationURI = null;
        Object stArr = null;
        FileInputStream in = new FileInputStream(new File(diffPath));
        SimpleReader readFile = new SimpleReader();
        readFile.setSeperator('\t');
        List rows = readFile.parse((InputStream)in);
        for (int rowNum = 0; rowNum < rows.size(); ++rowNum) {
            String[] cols = (String[])rows.get(rowNum);
            if (cols.length != 5) {
                this.logger.logError("Invalid PromptDiff data at row " + (rowNum + 1) + ". Expected 5 columns; found " + cols.length);
                continue;
            }
            AtomicOntologyChange changeObj = new AtomicOntologyChange();
            if (cols[0] != null && cols[0].length() > 0) {
                changeObj.setSourceURI(cols[0]);
            }
            if (cols[1] != null && cols[1].length() > 0) {
                changeObj.setDestinationURI(cols[1]);
            }
            if (cols[4] != null && cols[4].length() > 0) {
                changeObj.setNotes(cols[4]);
            }
            if ("Yes".equals(cols[2])) {
                changeObj.setAtomicChangeType(AtomicOntologyChange.AtomicChangeType.RENAME);
            } else if ("Delete".equals(cols[3])) {
                changeObj.setAtomicChangeType(AtomicOntologyChange.AtomicChangeType.DELETE);
            } else if ("Add".equals(cols[3])) {
                changeObj.setAtomicChangeType(AtomicOntologyChange.AtomicChangeType.ADD);
            } else {
                this.logger.logError("Invalid rename or change type data: '" + cols[2] + " " + cols[3] + "'");
            }
            this.log.debug((Object)changeObj);
            changeObjects.add(changeObj);
        }
        if (changeObjects.size() == 0) {
            this.logger.log("No ABox updates are required.");
        }
        return changeObjects;
    }
}

