/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.WrappedBulkUpdateHandler;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.util.iterator.Map1;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractOntModelDecorator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BulkUpdatingOntModel
extends AbstractOntModelDecorator {
    private static final Log log = LogFactory.getLog(BulkUpdatingOntModel.class);
    private static final RDFReaderF readerFactory = new RDFReaderFImpl();
    private final BulkUpdateHandler buh;
    private Map1<Statement, Triple> mapAsTriple = new Map1<Statement, Triple>(){

        public Triple map1(Statement s) {
            return s.asTriple();
        }
    };

    public BulkUpdatingOntModel(OntModel inner) {
        super(inner);
        this.buh = inner.getGraph().getBulkUpdateHandler();
    }

    private static BulkUpdateHandler getWrappedBulkUpdateHandler(Graph graph) {
        if (graph instanceof GraphWithPerform) {
            return new WrappedBulkUpdateHandler((GraphWithPerform)graph, graph.getBulkUpdateHandler());
        }
        try {
            throw new IllegalStateException();
        }
        catch (IllegalStateException e) {
            log.warn((Object)"Graph is not an instance of GraphWithPerform", (Throwable)e);
            return graph.getBulkUpdateHandler();
        }
    }

    @Override
    public Model add(StmtIterator iter) {
        try {
            this.buh.add(this.asTriples(iter));
        }
        finally {
            iter.close();
        }
        return this;
    }

    @Override
    public Model add(Model m) {
        return this.add(m, false);
    }

    @Override
    @Deprecated
    public Model add(Model m, boolean suppressReifications) {
        this.buh.add(m.getGraph());
        return this;
    }

    @Override
    public Model read(String url) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader().read(m, url);
        this.buh.add(m.getGraph());
        return this;
    }

    @Override
    public Model read(Reader reader, String base) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader().read(m, reader, base);
        this.buh.add(m.getGraph());
        return this;
    }

    @Override
    public Model read(InputStream reader, String base) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader().read(m, reader, base);
        this.buh.add(m.getGraph());
        return this;
    }

    @Override
    public Model read(String url, String lang) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader(lang).read(m, url);
        this.buh.add(m.getGraph());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(String url, String base, String lang) {
        try {
            InputStream is = new URL(url).openStream();
            try {
                this.read(is, base, lang);
            }
            finally {
                if (null != is) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        return this;
    }

    @Override
    public Model read(Reader reader, String base, String lang) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader(lang).read(m, reader, base);
        this.buh.add(m.getGraph());
        return this;
    }

    @Override
    public Model read(InputStream reader, String base, String lang) {
        Model m = ModelFactory.createDefaultModel();
        readerFactory.getReader(lang).read(m, reader, base);
        this.buh.add(m.getGraph());
        return this;
    }

    @Override
    public Model remove(StmtIterator iter) {
        this.buh.delete(this.asTriples(iter));
        return this;
    }

    @Override
    public Model remove(Model m) {
        return this.remove(m, false);
    }

    @Override
    @Deprecated
    public Model remove(Model m, boolean suppressReifications) {
        this.buh.delete(m.getGraph());
        return this;
    }

    @Override
    public Model removeAll() {
        this.buh.removeAll();
        return this;
    }

    @Override
    public Model add(Statement[] statements) {
        this.buh.add(StatementImpl.asTriples((Statement[])statements));
        return this;
    }

    @Override
    public Model add(List<Statement> statements) {
        this.add(statements.toArray(new Statement[statements.size()]));
        return this;
    }

    @Override
    public Model remove(Statement[] statements) {
        this.buh.delete(StatementImpl.asTriples((Statement[])statements));
        return this;
    }

    @Override
    public Model remove(List<Statement> statements) {
        this.remove(statements.toArray(new Statement[statements.size()]));
        return this;
    }

    private Iterator<Triple> asTriples(StmtIterator it) {
        return it.mapWith(this.mapAsTriple);
    }
}

