/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.vocabulary.OWL;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.FilteredResultSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SameAsFilteringRDFServiceFactory
implements RDFServiceFactory {
    private static final Log log = LogFactory.getLog(SameAsFilteringRDFServiceFactory.class);
    private RDFServiceFactory f;
    private Model sameAsModel;

    public SameAsFilteringRDFServiceFactory(RDFServiceFactory rdfServiceFactory) {
        this.f = rdfServiceFactory;
        try {
            InputStream in = this.f.getRDFService().sparqlConstructQuery("CONSTRUCT { ?s <" + OWL.sameAs.getURI() + "> ?o } WHERE { ?s <" + OWL.sameAs.getURI() + "> ?o } ", RDFService.ModelSerializationFormat.N3);
            this.sameAsModel = RDFServiceUtils.parseModel(in, RDFService.ModelSerializationFormat.N3);
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RDFService getRDFService() {
        return new SameAsFilteringRDFService(this.f.getRDFService());
    }

    @Override
    public RDFService getShortTermRDFService() {
        return new SameAsFilteringRDFService(this.f.getShortTermRDFService());
    }

    @Override
    public void registerListener(ChangeListener changeListener) throws RDFServiceException {
        this.f.registerListener(changeListener);
    }

    @Override
    public void unregisterListener(ChangeListener changeListener) throws RDFServiceException {
        this.f.registerListener(changeListener);
    }

    @Override
    public void registerJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.f.registerJenaModelChangedListener(changeListener);
    }

    @Override
    public void unregisterJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.f.registerJenaModelChangedListener(changeListener);
    }

    public class SameAsFilteringRDFService
    extends RDFServiceImpl
    implements RDFService {
        private final Log log = LogFactory.getLog(SameAsFilteringRDFService.class);
        private RDFService s;

        public SameAsFilteringRDFService(RDFService rdfService) {
            this.s = rdfService;
        }

        @Override
        public InputStream sparqlConstructQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
            Model m = RDFServiceUtils.parseModel(this.s.sparqlConstructQuery(query, resultFormat), resultFormat);
            Model filtered = ModelFactory.createDefaultModel();
            StmtIterator stmtIt = m.listStatements();
            while (stmtIt.hasNext()) {
                Statement stmt = stmtIt.nextStatement();
                if (this.isRedundant(stmt)) continue;
                filtered.add(stmt);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            filtered.write((OutputStream)out, RDFServiceUtils.getSerializationFormatString(resultFormat));
            return new ByteArrayInputStream(out.toByteArray());
        }

        @Override
        public void sparqlConstructQuery(String query, Model model) throws RDFServiceException {
            Model m = ModelFactory.createDefaultModel();
            this.s.sparqlConstructQuery(query, m);
            StmtIterator stmtIt = m.listStatements();
            while (stmtIt.hasNext()) {
                Statement stmt = stmtIt.nextStatement();
                if (this.isRedundant(stmt)) continue;
                model.add(stmt);
            }
        }

        @Override
        public InputStream sparqlSelectQuery(String query, RDFService.ResultFormat resultFormat) throws RDFServiceException {
            ResultSet rs = ResultSetFactory.load((InputStream)this.s.sparqlSelectQuery(query, resultFormat), (ResultsFormat)RDFServiceUtils.getJenaResultSetFormat(resultFormat));
            ArrayList<QuerySolution> solutions = new ArrayList<QuerySolution>();
            while (rs.hasNext()) {
                QuerySolution solution = rs.nextSolution();
                if (this.isRedundant(solution)) continue;
                solutions.add(solution);
            }
            FilteredResultSet resultSet = new FilteredResultSet(solutions, rs);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            switch (resultFormat) {
                case CSV: {
                    ResultSetFormatter.outputAsCSV((OutputStream)outputStream, (ResultSet)resultSet);
                    break;
                }
                case TEXT: {
                    ResultSetFormatter.out((OutputStream)outputStream, (ResultSet)resultSet);
                    break;
                }
                case JSON: {
                    ResultSetFormatter.outputAsJSON((OutputStream)outputStream, (ResultSet)resultSet);
                    break;
                }
                case XML: {
                    ResultSetFormatter.outputAsXML((OutputStream)outputStream, (ResultSet)resultSet);
                    break;
                }
                default: {
                    throw new RDFServiceException("unrecognized result format");
                }
            }
            return new ByteArrayInputStream(outputStream.toByteArray());
        }

        @Override
        public void sparqlSelectQuery(String query, ResultSetConsumer consumer) throws RDFServiceException {
            this.s.sparqlSelectQuery(query, new ResultSetConsumer.Chaining(consumer){

                @Override
                public void processQuerySolution(QuerySolution qs) {
                    if (!SameAsFilteringRDFService.this.isRedundant(qs)) {
                        this.chainProcessQuerySolution(qs);
                    }
                }
            });
        }

        private boolean isRedundant(Statement s) {
            List<Resource> sameAsResources = this.getSameAsResources(s.getSubject());
            if (sameAsResources.size() > 0 && !sameAsResources.get(0).equals((Object)s.getSubject())) {
                return true;
            }
            if (s.getObject().isLiteral() || s.getObject().isAnon()) {
                return false;
            }
            sameAsResources = this.getSameAsResources(s.getObject().asResource());
            return sameAsResources.size() > 0 && !sameAsResources.get(0).equals((Object)s.getObject().asResource());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Resource> getSameAsResources(Resource resource) {
            ArrayList<Resource> sameAsResources = new ArrayList<Resource>();
            if (resource.isAnon()) {
                return sameAsResources;
            }
            String queryStr = "SELECT DISTINCT ?s WHERE { <" + resource.getURI() + "> <" + OWL.sameAs.getURI() + "> ?s } ORDER BY ?s";
            try {
                Query query = QueryFactory.create((String)queryStr);
                try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)SameAsFilteringRDFServiceFactory.this.sameAsModel);){
                    ResultSet rs = qe.execSelect();
                    while (rs.hasNext()) {
                        QuerySolution q = rs.next();
                        Resource res = q.getResource("s");
                        if (this.s == null) continue;
                        this.log.info((Object)("adding same as " + res.getURI()));
                        sameAsResources.add(res);
                    }
                }
                return sameAsResources;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isRedundant(QuerySolution q) {
            Iterator varIt = q.varNames();
            while (varIt.hasNext()) {
                Resource r;
                List<Resource> sames;
                String varName = (String)varIt.next();
                RDFNode n = q.get(varName);
                if (!n.isResource() || (sames = this.getSameAsResources(r = n.asResource())).size() <= 0 || sames.get(0).equals((Object)r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
            return this.s.changeSetUpdate(changeSet);
        }

        @Override
        public InputStream sparqlDescribeQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
            Model m = RDFServiceUtils.parseModel(this.s.sparqlConstructQuery(query, resultFormat), resultFormat);
            Model filtered = ModelFactory.createDefaultModel();
            StmtIterator stmtIt = m.listStatements();
            while (stmtIt.hasNext()) {
                Statement stmt = stmtIt.nextStatement();
                if (this.isRedundant(stmt)) continue;
                filtered.add(stmt);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            filtered.write((OutputStream)out, RDFServiceUtils.getSerializationFormatString(resultFormat));
            return new ByteArrayInputStream(out.toByteArray());
        }

        @Override
        public boolean sparqlAskQuery(String query) throws RDFServiceException {
            return this.s.sparqlAskQuery(query);
        }

        @Override
        public List<String> getGraphURIs() throws RDFServiceException {
            return this.s.getGraphURIs();
        }

        @Override
        public void getGraphMetadata() throws RDFServiceException {
            this.s.getGraphMetadata();
        }

        @Override
        public void serializeAll(OutputStream outputStream) throws RDFServiceException {
            this.s.serializeAll(outputStream);
        }

        @Override
        public void serializeGraph(String graphURI, OutputStream outputStream) throws RDFServiceException {
            this.s.serializeGraph(graphURI, outputStream);
        }

        @Override
        public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
            return this.s.isEquivalentGraph(graphURI, serializedGraph, serializationFormat);
        }

        @Override
        public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
            return this.s.isEquivalentGraph(graphURI, graph);
        }

        @Override
        public void close() {
            this.s.close();
        }
    }
}

