/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging.LoggingRDFServiceFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFServiceUtils {
    private static final Log log = LogFactory.getLog(RDFServiceUtils.class);
    private static final String RDFSERVICEFACTORY_ATTR = RDFServiceUtils.class.getName() + ".RDFServiceFactory";

    public static RDFServiceFactory getRDFServiceFactory(ServletContext context) {
        return RDFServiceUtils.getRDFServiceFactory(context, ModelAccess.WhichService.CONTENT);
    }

    public static RDFServiceFactory getRDFServiceFactory(ServletContext context, ModelAccess.WhichService which) {
        String attribute = RDFSERVICEFACTORY_ATTR + "." + which.name();
        Object o = context.getAttribute(attribute);
        if (o instanceof RDFServiceFactory) {
            RDFServiceFactory factory = (RDFServiceFactory)o;
            return new LoggingRDFServiceFactory(factory);
        }
        throw new IllegalStateException("Expecting an RDFServiceFactory on the context at '" + attribute + "', but found " + o);
    }

    public static void setRDFServiceFactory(ServletContext context, RDFServiceFactory factory) {
        RDFServiceUtils.setRDFServiceFactory(context, factory, ModelAccess.WhichService.CONTENT);
    }

    public static void setRDFServiceFactory(ServletContext context, RDFServiceFactory factory, ModelAccess.WhichService which) {
        String attribute = RDFSERVICEFACTORY_ATTR + "." + which.name();
        context.setAttribute(attribute, (Object)factory);
    }

    public static InputStream toInputStream(String serializedRDF) {
        try {
            return new ByteArrayInputStream(serializedRDF.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Model parseModel(InputStream in, RDFService.ModelSerializationFormat format) {
        Model model = ModelFactory.createDefaultModel();
        model.read(in, null, RDFServiceUtils.getSerializationFormatString(format));
        return model;
    }

    public static ResultsFormat getJenaResultSetFormat(RDFService.ResultFormat resultFormat) {
        switch (resultFormat) {
            case JSON: {
                return ResultsFormat.FMT_RS_JSON;
            }
            case CSV: {
                return ResultsFormat.FMT_RS_CSV;
            }
            case XML: {
                return ResultsFormat.FMT_RS_XML;
            }
            case TEXT: {
                return ResultsFormat.FMT_TEXT;
            }
        }
        throw new RuntimeException("unsupported ResultFormat");
    }

    public static String getSerializationFormatString(RDFService.ModelSerializationFormat format) {
        switch (format) {
            case RDFXML: {
                return "RDF/XML";
            }
            case N3: {
                return "N3";
            }
            case NTRIPLE: {
                return "N-TRIPLE";
            }
        }
        throw new RuntimeException("unexpected format in getSerializationFormatString");
    }

    public static RDFService.ModelSerializationFormat getSerializationFormatFromJenaString(String jenaString) {
        if ("N3".equals(jenaString) || "TTL".equals(jenaString) || "TURTLE".equals(jenaString)) {
            return RDFService.ModelSerializationFormat.N3;
        }
        if ("N-TRIPLE".equals(jenaString)) {
            return RDFService.ModelSerializationFormat.NTRIPLE;
        }
        if ("RDF/XML".equals(jenaString) || "RDF/XML-ABBREV".equals(jenaString)) {
            return RDFService.ModelSerializationFormat.RDFXML;
        }
        throw new RuntimeException("unrecognized format " + jenaString);
    }

    public static RDFService getRDFService(VitroRequest vreq) {
        return RDFServiceUtils.getRDFService(vreq, ModelAccess.WhichService.CONTENT);
    }

    public static RDFService getRDFService(VitroRequest vreq, ModelAccess.WhichService which) {
        return RDFServiceUtils.getRDFServiceFactory(vreq.getSession().getServletContext(), which).getRDFService();
    }

    public static ResultSet sparqlSelectQuery(String query, RDFService rdfService) {
        ResultSet resultSet = null;
        try {
            InputStream resultStream = rdfService.sparqlSelectQuery(query, RDFService.ResultFormat.JSON);
            resultSet = ResultSetFactory.fromJSON((InputStream)resultStream);
            return resultSet;
        }
        catch (RDFServiceException e) {
            log.error((Object)("error executing sparql select query: " + e.getMessage()));
            return resultSet;
        }
    }
}

