/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.sdb;

import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.sdb.StoreDesc;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.sdb.RDFServiceSDB;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFServiceFactorySDB
implements RDFServiceFactory {
    private static final Log log = LogFactory.getLog(RDFServiceFactorySDB.class);
    private DataSource ds;
    private StoreDesc storeDesc;
    private RDFService longTermRDFService;

    public RDFServiceFactorySDB(DataSource dataSource, StoreDesc storeDesc) {
        this.ds = dataSource;
        this.storeDesc = storeDesc;
        this.longTermRDFService = new RDFServiceSDB(dataSource, storeDesc);
    }

    @Override
    public RDFService getRDFService() {
        return this.longTermRDFService;
    }

    @Override
    public RDFService getShortTermRDFService() {
        try {
            RDFServiceSDB rdfService = new RDFServiceSDB(this.ds.getConnection(), this.storeDesc);
            for (ChangeListener changeListener : ((RDFServiceSDB)this.longTermRDFService).getRegisteredListeners()) {
                rdfService.registerListener(changeListener);
            }
            for (ModelChangedListener modelChangedListener : ((RDFServiceSDB)this.longTermRDFService).getRegisteredJenaModelChangedListeners()) {
                rdfService.registerJenaModelChangedListener(modelChangedListener);
            }
            return rdfService;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerListener(ChangeListener changeListener) throws RDFServiceException {
        this.longTermRDFService.registerListener(changeListener);
    }

    @Override
    public void unregisterListener(ChangeListener changeListener) throws RDFServiceException {
        this.longTermRDFService.unregisterListener(changeListener);
    }

    @Override
    public void registerJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.longTermRDFService.registerJenaModelChangedListener(changeListener);
    }

    @Override
    public void unregisterJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.longTermRDFService.unregisterJenaModelChangedListener(changeListener);
    }
}

